<!DOCTYPE html>
<html>
@php
    $site = DB::table('settings')->first();
@endphp

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link rel="icon" href="{{ asset($site && $site->favicon ? 'img/' . $site->favicon : 'img/logo.png') }}" />
    <title>@yield('title', 'Befaqul Madaris Qaqmi Software') || {{ Auth::user()->name }}</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">


    <!-- For mobile web app to be displayed in full screen -->
<meta name="mobile-web-app-capable" content="yes">
<meta name="apple-mobile-web-app-capable" content="yes">

<!-- For status bar -->
<meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">

<!-- For icons on home screen -->
<link rel="apple-touch-icon" href="{{ asset('images/icons/app-icon.png') }}">
<link rel="icon" href="{{ asset('images/icons/app-icon.png') }}" type="image/png">

<!-- Optional, for better performance on mobile -->
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no, minimal-ui">


    <link rel="stylesheet" href="{{ asset('backend/plugins/fontawesome-free/css/all.min.css') }}">
    <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
    <link rel="stylesheet" href="{{ asset('backend/dist/css/adminlte.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/dist/css/custom.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/plugins/daterangepicker/daterangepicker.css') }}">
    <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=IBM+Plex+Sans:wght@400&display=swap" rel="stylesheet">
    <link rel="manifest" href="{{ asset('manifest.json') }}">
<meta name="theme-color" content="#ffffff">


    <style>
        @font-face {
            font-family: 'SolaimanLipi';
            src: url('{{ asset('fonts/SolaimanLipi_Bold_10-03-12.ttf') }}') format('truetype');
            font-weight: 800;
            font-style: normal;
            unicode-range: U+0980-09FF; 
        }

        body {
             font-family: 'SolaimanLipi', 'times new roman', sans-serif;
    font-size: 18px;
            /* font-weight: 600 */
           
        }
    </style>

    @stack('css')
</head>

<body class="hold-transition sidebar-mini layout-fixed">
<script>
    if ('serviceWorker' in navigator) {
        window.addEventListener('load', function() {
            console.log('ServiceWorker registration');
            navigator.serviceWorker.register('{{ asset('service-worker.js') }}').then(function(registration) {
                console.log('ServiceWorker registered with scope:', registration.scope);
            }).catch(function(error) {
                console.log('ServiceWorker registration failed:', error);
            });
        });
    }
</script>


    <div class="wrapper">
        @include('dashboard.include.header')
        @include('dashboard.include.sidebar')
        @yield('content')
        @include('dashboard.include.footer')
    </div>

    <script src="{{ asset('backend/plugins/jquery/jquery.min.js') }}"></script>
    <script src="{{ asset('backend/plugins/jquery-ui/jquery-ui.min.js') }}"></script>
    <script src="{{ asset('backend/plugins/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ asset('backend/plugins/daterangepicker/daterangepicker.js') }}"></script>
    <script src="{{ asset('backend/dist/js/adminlte.js') }}"></script>
    @stack('js')
</body>

</html>
