@extends('dashboard.master')
@section('title', 'একাডেমিক বিভাগ')

@section('content')

    <style>
        .cool-card {
            background: linear-gradient(145deg, #fff, #f3f3f3);
            border-radius: 16px;
            box-shadow: 0 8px 20px rgba(0, 0, 0, .05);
            transition: .3s;
            padding: 30px 20px;
            text-align: center;
            position: relative;
            overflow: hidden;
            border: 1px solid #eee;
            cursor: pointer;
            margin-bottom: 20px
        }

        .cool-card:hover {
            background: linear-gradient(145deg, #f9f9f9, #fff);
            box-shadow: 0 10px 25px rgba(0, 0, 0, .08);
            transform: translateY(-5px)
        }

        .cool-card a.full-link {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: 1
        }

        .cool-card h5 {
            font-weight: 600;
            font-size: 18px;
            color: #333;
            margin-top: 15px;
            position: relative;
            z-index: 2
        }

        .cool-card img {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            object-fit: cover;
            border: 3px solid #ddd;
            padding: 5px;
            transition: .3s;
            z-index: 2;
            position: relative
        }

        .cool-card:hover img {
            transform: scale(1.1);
            border-color: #00a99d
        }

        .cool-card::after {
            content: "";
            position: absolute;
            bottom: -30px;
            right: -30px;
            width: 80px;
            height: 80px;
            background: rgba(0, 169, 157, .05);
            border-radius: 50%;
            z-index: 0
        }

        @media (max-width:575px) {
            .cool-card {
                padding: 20px 15px
            }

            .cool-card h5 {
                font-size: 16px
            }

            .cool-card img {
                width: 60px;
                height: 60px
            }
        }
    </style>

    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="page-title-wrapper">
                    <div class="page-title-heading d-flex align-items-center">
                        <div class="page-title-icon"><i class="nav-icon fas fa-mosque"></i></div>
                        <span class="ms-2"><b id="menuTitle">একাডেমিক বিভাগ</b></span>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                <div class="row" id="submenuContent">
                    @php
                        $menuItems = [
                            ['route' => 'exam', 'title' => 'পরীক্ষা এসাইন', 'perm' => 'exam.view'],
                            [
                                'route' => 'subject.grade',
                                'title' => 'গ্লোবাল গ্রেড সিস্টেম',
                                'perm' => 'global_grade.view',
                            ],
                            [
                                'route' => 'subject.wise.grade',
                                'title' => 'বিষয়ভিত্তিক গ্রেড সিস্টেম',
                                'perm' => 'subject_wise_grade.view',
                            ],
                            [
                                'route' => 'exam.wise.grade',
                                'title' => 'পরীক্ষা ভিত্তিক গ্রেড সিস্টেম',
                                'perm' => 'exam_wise_grade.view',
                            ],
                            ['route' => 'exam.routing', 'title' => 'পরীক্ষা রুটিন', 'perm' => 'exam_routine.view'],
                            ['route' => 'exam.seat', 'title' => 'সিট নাম্বার', 'perm' => 'exam_seat.view'],
                            ['route' => 'admitcard', 'title' => 'প্রবেশপত্র', 'perm' => 'admitcard.view'],
                            ['route' => 'results', 'title' => 'পরীক্ষা', 'perm' => 'exam_result.view'],
                            ['route' => 'result.sheet', 'title' => 'পরীক্ষার ফলাফল', 'perm' => 'exam_result.view'],
                            [
                                'route' => 'all.results',
                                'title' => 'সকল শিক্ষার্থীর ফলাফল',
                                'perm' => 'students_exam_result.view',
                            ],
                            [
                                'route' => 'student.comment',
                                'title' => 'পরীক্ষার মন্তব্য',
                                'perm' => 'students_comment.view',
                            ],
                            ['route' => 'student.neshab', 'title' => 'নেসাব', 'perm' => 'students_nesab.view'],
                            ['route' => 'student.book', 'title' => 'পাঠ্যসূচি', 'perm' => 'students_books.view'],
                            ['route' => 'sonad', 'title' => 'সনদ', 'perm' => 'sonod.view'],
                        ];

                        $site = DB::table('settings')->first();
                        $user = auth()->user();
                    @endphp

                    @foreach ($menuItems as $item)
                        @if ($user && ($user->role_id == 1 || $user->type == 1 || $user->canPerm($item['perm'] ?? '')))
                            <div class="col-lg-3 col-md-4 col-sm-6 col-12">
                                <div class="cool-card" onclick="window.location='{{ route($item['route']) }}'">
                                    <a href="{{ route($item['route']) }}" class="full-link"></a>
                                    <img src="{{ asset($site && $site->logo ? 'img/' . $site->logo : 'img/re.png') }}"
                                        alt="{{ $item['title'] }} Icon">
                                    <h5>{{ $item['title'] }}</h5>
                                </div>
                            </div>
                        @endif
                    @endforeach
                </div>
            </div>
        </section>
    </div>

@endsection
