@extends('dashboard.master')
@section('title', 'হেল্পলাইন ও সাপোর্ট')

@section('content')

<style>
    .custom-card {
        background-color: #ffffff; /* Pure white for a clean look */
        color: #000; /* Black text */
        border-radius: 12px;
        box-shadow: 0px 4px 12px rgba(0, 0, 0, 0.15);
        padding: 20px;
        text-align: center;
        transition: all 0.3s ease-in-out;
        position: relative;
        margin: 10px; /* Space around each card */
        border: 1px solid #f0f0f0;
        cursor: pointer; /* Makes the card feel interactive */
    }

    .custom-card:hover {
        box-shadow: 0px 6px 16px rgba(0, 0, 0, 0.2);
        transform: translateY(-5px);
        background-color: #f9f9f9;
    }

    .custom-card a {
        color: #000;
        text-decoration: none;
        font-weight: bold;
    }

    .custom-card .icon {
        margin-top: 15px;
    }

    /* Modern Image Styling */
    .custom-card .icon img {
        width: 65px;
        height: 65px;
        border-radius: 50%;
        object-fit: cover;
        border: 3px solid #ddd;
        padding: 5px;
        transition: all 0.3s ease-in-out;
    }

    .custom-card:hover .icon img {
        transform: scale(1.1);
        border-color: #555;
    }

    .custom-card-footer {
        position: absolute;
        bottom: 10px;
        right: 15px;
        font-size: 20px;
        color: #555;
        transition: all 0.3s ease-in-out;
    }

    .custom-card:hover .custom-card-footer {
        color: #222;
    }

    .row {
        margin-left: -10px;
        margin-right: -10px;
    }

    /* Makes the entire card clickable */
    .custom-card a.full-card-link {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        z-index: 1;
    }
</style>

<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="page-title-wrapper">
                <div class="page-title-heading">
                    <div class="page-title-icon">
                        <i class="nav-icon fas fa-mosque"></i>
                    </div>
                    <span><b id="menuTitle">হেল্পলাইন ও সাপোর্ট</b></span>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="row" id="helpContent">

                @php
                    $menuItems = [
                        ['route' => 'mosjid', 'title' => 'মসজিদ জমা-খরচ'],
                        ['route' => 'imam.salary', 'title' => 'ইমাম মোয়াজ্জিন বেতন'],
                        ['route' => 'imam.leave', 'title' => 'ছুটি'],
                        ['route' => 'area.salary', 'title' => 'এলাকার বেতন'],
                        ['route' => 'grave', 'title' => 'কবর'],
                        ['route' => 'construction', 'title' => 'নির্মাণ']
                    ];
                    $site = DB::table('settings')->first();
                @endphp

                @foreach ($menuItems as $item)
                    <div class="col-lg-3 col-md-4 col-sm-6 col-12">
                        <div class="custom-card" onclick="window.location='{{ route($item['route']) }}'">
                            <a href="{{ route($item['route']) }}" class="full-card-link"></a> <!-- Full card clickable -->
                            <div class="inner">
                                <p><b>{{ $item['title'] }}</b></p>
                            </div>
                            <div class="icon">
                                <img src="{{ asset($site && $site->logo ? 'img/'.$site->logo : 'img/re.png') }}" alt="{{ $item['title'] }} Icon">
                            </div>
                            <a href="{{ route($item['route']) }}" class="custom-card-footer">
                                <i class="fas fa-arrow-circle-right"></i>
                            </a>
                        </div>
                    </div>
                @endforeach

            </div>
        </div>
    </section>
</div>

@endsection
