@extends('dashboard.master')
@section('title', 'Create Money Receipt')
@push('css')
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.1/themes/base/jquery-ui.css">
<style>
    .bangla{
            font-weight: 0;
            font-size:15px;
        }
        .ui-datepicker-calendar {
            display: none;
        }
</style>
@endpush

@section('content')

<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Create Money Receipt</b>
					</span>
				</div>

				<div class="page-title-actions">
					<a title="Back Button" href="{{ URL::previous() }}" type="button" class="btn btn-sm btn-dark">
						<i class="fas fa-arrow-left mr-1"></i>
						Back
					</a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">
					<form enctype="multipart/form-data" action="{{ route('money-receipt.store') }}" method="POST">
						@csrf
						<div class="row">
							<div class="col-sm-3">
								<div class="form-group">
									<label for="receipt_no">Receipt No<span class="text-red">*</span></label>
									<input type="text" name="receipt_no" id="receipt_no " value="{{ $id + 1 }}" class="form-control" placeholder="receipt no" readonly>

									@error('receipt_no')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>
							<div class="col-sm-3">
								<div class="form-group">
									<label for="date">Date<span class="text-red">*</span></label>
									<input type="text" name="date" id="date" value="{{ date('Y-m-d') }}" class="form-control" placeholder="Enter date" readonly>

									@error('date')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

                            <div class="col-sm-6">
								<div class="form-group">
									<label for="name"><span class="bangla">নাম</span>/Student Name<span class="text-red">*</span></label>
									<input type="text" name="name" id="name" value="{{ old('name') }}" class="form-control @error('name') is-invalid @enderror" placeholder="নাম লিখুন" required>

									@error('name')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

                            <div class="col-sm-3">
								<div class="form-group">
									<label for="month"><span class="bangla">মাস</span>/Month<span class="text-red">*</span></label>
									<input type="text" name="month" id="month" value="{{ old('month') }}" class="form-control datepicker @error('month') is-invalid @enderror" placeholder="মাস লিখুন" required>

									@error('month')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>


                            <div class="col-sm-3">
								<div class="form-group">
									<label for="department"><span class="bangla">ক্লাস</span>/Class<span class="text-red">*</span></label>

									<select name="department_id" id="department_id" class="form-control @error('department_id') is-invalid @enderror">
										<option value=""><span class="bangla">ক্লাস নির্বাচন করুন</span></option>
                                        @foreach ($departments as $key => $department)
                                            <option value="{{ $department->id }}" > {{ $department->department_name }} </option>
                                        @endforeach
									</select>

									@error('department_id')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							<div class="col-sm-3">
								<div class="form-group">
									<label for="amount"><span class="bangla">পরিমাণ</span>/Amount <span class="text-red">*</span></label>
									<input type="text" name="amount" id="amount" value="{{ old('amount') }}" class="form-control @error('amount') is-invalid @enderror" placeholder="পরিমাণ লিখুন" required>

									@error('amount')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							<div class="col-sm-3">
								<div class="form-group">
									<label for="amount"><span class="bangla">মোবাইল </span>/Amount <span class="text-red">*</span></label>
									<input type="text" name="gurdian_mobile" id="gurdian_mobile" value="{{ old('amount') }}" class="form-control @error('amount') is-invalid @enderror" placeholder="মোবাইল  লিখুন" required>

									@error('amount')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							<div class="col-sm-6">
								<div class="form-group">
									<label for="in_word"><span class="bangla">কথায়</span>/In Word <span class="text-red">*</span></label>

                                    <textarea rows="3" name="in_word" id="in_word" class="form-control" placeholder="কথায় লিখুন" required>{!! old('in_word') !!}</textarea>

									@error('in_word')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							<div class="col-sm-6">
								<div class="form-group">
									<label for="received_purpose"><span class="bangla">বাবদ</span>/On Account Of<span class="text-red">*</span></label>
									<textarea rows="3" name="received_purpose" id="received_purpose" class="form-control" placeholder="বাবদ লিখুন" required>{!! old('received_purpose') !!}</textarea>

									@error('received_purpose')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							<div class="col-sm-12">
								<div class="form-group">
									<label for="note"><span class="bangla">বিঃদ্রঃ</span>/Note</label>
									<textarea rows="3" name="note" id="note" class="form-control" placeholder="বিঃদ্রঃ লিখুন">{!! old('note') !!}</textarea>

								</div>
							</div>

						</div>

						<div class="row mt-30">
							<div class="col-sm-12">
								<button type="submit" class="btn btn-success mr-2">Create</button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
	</section>
</div>

@push('js')
    <script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>

    <script>
    //    $(function () {
    //        $('#date').datepicker({
    //            dateFormat: 'dd MM yy'
    //        });
    //    });

       $(function() {
            $('#month').datepicker( {
            changeMonth: true,
            changeYear: true,
            showButtonPanel: true,
            yearRange:"-30:+100",
            dateFormat: 'MM-yy',
            onClose: function(dateText, inst) {
                $(this).datepicker('setDate', new Date(inst.selectedYear, inst.selectedMonth, 1));
            }
            });
        });
       </script>
@endpush
@endsection


