@extends('dashboard.master')
@section('title', 'Create Payment Receive')

@push('css')
    <link rel="stylesheet" href="https://code.jquery.com/ui/1.13.1/themes/base/jquery-ui.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
    <style>
        .ui-datepicker-calendar {
            display: none;
        }

        #student_id {
            text-align: center;
        }

        .select2-container .select2-selection--single {
            height: 38px;
        }
    </style>
@endpush

@section('content')

    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="page-title-wrapper">
                    <div class="page-title-heading">
                        <div class="page-title-icon">
                            <i class="nav-icon fas fa-mosque"></i>
                        </div>
                        <span><b>Create Payment Receive</b></span>
                    </div>
                    <div class="page-title-actions">
                        <a title="Back Button" href="{{ URL::previous() }}" type="button" class="btn btn-sm btn-dark">
                            <i class="fas fa-arrow-left mr-1"></i> Back
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                <div class="card">
                    <div class="card-body">

                        @if (session('error'))
                            <div class="alert alert-danger mt-2">
                                {{ session('error') }}
                            </div>
                        @endif

                        <form enctype="multipart/form-data" action="{{ route('payment.store.multi') }}" method="POST" id="payment_form">
                            @csrf
                            <div class="row">

                                <div class="col-sm-12" id="payment_info" style="display: none;">
                                    <label id="total_received_label"></label>
                                    <input type="hidden" name="due_type" id="due_type" value="new">
                                    <br>
                                    <label id="total_discount_label"></label>
                                    <br>
                                </div>

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="class_id">Class<span class="text-red">*</span></label>
                                        <select name="class_id" id="class_id" class="form-control select2" required>
                                            <option value="">Select One</option>
                                            @foreach ($classes as $class)
                                                <option value="{{ $class->id }}"
                                                    @if ($class->id == $request->class_id) selected @endif>
                                                    {{ $class->name ?? '' }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="student_id">Student</label>
                                        <select name="student_id" id="student_id" class="form-control select2">
                                            <option value="">Select One</option>

                                        </select>
                                    </div>
                                </div>

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="month">Month<span class="text-red">*</span></label>
                                        <select name="months[]" id="month"
                                            class="form-control select2 @error('month') is-invalid @enderror" required
                                            multiple>
                                            <option value="">Choose month</option>

                                        </select>
                                        @error('month')
                                            <span class="text-danger" role="alert">
                                                <p>{{ $message }}</p>
                                            </span>
                                        @enderror
                                    </div>
                                </div>



                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="amount">Total Amount</label>
                                        <input type="number" name="total_amount" id="total_amount"
                                            value="{{ old('amount') }}"
                                            class="form-control @error('amount') is-invalid @enderror total_amount" placeholder="amount"
                                            readonly>

                                        <input type="hidden" id="total_Previous_amount" value="0">
                                        <input type="hidden" id="total_previous_discount" value="0">
                                    </div>
                                </div>

                                <div class="col-md-12" id="payment_details">

                                </div>


                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="total_amount">Total Amount</label>
                                        <input type="number" name="total_amount" id="total_amount"
                                            value="{{ old('total_amount') }}" class="form-control total_amount"
                                            placeholder="Total Amount" readonly>
                                    </div>
                                    @error('total_amount')
                                        <span class="text-danger" role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>

                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="current_receive_amount">Receive Amount <span
                                                class="text-red">*</span></label>
                                        <input type="number" name="current_receive_amount" id="current_receive_amount"
                                            value="{{ old('current_receive_amount', 0) }}"
                                            class="form-control @error('current_receive_amount') is-invalid @enderror"
                                            placeholder="Current Receive Amount" required readonly>
                                        @error('current_receive_amount')
                                            <span class="text-danger" role="alert">
                                                <p>{{ $message }}</p>
                                            </span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="receive_amount">Total Receive Amount <span
                                                class="text-red">*</span></label>
                                        <input type="number" name="receive_amount" id="receive_amount"
                                            value="{{ old('receive_amount', 0) }}"
                                            class="form-control @error('receive_amount') is-invalid @enderror"
                                            placeholder="Receive Amount" required readonly>
                                        @error('receive_amount')
                                            <span class="text-danger" role="alert">
                                                <p>{{ $message }}</p>
                                            </span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="discount_amount">Total Discount Amount</label>
                                        <input type="number" name="discount_amount" id="discount_amount"
                                            value="{{ old('discount_amount', 0) }}" class="form-control"
                                            placeholder="Discount Amount" readonly>
                                    </div>

                                    @error('discount_amount')
                                        <span class="text-danger" role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>

                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="due_amount">Total Due Amount</label>
                                        <input type="number" name="due_amount" id="due_amount"
                                            value="{{ old('due_amount', 0) }}"
                                            class="form-control @error('due_amount') is-invalid @enderror"
                                            placeholder="Due Amount" readonly>
                                    </div>
                                </div>


                            </div>

                            <div class="col-md-12" id="newForm"></div>

                            <div class="row mt-30">
                                <div class="col-sm-12">
                                    <button type="submit" id="submit" class="btn btn-success mr-2">Save</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </section>
    </div>

    @push('js')
      @include('dashboard.payments.partials.payment_script_multi')
    @endpush
@endsection
