<!-- libs -->
<script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.4/moment.min.js"></script>

<script>
  window.addEventListener('pageshow', function(event) {
    if (event.persisted) { 
        window.location.reload();
    }
});
  // ======= Select2 init =======
  $('#student_id').select2();

  let selectedMonth = "{{ request('month') }}"; // optional preselect
  $('#month').select2({
    placeholder: 'Search and select month',
    ajax: {
      url: '{{ route('months.search') }}',
      dataType: 'json',
      delay: 250,
      data: function (params) { return { q: params.term }; },
      processResults: function (data) { return { results: data }; },
      cache: true
    },
    width: '100%'
  });

  if (selectedMonth) {
    $.ajax({ url: '{{ route('months.search') }}', dataType: 'json' })
      .then(function (data) {
        let option = data.find(item => item.id === selectedMonth);
        if (option) {
          let newOption = new Option(option.text, option.id, true, true);
          $('#month').append(newOption).trigger('change');
        }
      });
  }

  // ======= Trigger AJAX to load multi-month breakdown =======
  function triggerAjaxCall() {
    var student_id = @json($request->student_id) || $('#student_id').val();
    var month = $('#month').val(); // can be single or array
    var class_id = @json($request->class_id) || $('#class_id').val();
    var session_id = @json($studentSession) || $('#student_id').find(':selected').data('session_id');

    if (student_id && month && class_id && session_id) {
      $.ajax({
        url: "{{ route('student.payment_multi') }}",
        type: 'POST',
        data: {
          month: month,
          student_id: student_id,
          session_id: session_id,
          class_id: class_id,
          _token: '{{ csrf_token() }}'
        },
        success: function (data) {
          $('#payment_details').html(''); // Clear previous data
          let totalAmount = 0;
          let totalPreviousReceive = 0;
          let totalPreviousDiscount = 0;
          
          $.each(data.multiMonthBreakdown, function (monthKey, monthData) {
              console.log("data", data, "monthKey", monthKey, "monthData", monthData);
              totalAmount += monthData.totalAmount || 0;
              totalPreviousReceive += monthData.previousReceive || 0;
              totalPreviousDiscount += monthData.previousDiscount || 0;
            var monthFormatted = moment(monthKey).format("MMMM YYYY");
            if (monthData === 'paid') {
              toastr.success("এই মাসের সমস্ত পেমেন্ট পরিশোধ করা হয়েছে");
              $("#month option[value='" + monthKey + "']").remove();
              $("#month").trigger("change");
              $("#student_id").trigger("change");
              return; // skip render
            }else if(monthData === 'not-assign'){
 toastr.success("কোন তথ্য উপলব্ধ নেই");
              $("#month option[value='" + monthKey + "']").remove();
              $("#month").trigger("change");
              $("#student_id").trigger("change");
              return; // skip render
            }


            // Render month block (typeList rows come from backend)
            var html = `
              <section class="month-block" data-month="${monthKey}">
                <h5 class="text-primary mt-4">${monthFormatted}</h5>
                <div class="table-responsive">
                  <table class="table table-bordered table-striped typeListTable">
                    <thead>
                      <tr>
                        <th style="width:3%;">Enable</th>
                        <th>Type</th>
                        <th>Details</th>
                      </tr>
                    </thead>
                    <tbody>
                      ${monthData.typeList}
                    </tbody>
                  </table>
                </div>
              </section>`;
            $('#payment_details').append(html);
          });
          console.log("totalAmount", totalAmount, "totalPreviousReceive", totalPreviousReceive, "totalPreviousDiscount", totalPreviousDiscount);
          $('.total_amount').val(totalAmount);
          $('#total_Previous_amount').val(totalPreviousReceive);
          $('#total_previous_discount').val(totalPreviousDiscount);
         

          // After render, compute totals
          computeAllMonthsTotals();
          $('#payment_info').show();
        }
      });
    }
  }

  // ======= On ready & filters change =======
  $(document).ready(function () {
    $('#note_field').removeClass('col-sm-6').addClass('col-sm-12');
    $('#payment_info').hide();

    $('#student_id').on('change', triggerAjaxCall);
    $('#class_id').on('change', triggerAjaxCall);
    $(document).on('change', '#month', triggerAjaxCall);

    @if (Session::has('success'))
      toastr.options = { "closeButton": true, "progressBar": true, "timeOut": 2000 };
      toastr.success("{{ session('success') }}");
    @endif
    @if (Session::has('error'))
      toastr.options = { "closeButton": true, "progressBar": true };
      toastr.error("{{ session('error') }}");
    @endif
    @if (request()->student_id)
      $('#class_id').trigger('change');
    @endif
  });

  // ======= Load students by class =======
  $(document).on('change', '#class_id', function () {
    let class_id = $(this).val();
    let studentSelect = $('#student_id');
    studentSelect.empty().append('<option value="">Loading...</option>');

    if (class_id) {
      $.ajax({
        url: "{{ route('get.students.by.class') }}",
        type: "POST",
        data: { _token: "{{ csrf_token() }}", class_id: class_id },
        success: function (data) {
          studentSelect.empty().append('<option value="">Select One</option>');
          data.forEach(function (student) {
            studentSelect.append(
              '<option data-session_id="' + student.session_id + '" value="' + student.id + '" ' +
              (student.id == "{{ request()->student_id }}" ? 'selected' : '') + '>' +
              student.name + ' | ' + (student.register_no ?? '') + ' | ' + (student?.monthly_dis) + ' TK</option>'
            );
          });
        },
        error: function () {
          studentSelect.empty().append('<option value="">Error loading students</option>');
        }
      });
    } else {
      studentSelect.empty().append('<option value="">Select One</option>');
    }
  });

  // ======= Per-row calculation =======
  function rowCalculation($row, $outerTr) {
    let rowTotal    = parseFloat($row.find(".feeAmount").attr('data-amount')) || 0;
    let rowPaid     = parseFloat($row.find(".feePaid").val()) || 0;
    let rowDiscount = parseFloat($row.find(".feeDiscount").val()) || 0;
     let rowPreviousPaid = parseFloat($row.find(".feePreviousPaid").attr('data-amount')) || 0;
         let rowPreviousDiscount = parseFloat($row.find(".feePreviousDiscount").attr('data-amount')) || 0;

             var remaining = rowTotal - (rowPreviousPaid + rowPreviousDiscount);
                 var total = rowPaid + rowDiscount;

   
         if (total > remaining) {
             alert("Paid amount cannot be greater than total amount");
             $row.find(".feePaid").val(remaining.toFixed(2));
             $row.find(".feeDiscount").val(0);
             $row.find(".feeDue").val(0);
             SingleRowTotal($outerTr);
             return;
         }

     let rowDue = remaining - (rowPaid + rowDiscount);
  
    $row.find(".feeDue").val(rowDue.toFixed(2));

    SingleRowTotal($outerTr);


         console.log("ei row er total amount", $row, rowTotal);
  }

  // ======= Sum within a type row (outerTr) =======
  function SingleRowTotal(outerTr) {
    var $outerTr = $(outerTr);
    var total = 0, paid = 0, discount = 0, dueSum = 0;

    $outerTr.find('.feeAmount').each(function () {
      var $feeCell = $(this);
      var $r = $feeCell.closest('tr');

      if (!$r.find('.fee_checked').is(':checked')) return;

      var a   = parseFloat($feeCell.attr('data-amount')) || 0;
      var p   = parseFloat($r.find('.feePaid').val()) || 0;
      var d   = parseFloat($r.find('.feeDiscount').val()) || 0;
      var du  = parseFloat($r.find('.feeDue').val());
      if (isNaN(du)) du = Math.max(0, a - p - d);

      total += a;
      paid += p;
      discount += d;
      dueSum += du;
    });

    // optional: if you keep these type-level inputs in outerTr
    $outerTr.find('.rowFeesPaid').val(paid.toFixed(2));
    $outerTr.find('.rowFeesDiscount').val(discount.toFixed(2));
    $outerTr.find('.rowFeesDue').val(dueSum.toFixed(2));

    return { total, paid, discount, due: dueSum };
  }

  // ======= Per-month totals =======
  function computeMonthTotals(block) {
    var $block = $(block);
    var amount=0,
    paid=0, 
    discount=0, 
    due=0, 
    prevReceive=0, 
    prevDiscount=0;

    $block.find('tr.type-row').each(function () {
      var $typeTr = $(this);

      var $enable = $typeTr.find('.row-enable');
      if ($enable.length && !$enable.is(':checked')) return;

     prevReceive = parseFloat($typeTr.find('.prev-receive').val()) || 0;
        prevDiscount = parseFloat($typeTr.find('.prev-discount').val()) || 0;
        // console.log('prevReceive', prevReceive, 'prevDiscount', prevDiscount, $typeTr);

      $typeTr.find('.feeAmount').each(function () {
        var $cell = $(this);
        var $r = $cell.closest('tr');
        if (!$r.find('.fee_checked, .fee-row-check').is(':checked')) return;

        var a = parseFloat($cell.attr('data-amount')) || 0;
        var p = parseFloat($r.find('.feePaid').val()) || 0;
        var d = parseFloat($r.find('.feeDiscount').val()) || 0;
        var du= parseFloat($r.find('.feeDue').val());
        if (isNaN(du)) du = Math.max(0, a - p - d);

        // amount += a; 
        paid += p; 
        discount += d; 
        due += du;
      });
    });

    return {
      amount, paid, discount, due,
      prevReceive, prevDiscount,
      netDue: Math.max(0, amount - prevReceive - prevDiscount - paid - discount)
    };
  }

  // ======= All months grand totals (updates your summary inputs) =======
  function computeAllMonthsTotals() {
    var gAmount= $(".total_amount").val() || 0,
    gPaid=0,
    gDisc=0,
    gDue=0,
    gPrevR=0,
    gPrevD=0;
    let m; 
    $('.month-block').each(function () {
      
    m = computeMonthTotals(this);
    //   gAmount += m.amount;
      gPaid   += m.paid;
      gDisc   += m.discount;
      gDue    += m.due;
      gPrevR  += m.prevReceive;
      gPrevD  += m.prevDiscount;

    });

    var netDue = Math.max(0, gAmount - gPrevR - gPrevD - gPaid - gDisc);

    // Your global footer/inputs
    // $('.total_amount').val(gAmount.toFixed(2));                 // if it's an <input>

    console.log("ei month er total amount", gAmount, gPaid, gDisc, gDue, gPrevR, gPrevD, netDue,m);
    $('#current_receive_amount').val(gPaid.toFixed(2));
    let totalPaid = gPaid + gPrevR;
    let totalDiscount = gDisc + gPrevD;
    $('#receive_amount').val((totalPaid).toFixed(2));
    $('#discount_amount').val((totalDiscount).toFixed(2));
    $('#due_amount').val(netDue.toFixed(2));
  }

  // ======= Events: inputs & checkboxes =======
  // $(document).on("keyup change", ".feePaid, .feeDiscount", function () {
  //   let $row = $(this).closest("tr");                                // inner fee row
  //   const $outerTr = $(this).closest('.fee-table').closest('tr');    // type row
  //   const $block = $(this).closest('.month-block');                  // month block
  //   rowCalculation($row, $outerTr);
  //   computeMonthTotals($block);
  //   computeAllMonthsTotals();
  // });

  // Paid change
$(document).on("keyup", ".feePaid", function () {
  const $row     = $(this).closest("tr");
  const $outerTr = $(this).closest(".fee-table").closest("tr");
  const $block   = $(this).closest(".month-block");

  const rowTotal            = parseFloat($row.find(".feeAmount").attr("data-amount")) || 0;
  const rowPaid             = parseFloat($(this).val()) || 0;
  const rowDiscount         = parseFloat($row.find(".feeDiscount").val()) || 0;
  const rowPreviousPaid     = parseFloat($row.find(".feePreviousPaid").attr("data-amount")) || 0;
  const rowPreviousDiscount = parseFloat($row.find(".feePreviousDiscount").attr("data-amount")) || 0;

  const remaining = rowTotal - (rowPreviousPaid + rowPreviousDiscount);       // how much is left this row
  const totalTry  = rowPaid + rowDiscount;                                    // trying to allocate now
  const due       = rowTotal - (rowPreviousPaid + rowPreviousDiscount + rowDiscount + rowPaid);

  if (remaining < totalTry) {
    alert("Paid amount cannot be greater than total amount");
    $row.find(".feePaid").val(remaining.toFixed(2));
    $row.find(".feeDiscount").val(0);
    $row.find(".feeDue").val(0);
    SingleRowTotal($outerTr);
    computeMonthTotals($block);
    computeAllMonthsTotals();
    return;
  }

  $row.find(".feeDue").val((due < 0 ? 0 : due).toFixed(2));
  SingleRowTotal($outerTr);
  computeMonthTotals($block);
  computeAllMonthsTotals();
  console.log("ei row er total amount", $row, rowTotal, rowPaid, rowDiscount);
});

// Discount change
$(document).on("keyup", ".feeDiscount", function () {
  const $row     = $(this).closest("tr");
  const $outerTr = $(this).closest(".fee-table").closest("tr");
  const $block   = $(this).closest(".month-block");

  const rowTotal            = parseFloat($row.find(".feeAmount").attr("data-amount")) || 0;
  const rowPaid             = parseFloat($row.find(".feePaid").val()) || 0;
  const rowDiscount         = parseFloat($(this).val()) || 0;
  const rowPreviousPaid     = parseFloat($row.find(".feePreviousPaid").attr("data-amount")) || 0;
  const rowPreviousDiscount = parseFloat($row.find(".feePreviousDiscount").attr("data-amount")) || 0;

  const remaining = rowTotal - (rowPreviousPaid + rowPreviousDiscount);
  const paidCalc  = rowTotal - (rowPreviousPaid + rowPreviousDiscount + rowDiscount); // auto-calc paid

  if (paidCalc < 0) {
    alert("Paid amount cannot be greater than total amount");
    $row.find(".feePaid").val(0);
    $row.find(".feeDiscount").val(remaining.toFixed(2));
    $row.find(".feeDue").val(0);
    SingleRowTotal($outerTr);
    computeMonthTotals($block);
    computeAllMonthsTotals();
    return;
  }

  $row.find(".feePaid").val(paidCalc.toFixed(2));
  $row.find(".feeDue").val(0);
  SingleRowTotal($outerTr);
  computeMonthTotals($block);
  computeAllMonthsTotals();
  console.log("ei row er total amount", $row, rowTotal);
});

  // outer enable -> inner toggles
  $(document).on('change', '.row-enable', function () {
    var $outerTr = $(this).closest('tr');
    var $block   = $(this).closest('.month-block');
    var on = $(this).is(':checked');

    $outerTr.find('.fee-table .fee_checked, .fee-table .fee-row-check')
            .prop('checked', on).trigger('change');

    computeMonthTotals($block);
    computeAllMonthsTotals();
  });

  // inner checkbox -> update row-enable + (optional) disable inputs
  $(document).on('change', '.fee_checked, .fee-row-check', function () {
    var $outerTr = $(this).closest('.fee-table').closest('tr');
    if (!$outerTr.length) $outerTr = $(this).closest('table').closest('tr');

    var anyChecked = $outerTr.find('.fee_checked:checked, .fee-row-check:checked').length > 0;
    $outerTr.find('.row-enable').prop('checked', anyChecked);

    var $row = $(this).closest('tr');
    var on = $(this).is(':checked');
    $row.find('.feePaid, .feeDiscount').prop('disabled', !on);
    // if (!on) { $row.find('.feePaid, .feeDiscount').val('0.00'); $row.find('.feeDue').val('0.00'); }

    const $block = $(this).closest('.month-block');
    SingleRowTotal($outerTr);
    computeMonthTotals($block);
    computeAllMonthsTotals();
  });

  // Recompute after dynamic DOM updates (optional)
  $('#payment_details').on('DOMNodeInserted DOMNodeRemoved', function () {
    computeAllMonthsTotals();
  });



  //submit 
$(document).on('submit', '#payment_form', function(e) {
  const selectedMonths = $('#month').val() || [];
  // e.preventDefault();

  // Only enforce when multiple months are selected
  if (selectedMonths.length > 1) {
    const missing = selectedMonths.filter(m =>
      $('.fee_checked:checked[data-month="'+m+'"]').length === 0
    );

    // console.log("missing", missing);

    if (missing.length) {
      e.preventDefault();
      toastr.error('Each selected month needs at least one fee checked. Missing: ' + missing.join(', '));
      return false;
    }
  }

  // valid -> allow submit
  return true;
});

</script>
