@extends('dashboard.master')
@section('title', 'Payment Due')

@push('css')
<link rel="stylesheet" href="{{ asset('backend/DataTables/datatables.min.css') }}">
<link rel="stylesheet" href="{{ asset('backend/css/toggle.css') }}">
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet"/>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/css/iziToast.min.css" crossorigin="anonymous" referrerpolicy="no-referrer" />
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />

{{-- Make Select2 look/behave like Bootstrap form-control --}}
<style>
  .select2-container { width: 100% !important; }

  .select2-container--default .select2-selection--single {
    height: 38px; /* same as .form-control */
    border: 1px solid #ced4da;
    border-radius: .25rem;
    display: flex; align-items: center;
    padding-left: .5rem;
    background-color: #fff;
  }
  .select2-container--default .select2-selection--single .select2-selection__rendered {
    line-height: 38px; padding-left: 0; color: #495057;
  }
  .select2-container--default .select2-selection--single .select2-selection__placeholder {
    color: #6c757d;
  }
  .select2-container--default .select2-selection--single .select2-selection__arrow {
    height: 38px; right: .5rem;
  }

  /* Focus ring like Bootstrap */
  .select2-container--default .select2-selection--single:focus,
  .select2-container--default.select2-container--focus .select2-selection--single {
    border-color: #86b7fe;
    outline: 0;
    box-shadow: 0 0 0 .25rem rgba(13,110,253,.25);
  }

  /* Dropdown cosmetics + z-index safety inside cards/modals */
  .select2-container--default .select2-dropdown {
    border: 1px solid #ced4da; border-radius: .25rem; overflow: hidden;
  }
  .select2-container--default .select2-results__option--highlighted[aria-selected] {
    background-color: #0d6efd;
  }
  .select2-search--dropdown .select2-search__field {
    border: 1px solid #ced4da; border-radius: .25rem; padding: .375rem .75rem;
  }
  .select2-container .select2-dropdown { z-index: 1055; }
</style>
@endpush

@section('content')
<div class="content-wrapper">
  <div class="content-header">
    <div class="container-fluid">
      <div class="page-title-wrapper">
        <div class="page-title-heading">
          <div class="page-title-icon"><i class="nav-icon fas fa-mosque"></i></div>
          <span><b>Payment Due</b></span>
        </div>
      </div>
    </div>
  </div>

  <section class="content">
    <div class="container-fluid">
      <div class="card">
        <div class="card-body">

          {{-- Filters --}}
          <div class="row mb-3">
            {{-- Month (Select2 AJAX) --}}
            <div class="col-sm-3">
              <div class="form-group">
                <label for="month">Month <span class="text-red">*</span></label>
                <select name="month" id="month" class="form-control select2 @error('month') is-invalid @enderror">
                  <option value="">Choose month</option>
                </select>
                @error('month')
                  <span class="text-danger" role="alert"><p>{{ $message }}</p></span>
                @enderror
              </div>
            </div>

            {{-- Class --}}
            <div class="col-sm-3">
              <div class="form-group">
                <label for="filter_class">Class</label>
                <select id="filter_class" class="form-control">
                  <option value="">All Classes</option>
                  @foreach($classes as $c)
                    <option value="{{ $c->id }}">{{ $c->name }}</option>
                  @endforeach
                </select>
              </div>
            </div>

            <div class="col-sm-3 d-flex align-items-end">
              <button type="button" id="btn_reset" class="btn btn-secondary" style="margin: 15px">Reset</button>
            </div>
          </div>

          {{-- SUMMARY BOX --}}
          <div id="summary-box" class="alert mb-3" style="display:none;"></div>

          {{-- TABLE --}}
          <table id="data_table" class="table table-bordered table-striped data-table table-hover">
            <thead>
              <tr>
                <th>SN</th>
                <th>Month</th>
                <th>Class</th>
                <th>Details</th>
                <th>Action</th>
              </tr>
            </thead>
            <tbody></tbody>
          </table>

        </div>
      </div>
    </div>
  </section>
</div>
@endsection

@push('js')
<script src="{{ asset('backend/DataTables/datatables.min.js') }}"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/js/iziToast.min.js" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>

<script>
$(document).ready(function () {
  // Month Select2 (AJAX) — keep dropdown inside its column to avoid clipping
  $('#month').select2({
    placeholder: 'Search and select month',
    allowClear: true,
    width: '100%',
    dropdownParent: $('#month').closest('.form-group'),
    ajax: {
      url: '{{ route('months.search') }}',
      dataType: 'json',
      delay: 250,
      data: function (params) { return { q: params.term }; },
      processResults: function (data) { return { results: data }; }, // [{id:'YYYY-MM', text:'Aug-2025'}]
      cache: true
    }
  });

  // DataTable
  var dTable = $('#data_table').DataTable({
    order: [],
    lengthMenu: [[10,25,50,100,-1],[10,25,50,100,"All"]],
    processing: true,
    serverSide: true,
    responsive: false,
    scrollX: true,
    autoWidth: false,
    language: {
      processing: '<i class="ace-icon fa fa-spinner fa-spin orange bigger-500" style="font-size:60px;text-align:center;"></i>'
    },
    pagingType: "full_numbers",
    ajax: {
      url: "{{ route('payment.due') }}",
      type: "get",
      data: function (d) {
        d.month    = $('#month').val();         // 'YYYY-MM'
        d.class_id = $('#filter_class').val();  // class id
      }
    },
    columns: [
      { data: 'DT_RowIndex', name: 'DT_RowIndex', searchable: false },
      { data: 'month',       name: 'month' },
      { data: 'class',       name: 'class' },
      { data: 'details',     name: 'details' },
      { data: 'action',      searchable: false, orderable: false }
    ],
    dom: "<'row'<'col-sm-2'l><'col-sm-7 text-center'B><'col-sm-3'f>>tipr",
    buttons: [
      { extend: 'copy',  className: 'btn-sm btn-info',    title: 'Payment Due List', header: true, footer: true },
     {
    extend: 'excel',
    className: 'btn-sm btn-success',
    title: 'Payment Due List',
    header: true,
    footer: true,
    exportOptions: {
        columns: [0,1,2,3],  // include Details column (index 3)
        stripHtml: true      // ✅ preserve HTML inside Details
    }
},
      {
    extend: 'print',
    className: 'btn-sm btn-danger',
    title: 'Payment Due List',
    pageSize: 'A2',
    orientation: 'landscape',
     exportOptions: {
        columns: [0,1,2,3], // ✅ exclude Action column
        stripHtml: false
    },
    customize: function (win) {
        // Optional: add summary box at top
        const s = $('#summary-box').html() || '';
        $(win.document.body).prepend(`<div style="margin-bottom:10px;">${s}</div>`);
        // Optional: style Details table
        $(win.document.body).find('table').css('width','100%');
    }
},
      { extend: 'colvis', className: 'btn-sm btn-warning', text: 'Column Visibility',
        title: 'Column Visibility', columns: ':not(:first-child)' }
    ],
  });

  // Reset
  $('#btn_reset').on('click', function(){
    $('#month').val(null).trigger('change');
    $('#filter_class').val('');
    dTable.ajax.reload();
  });

  // Instant reload on change
  $('#month, #filter_class').on('change', function(){ dTable.ajax.reload(); });

  // Summary from server
  $('#data_table').on('xhr.dt', function (e, settings, json) {
    const box = $('#summary-box');
    if (json && json.summary) {
      const s = json.summary;
      const fmt = n => Number(n || 0).toLocaleString(undefined, {minimumFractionDigits: 2, maximumFractionDigits: 2});
      box.html(`
        <div class="d-flex flex-wrap gap-3 justify-content-between align-items-center">
          <div><strong>Total Students:</strong> ${s.students}</div>
          <div><strong>Assigned:</strong> ${fmt(s.assigned)}</div>
          <div><strong>Received:</strong> ${fmt(s.received)}</div>
          <div><strong>Discount:</strong> ${fmt(s.discount)}</div>
          <div><strong>Due:</strong> ${fmt(s.due)}</div>
        </div>
      `).show();
    } else {
      box.hide().empty();
    }
  });

  // Toastr flashes
  @if (Session::has('success'))
    toastr.options = { "closeButton": true, "progressBar": true, "timeOut": 2000 };
    toastr.success("{{ session('success') }}");
  @endif
  @if (Session::has('error'))
    toastr.options = { "closeButton": true, "progressBar": true };
    toastr.error("{{ session('error') }}");
  @endif
});
</script>
@endpush
