@extends('dashboard.master')
@section('title', 'Payment Due Details')

@push('css')
    <link rel="stylesheet" href="{{ asset('backend/DataTables/datatables.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/css/toggle.css') }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/css/iziToast.min.css" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.1.0-rc.0/css/select2.min.css" />

    {{-- Select2 → Bootstrap-like look --}}
    <style>
        .select2-container {
            width: 100% !important;
        }

        .select2-container--default .select2-selection--single {
            height: 38px;
            border: 1px solid #ced4da;
            border-radius: .25rem;
            display: flex;
            align-items: center;
            padding-left: .5rem;
            background: #fff;
        }

        .select2-container--default .select2-selection--single .select2-selection__rendered {
            line-height: 38px;
            padding-left: 0;
            color: #495057;
        }

        .select2-container--default .select2-selection--single .select2-selection__placeholder {
            color: #6c757d;
        }

        .select2-container--default .select2-selection--single .select2-selection__arrow {
            height: 38px;
            right: .5rem;
        }

        .select2-container--default .select2-selection--single:focus,
        .select2-container--default.select2-container--focus .select2-selection--single {
            border-color: #86b7fe;
            outline: 0;
            box-shadow: 0 0 0 .25rem rgba(13, 110, 253, .25);
        }

        .select2-container--default .select2-dropdown {
            border: 1px solid #ced4da;
            border-radius: .25rem;
            overflow: hidden;
        }

        .select2-search--dropdown .select2-search__field {
            border: 1px solid #ced4da;
            border-radius: .25rem;
            padding: .375rem .75rem;
        }

        .select2-container .select2-dropdown {
            z-index: 1055;
        }

        @media (max-width:576px) {
            .toolbar-left>* {
                margin-bottom: .5rem;
            }
        }
    </style>
@endpush

@section('content')
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="page-title-wrapper">
                    <div class="page-title-heading d-flex align-items-center">
                        <div class="page-title-icon"><i class="nav-icon fas fa-mosque"></i></div>
                        <span class="ms-2">
                            <b>Payment Due Details</b>
                            <p class="mb-0">{{ \Carbon\Carbon::parse($month)->format('F: Y') }}</p>
                        </span>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">

                {{-- Toolbar: left = filter controls, right = Send Message All --}}
                <div class="card mb-2">
                    <div class="card-body d-flex flex-wrap justify-content-between align-items-center">
                        <div class="toolbar-left d-flex flex-wrap align-items-center gap-2">
                            <label for="filter_fee_id" class="mb-0 me-2"><b>Filter by fee (Not Collect):</b></label>
                            <div style="min-width:280px">
                                <select id="filter_fee_id" class="form-control"></select>
                            </div>
                            <button type="button" id="apply_fee_filter" class="btn btn-primary btn-sm ms-2">Filter</button>
                            <button type="button" id="clear_fee_filter"
                                class="btn btn-outline-secondary btn-sm">Clear</button>
                        </div>

                        <div class="toolbar-right">
                            <button type="button" id="sendAllMessage" class="btn btn-success btn-sm">
                                <i class="fa fa-envelope"></i> Send Message All
                            </button>
                        </div>
                    </div>
                </div>

                <div class="card">
                    <div class="card-body">
                        <table id="data_table" class="table table-bordered table-striped data-table table-hover"
                            style="width:100%">
                            <thead>
                                <tr>
                                    <th>SN</th>
                                    <th>Name</th>
                                    <th>Details</th>
                                    <th>Fee Details</th>
                                    <th>Payment Details</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>
                </div>

                {{-- Transfer Modal (unchanged) --}}
                <div class="modal fade" id="transferModal" tabindex="-1" aria-hidden="true">
                    <div class="modal-dialog">
                        <form id="transferForm" method="POST" action="{{ route('payment.due.transfer') }}">
                            @csrf
                            <input type="hidden" name="student_id" id="tr_student_id">
                            <input type="hidden" name="class_id" id="tr_class_id">
                            <input type="hidden" name="month" id="tr_month">
                            <input type="hidden" name="date" id="tr_date">

                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title">Transfer to new receipt</h5>
                                    <button type="button" class="btn-close btn btn-primary" data-bs-dismiss="modal"
                                        aria-label="Close">x</button>
                                </div>

                                <div class="modal-body">
                                    <p class="mb-1"><strong>Student:</strong> <span id="tr_student_name"></span></p>
                                    <p class="mb-3"><strong>Month:</strong> <span id="tr_month_text"></span></p>

                                    <select name="fund_id" id="fund_id" class="form-control" required>
                                        <option value="">Select Fund</option>
                                        @foreach ($funds as $fund)
                                            <option value="{{ $fund->id }}">{{ $fund->name }}</option>
                                        @endforeach
                                    </select>

                                    <p class="text-muted mt-2">
                                        This will migrate OLD-format payments (FundDetail) for this student & month into NEW
                                        money receipts. Proceed?
                                    </p>
                                </div>

                                <div class="modal-footer">
                                    <button type="button" class="btn btn-light btn-close"
                                        data-bs-dismiss="modal">Cancel</button>
                                    <button type="submit" class="btn btn-warning">Confirm transfer</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>

            </div>
        </section>
    </div>
@endsection

@push('js')
    <script src="{{ asset('backend/DataTables/datatables.min.js') }}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/js/iziToast.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
    <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.1.0-rc.0/js/select2.full.min.js"></script>

    <script>
        $(document).ready(function() {
            const baseUrl =
                "{{ route('payment.due.details.month.class', ['month' => $month, 'class_id' => $class_id]) }}";

            // Fee dropdown (Select2)
            $('#filter_fee_id').select2({
                placeholder: 'Choose a fee',
                allowClear: true,
                width: '100%',
                dropdownParent: $('#filter_fee_id').closest('.card-body'),
                ajax: {
                    url: baseUrl,
                    dataType: 'json',
                    delay: 200,
                    data: params => ({
                        list_fees: 1,
                        q: params.term || ''
                    }),
                    processResults: data => ({
                        results: data
                    }),
                    cache: true
                }
            });

            // DataTable
            var dTable = $('#data_table').DataTable({
                order: [],
                lengthMenu: [
                    [10, 25, 50, 100, -1],
                    [10, 25, 50, 100, "All"]
                ],
                processing: true,
                serverSide: true,
                responsive: false,
                scrollX: true,
                autoWidth: false,
                scroller: {
                    loadingIndicator: false
                },
                language: {
                    processing: '<i class="ace-icon fa fa-spinner fa-spin orange bigger-500" style="font-size:60px;text-align:center;"></i>'
                },
                pagingType: "full_numbers",
                ajax: {
                    url: baseUrl,
                    type: "get",
                    data: function(d) {
                        d.filter_fee_id = $('#filter_fee_id').val() || '';
                    }
                },
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        searchable: false
                    },
                    {
                        data: 'name',
                        name: 'name'
                    },
                    {
                        data: 'details',
                        name: 'details'
                    },
                    {
                        data: 'fee_details',
                        name: 'fee_details'
                    },
                    {
                        data: 'payment_details',
                        name: 'payment_details'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        searchable: false,
                        orderable: false
                    }
                ],
                dom: "<'row'<'col-sm-2'l><'col-sm-7 text-center'B><'col-sm-3'f>>tipr",
                buttons: [{
                        extend: 'copy',
                        className: 'btn-sm btn-info',
                        title: 'Payment Due Details',
                        header: true,
                        footer: true
                    },
                    {
                        extend: 'excel',
                        className: 'btn-sm btn-success',
                        title: 'Payment Due Details',
                        header: true,
                        footer: true,
                        exportOptions: {
                            columns: [0, 1, 2, 3, 4, 5],
                            stripHtml: true
                        }
                    },
                    {
                        extend: 'print',
                        className: 'btn-sm btn-danger',
                        title: 'Payment Due Details',
                        pageSize: 'A2',
                        header: true,
                        footer: true,
                        orientation: 'landscape',
                        exportOptions: {
                              columns: [0, 1, 2, 3, 4],
                            stripHtml: false
                        }
                    },
                    {
                        extend: 'colvis',
                        className: 'btn-sm btn-warning',
                        text: 'Column Visibility',
                        title: 'Column Visibility',
                        columns: ':not(:first-child)'
                    }
                ],
            });

            // Filter / Clear actions
            $('#apply_fee_filter').on('click', function() {
                dTable.ajax.reload(null, true);
            });
            $('#filter_fee_id').on('change', function() {
                /* optional instant reload */
            });
            $('#clear_fee_filter').on('click', function() {
                $('#filter_fee_id').val(null).trigger('change');
                dTable.ajax.reload(null, true);
            });

            // Send All SMS (right side button)
            $('#sendAllMessage').on('click', function() {
                let studentData = [];
                $(".studentIds").each(function() {
                    studentData.push({
                        id: $(this).val(),
                        due: $(this).data("due")
                    });
                });

                $.ajax({
                    url: "{{ route('payment.send.sms.all') }}",
                    type: "POST",
                    data: {
                        _token: "{{ csrf_token() }}",
                        month: "{{ $month }}",
                        class_id: "{{ $class_id }}",
                        studentData: studentData
                    },
                    success: function(res) {
                        toastr.success(res.message);
                    },
                    error: function() {
                        toastr.error("Bulk SMS Failed");
                    }
                });
            });

            // Single SMS send (unchanged)
            $(document).on('click', '.send-sms', function() {
                const btn = $(this);
                let tr = btn.closest("tr");
                let due = tr.find('.studentIds').data('due') || 0;

                $.ajax({
                    url: "{{ route('payment.send.sms') }}",
                    type: "POST",
                    data: {
                        _token: "{{ csrf_token() }}",
                        student_id: $(this).data('student'),
                        month: $(this).data('month'),
                        class_id: $(this).data('class'),
                        due: due
                    },
                    success: function(res) {
                        toastr.success(res.message);
                    },
                    error: function() {
                        toastr.error("SMS Failed");
                    }
                });
            });

            // Modal open/close (unchanged)
            $(document).on('click', '.transfer-to-new', function() {
                $("#transferModal").modal('show');
                $('#tr_student_name').text($(this).data('name'));
                $('#tr_month_text').text($(this).data('month'));
                $('#tr_student_id').val($(this).data('student'));
                $('#tr_class_id').val($(this).data('class'));
                $('#tr_month').val($(this).data('month'));
            });
            $(document).on('click', '.btn-close', function() {
                $("#transferModal").modal('hide');
            });

            // Toastr flashes
            @if (Session::has('success'))
                toastr.options = {
                    "closeButton": true,
                    "progressBar": true,
                    "timeOut": 2000
                };
                toastr.success("{{ session('success') }}");
            @endif
            @if (Session::has('error'))
                toastr.options = {
                    "closeButton": true,
                    "progressBar": true
                };
                toastr.error("{{ session('error') }}");
            @endif
        });
    </script>
@endpush
