<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Student Payment Invoice</title>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
    <style>
        body,
        h2,
        p {
            margin: 0;
            padding: 0;
        }

        @page {
            size: A4 portrait;
            margin: 12mm 16mm;
            /* Reduced margins */
        }

        .company-header img,
        .company-footer img {
            width: 100%;
            height: 100px;
            /* Reduced height */
            object-fit: contain;
            display: block;
        }

        .invoice {
            width: 100%;
            max-width: 500px;
            /* Adjusted for A4 width */
            margin: auto;
            padding: 15px;
            /* Reduced padding */
            border: 1px solid #ddd;
            box-sizing: border-box;
            background-image: url('{{ asset('img/' . $design->invoice_bg) }}');
            background-size: 100% 100%;
            page-break-inside: avoid;
            overflow: hidden;
            /* Prevents content overflow */
        }

        .invoice-title {
            text-align: center;
            margin-bottom: 8px;
            /* Adjusted spacing */
            font-size: 18px;
            /* Adjusted font size */
        }

        .info {
            margin-bottom: 10px;
            /* Reduced spacing */
        }

        .info .row {
            display: flex;
            justify-content: space-between;
        }

        .col-left,
        .col-right {
            width: 48%;
            /* Adjusts the width of the left and right columns */
        }

        .info p {
            font-size: 16px;
            /* Ensure the font size stays consistent */
            margin-bottom: 4px;
            margin-left: 10px;
        }

        .col-right p {
            text-align: right;
            margin-right: 15px;
        }

        /* Invoice Table */
        table {
            width: 100%;
            border-collapse: collapse;
        }

        table th,
        table td {
            padding: 0px !important;
            text-align: left;
            border: 1px solid #ddd;
            font-size: 13px;
            /* Reduced font size */
        }

        table th {
            background-color: #f8f8f8;
            font-size: 14px;
        }

        .signature-section {
            font-size: 13px;
            margin-top: 8px;
        }

        .signature-section .row {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-top: 8px;
            /* Adjusted spacing */
        }

        .signature-section .col-6 {
            width: 48%;
        }

        .signature-section p {
            font-weight: bold;
            margin-top: 10px;
            text-align: left;
            margin-left: 15px;
            font-size: 12px;
        }

        .signature-section .col-6.text-right p {
            text-align: right;
            margin-right: 15px;
        }

        @media print {
            .company-header img {
                margin-top: -10px !important;

            }

            body {
                margin: 0;
                padding: 0;
            }

            .table th,
            .table td {
                background-color: transparent !important;
                font-size: 14px;
            }

            .info p {
                font-size: 14px;
            }

            .invoice {
                page-break-after: always;
            }
        }
    </style>

</head>

<body onload="auto_print()">

    <!-- Invoice -->
    <div class="invoice">
        <header class="company-header">
            @if ($design && $design->invoice_header)
                <img src="{{ asset('img/' . $design->invoice_header) }}" alt="Header Image">
            @endif
        </header>

        <div class="info">
            <h3 class="invoice-title">Money Receipt</h3>
            <div class="row">
                <div class="col-left">
                    @if($donarName)
                    <p><strong>Donar:</strong> {{ $donarName ?? '' }}</p>
                    @endif
                    <p><strong>Student:</strong> {{ $data->students->name ?? '--' }}</p>
                    @if (!$donarName)
                        <p><strong>Reg No:</strong> {{ $data->students->register_no ?? '--' }}</p>
                    @endif
                   
                    <p><strong>Class:</strong> {{ $data->students->stuclass->name ?? '--' }}</p>
                </div>
                <div class="col-right">
                    <p><strong>Date:</strong> {{ \Carbon\Carbon::parse($data->date)->format('d-m-Y') }}</p>
                    <p><strong>Month:</strong> {{ \Carbon\Carbon::parse($data->month)->format('F, Y') }}</p>
                    <p><strong>Receipt No:</strong> {{ $data->receipt_no ?? '--' }}</p>
                </div>
            </div>
        </div>

        <table class="table table-bordered mt-3">
            <thead>
                <tr>
                    <th>Type</th>
                    <th class="text-center">Details</th>
                    <th class="text-right">Amount</th>
                </tr>
            </thead>
            <tbody>

                @foreach ($fundDetailTypes as $fundDetailType)
                    <tr>
                        <td>
                            @if ($fundDetailType->fee_type == 'academic')
                            একাডেমিক
                            @elseif ($fundDetailType->fee_type == 'hostel')
                            আবাসিক 
                            @elseif ($fundDetailType->fee_type == 'other')
                            পরীক্ষা ফি 
                            @elseif ($fundDetailType->fee_type == 'onabashik')
                            অনাবাসিক
                            @elseif ($fundDetailType->fee_type == 'special')
                            স্পেশাল ফি 
                                
                            @endif
                        </td>
                        <td>
                            @if ($fundDetailType->fundDetails->count())
                                @foreach ($fundDetailType->fundDetails as $detail)
                                    {{ $detail->fee_name ?? '' }} - {{ $detail->amount ?? '' }} <br>
                                   
                                @endforeach
                            @else
                                @php
                                    $fundDetail = \App\Models\FundDetail::where('student_id', $data->student_id)
                                    ->where('month', $data->month)
                                    ->where('purpose','Student Monthly Payment') 
                                    ->pluck('fee_id')->toArray();

                                      $typeMap = [
                                                'academic'   => 1,
                                                'hostel'     => 2,
                                                'other'      => 3,
                                                'onabashik'  => 4,
                                                'special'    => 5,
                                            ];

                                          $typeId = $typeMap[$fundDetailType->fee_type] ?? null;
                                          @endphp
                                @if ($fundDetail)
                                    @foreach ($fundDetail as $key => $detail_id)
                                        @php
                                            $detail = \App\Models\StudentFee::where('type', $typeId)->find($detail_id);
                                        @endphp
                                
                                      @if ($detail)
                                        {{ $detail->name ?? '' }} -{{ $detail->amount ?? '' }}  <br>
                                       
                                       
                                      @endif
                                    @endforeach
                                    
                                @endif

                            @endif
                        
                        </td>
                        <td class="text-right">{{ $fundDetailType->receive ?? '' }}</td>
                    </tr>
                @endforeach


            </tbody>
            <tfoot>
                {{-- @dd($data) --}}
                <tr>
                    <td colspan="2" class="text-right"><strong>Total:</strong></td>
                    <td class="text-right"><strong>{{ $data->total ?? '' }}</strong></td>
                </tr>

                <tr>
                    <td colspan="2" class="text-right"><strong>Total Received:</strong></td>
                    <td class="text-right"><strong>{{ $data->amount ?? '' }}</strong></td>
                </tr>
              
                <tr>
                    <td colspan="2" class="text-right"><strong>Current Received:</strong></td>
                    <td class="text-right"><strong>{{ $data->current_receive ?? '' }}</strong></td>
                </tr>
                <tr>
                    <td colspan="2" class="text-right"><strong>Total Discount:</strong></td>
                    <td class="text-right"><strong>{{ $data->discount ?? '' }}</strong></td>
                </tr>
                <tr>
                    <td colspan="2" class="text-right"><strong>Total Due:</strong></td>
                    <td class="text-right"><strong>{{ $data->due ?? '' }}</strong></td>
                </tr>
            </tfoot>
        </table>

        <div class="d-flex justify-content-end mt-2">
            {{-- <div class="text-right" style="margin-right: 20px !important;">
                <p><span style="margin-right: 10px !important;"> Total
                        Amount:</span><strong>{{ $totalAmount ?? '' }}</strong></p>
                <p><span style="margin-right: 10px !important;">Previous
                        Received:</span><strong>{{ round($totalReceived - $data->amount) ?? '' }}</strong></p>
                <p><span style="margin-right: 10px !important;">Current
                        Received:</span><strong>{{ round($data->amount) ?? '' }}</strong></p>
                <p><span
                        style="margin-right: 10px !important;">Due:</span><strong>{{ $totalAmount - $totalReceived }}</strong>
                </p>
            </div> --}}
        </div>


        <div class="signature-section">
            <div class="row">
                <div class="col-6">
                    <p> ________________________<br>
                        <strong>Guardian's Signature</strong>
                    </p>
                </div>
                <div class="col-6 text-right">
                    <p> __________________________<br>
                        <strong>Account's Signature</strong>
                    </p>
                </div>
            </div>
        </div>

        <footer class="company-footer">
            @if ($design && $design->invoice_footer)
                <img src="{{ asset('img/' . $design->invoice_footer) }}" alt="Footer Image">
            @endif
        </footer>
    </div>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
    <script>
        function auto_print() {
            window.print();
        }
    </script>

</body>

</html>
