@extends('dashboard.master')
@section('title', 'Money Receipt Details')
@section('content')
    @push('css')
        <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
    @endpush

    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="page-title-wrapper">
                    <div class="page-title-heading">
                        <div class="page-title-icon">
                            <i class="nav-icon fas fa-mosque"></i>
                        </div>
                        <span>
                            <b>Money Receipt Details</b>
                        </span>
                    </div>

                    <div class="page-title-actions">

                        {{-- <a title="Edit" id="edit" href="{{ route('money-receipt.edit', $data->id) }}"
                            class="btn btn-sm btn-primary edit" title="Edit"><i class="fa fa-edit"></i> Edit</a> --}}

                        <a title="Back" href="{{ route('payment.list.new') }}" type="button"
                            class="btn btn-sm btn-dark">
                            <i class="fas fa-arrow-left mr-1"></i>
                            Receipt List
                        </a>
                        {{-- <a title="Create" target="_blank" href="{{ route('receipt-print', $data->id) }}" type="button"
                            class="btn btn-sm btn-danger">
                            <i class="fas fa-file mr-1"></i>
                            Print
                        </a> --}}
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-sm-12">
                                <table class="table table-bordered table-striped data-table table-hover">
                                    <tbody>
                                        <tr>
                                            <td width="30%">Receipt No</td>
                                            <td>{{ $data->receipt_no ?? '--' }}</td>

                                            <td>Date</td>
                                            <td>{{ $data->date ?? '--' }}</td>
                                        </tr>

                                        <tr>
                                            <td><span class="bangla">নাম</span>/Name</td>
                                            <td>{{ $data->student_name ?? '--' }}</td>
                                            <td><span class="bangla">ক্লাস</span>/Class</td>
                                            <td>{{ $data->class_name ?? '--' }}</td>
                                        </tr>


                                        <tr>
                                            <td><span class="bangla">সেশন</span>/Session</td>
                                            <td>{{ $data->session_name ?? '--' }}</td>
                                            <td><span class="bangla">মাস</span>/Month</td>
                                            <td>{{ $data->month ?? '--' }}</td>
                                        </tr>

                                        <tr>
                                            <td><span class="bangla">মোট টাকা</span>/Total Amount</td>
                                            <td>{{ $data->total_amount ?? '--' }} টাকা </td>

                                            <td><span class="bangla">পরিশোধ করা টাকা</span>/Received Amount</td>
                                            <td>{{ $data->receive_amount ?? '--' }} টাকা </td>
                                        </tr>


                                        <tr>
                                            <td><span class="bangla">ডিসকাউন্ট টাকা</span>/Discount Amount</td>
                                            <td>{{ $data->discount_amount ?? '--' }} টাকা</td>

                                            <td><span class="bangla">বাকি টাকা</span>/Due Amount</td>
                                            <td>{{ $data->due_amount ?? '--' }} টাকা</td>
                                        </tr>


                                    </tbody>
                                </table>
                            </div>

                            <div class="col-sm-12">
                                @if ($fundDetailType)
                                    <table class="table table-bordered table-striped data-table table-hover">
                                        <thead>
                                            <tr>
                                                <th>SN</th>
                                                <th>Type</th>
                                                <th>Date</th>
                                                <th>Month</th>
                                                <th>Total Amount</th>
                                                <th>Received Amount</th>
                                                <th>Discount Amount</th>
                                                <th>Due Amount</th>
                                                <th>Action</th>

                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($fundDetailType as $key => $value)
                                                <tr>
                                                    <td>{{ $key + 1 }}</td>
                                                    <td>{{ $value->fee_type ?? '--' }}</td>
                                                    <td>{{ $value->date ?? '--' }}</td>
                                                    <td>{{ $value->month ?? '--' }}</td>
                                                    <td>{{ $value->total ?? '--' }} টাকা</td>
                                                    <td>{{ $value->receive ?? '--' }} টাকা</td>
                                                    <td>{{ $value->discount ?? '--' }} টাকা</td>
                                                    <td>{{ $value->due ?? '--' }} টাকা</td>
                                                    <td>
                                                        {{-- @dd($value->fundDetail) --}}
                                                        <button type="button"
                                                            data-details="{{ json_encode($value->fundDetail ?? []) }}"
                                                            id="showFundDetail" data-id="{{ $value->id }}"
                                                            data-receive = "{{ $value->receive ?? 0 }}"
                                                            data-discount = "{{ $value->discount ?? 0 }}"
                                                            data-due = "{{ $value->due ?? 0 }}"
                                                            class="btn btn-sm btn-primary">
                                                            <i class="fas fa-eye mr-1"></i>Details
                                                        </button>


                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>

                                @endif
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Modal -->
        <div id="fundDetailModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="fundDetailModalLabel"
            aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="fundDetailModalLabel">Fund Details</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Fund Name</th>
                                    <th>Fee Name</th>
                                    <th>Amount</th>
                                </tr>
                            </thead>
                            <tbody id="fundDetailTableBody">
                                <!-- Rows will be added here dynamically -->
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td colspan="2">মোট</td>
                                    <td><span id="totalAmount"></span> টাকা</td>
                                   
                                </tr>
                                <tr>
                                    <td colspan="2">পরিশোধিত</td>
                                     <td><span id="totalReceive"></span> টাকা</td>
                                    
                                </tr>
                                <tr>
                                    <td colspan="2">ডিসকাউন্ট</td>
                                    <td><span id="totalDiscount"></span> টাকা</td>
                                    
                                </tr>
                                <tr>
                                    <td colspan="2">বাকি</td>
                                    <td><span id="totalDue"></span> টাকা</td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>


    </div>

    @push('js')
        <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
        <script>
            //  toastr.options.timeOut = 300;
            @if (Session::has('success'))
                toastr.options = {
                    "closeButton": true,
                    "progressBar": true,
                    "timeOut": 2000
                };

                toastr.success("{{ session('success') }}");
            @endif

            @if (Session::has('error'))
                toastr.options = {
                    "closeButton": true,
                    "progressBar": true
                };
                toastr.error("{{ session('error') }}");
            @endif

            $(document).on('click', '#showFundDetail', function() {
                $("#fundDetailModal").modal('show');
                let thisDetails = $(this).data('details');
                let receive = $(this).data('receive');
                let discount = $(this).data('discount');
                let due = $(this).data('due');
                console.log(thisDetails, receive, discount, due);

                // Clear previous rows
                $('#fundDetailTableBody').empty();
                let totalAmount = 0;
                // Loop through the details array and append rows to the table
                thisDetails.forEach(function(detail) {
                    let row = `
            <tr>
                <td>${detail.fund_name}</td>
                <td>${detail.fee_name}</td>
                <td>${detail.amount} টাকা </td>
            </tr>
        `;
                    totalAmount += parseFloat(detail.amount);
                    $('#totalAmount').text(totalAmount.toFixed(2));
                    $('#totalReceive').text(receive.toFixed(2));
                    $('#totalDiscount').text(discount.toFixed(2));
                    $('#totalDue').text(due.toFixed(2));
                    $('#fundDetailTableBody').append(row);
                });
            });
        </script>
    @endpush
@endsection
