@extends('dashboard.master')
@section('title', 'All Student Result')
@push('css')
    <link rel="stylesheet" href="{{ asset('backend/DataTables/datatables.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/css/toggle.css') }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/css/iziToast.min.css"
        integrity="sha512-O03ntXoVqaGUTAeAmvQ2YSzkCvclZEcPQu1eqloPaHfJ5RuNGiS4l+3duaidD801P50J28EHyonCV06CUlTSag=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />

    <?php
    $invoiceBgPath = 'back_height.jpg';
    if (isset($invoice->invoice_bg) && !empty($invoice->invoice_bg)) {
        $potentialBgFile = 'img/' . $invoice->invoice_bg;
        if (file_exists(public_path($potentialBgFile))) {
            $invoiceBgPath = $potentialBgFile;
        }
    }
    ?>
    <style>
        @media print {
            body * {
                visibility: hidden;
            }

            .result-table-container,
            .result-table-container * {
                visibility: visible;
            }

            .result-table-container {
                position: absolute;
                left: 0;
                top: 0;
                background-image: url('{{ asset($invoiceBgPath) }}') !important;
                background-size: cover !important;
                background-position: center !important;
                background-repeat: no-repeat !important;
                width: 100%;
            }

            

            #table_data{
                 background-image: url('{{ asset($invoiceBgPath) }}') !important;
                background-size: cover !important;
                background-position: center !important;
                background-repeat: no-repeat !important;
            }

            .container,
            .container-fluid,
            .content-wrapper>.content {
                padding: 0 !important;
            }

            .print-table th,
            .print-table td {
                background: transparent !important;
            }

            .btn-danger {
                display: none;
            }
        }

        th {
            writing-mode: vertical-rl;
            transform: rotate(180deg);
            /* font-size: 12px; */
            vertical-align: top !important;
            white-space: nowrap;
        }

        .header-image img {
            width: 100%;
        }
    </style>
@endpush

@section('content')

    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="page-title-wrapper">
                    <div class="page-title-heading">
                        <div class="page-title-icon">
                            <i class="nav-icon fas fa-mosque"></i>
                        </div>
                        <span>
                            <b>All Student Result</b>
                        </span>
                    </div>

                    <div class="page-title-actions">
                        <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                            <i class="fas fa-arrow-left mr-1"></i>
                            Back
                        </a>

                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                <div class="card">
                    <div class="card-body">

                        <div class="row">

                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label for="class_id">Select Class<span class="text-red">*</span></label>
                                    <select name="class_id" id="class_id" class="form-control">
                                        <option value="">Select One</option>
                                        @foreach ($classes as $item)
                                            <option value="{{ $item->id }}">{{ $item->name ?? '' }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label for="exam_id">Select Exam<span class="text-red">*</span>
                                        <span class="text-info" id="balance" style="display: none"></span>
                                    </label>
                                    <div class="d-flex">
                                        <select name="exam_id" id="exam_id" class="form-control">
                                            <option value="">Select One</option>
                                        </select>
                                    </div>
                                </div>
                            </div>


                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label for="session_id">Select Session<span class="text-red">*</span></label>
                                    <select name="session_id" id="session_id" class="form-control">
                                        <option value="">Select One</option>
                                        @foreach ($sessions as $session)
                                            <option value="{{ $session->id }}">{{ $session->name ?? '' }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>




                        </div>
                        <div class="col-md-12">
                            <button style="margin-left:2px;  !important" title="Search Button" type="submit" id="search"
                                class="btn btn-sm btn-primary float-left search"><i class="fa fa-search"></i>
                                Search</button>
                        </div>

                        <span id="table_data"></span>

                    </div>
                </div>
            </div>
        </section>
    </div>

    @push('js')
        <script src="{{ asset('backend/DataTables/datatables.min.js') }}"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/js/iziToast.min.js"
            integrity="sha512-Zq9o+E00xhhR/7vJ49mxFNJ0KQw1E1TMWkPTxrWcnpfEFDEXgUiwJHIKit93EW/XxE31HSI5GEOW06G6BF1AtA=="
            crossorigin="anonymous" referrerpolicy="no-referrer"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
        <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
        <script>
            $(document).ready(function() {
                $('#class_id').on('change', function() {
                    var class_id = $(this).val();

                    $.ajax({
                        url: "{{ route('class.wise.exam') }}",
                        type: 'POST',
                        data: {
                            class_id: class_id,
                            _token: '{{ csrf_token() }}'
                        },
                        success: function(data) {
                            $('#exam_id').empty();
                            $('#exam_id').append('<option value="">Select Exam</option>');
                            $.each(data, function(index, exam) {
                                $('#exam_id').append('<option value="' + exam.exam_id +
                                    '">' + exam.exam.name + '</option>');
                            });
                        }
                    });
                });

                $('#search').on('click', function(e) {
                    e.preventDefault();
                    var class_id = $('#class_id').val();
                    var exam_id = $('#exam_id').val();
                    var session_id = $('#session_id').val();

                    $.ajax({
                        url: "{{ route('class.wise.exam.result') }}",
                        type: 'POST',
                        data: {
                            class_id: class_id,
                            exam_id: exam_id,
                            session_id: session_id,
                            _token: '{{ csrf_token() }}'
                        },
                        success: function(response) {
                            $('#table_data').html(response.html);
                        }
                    });
                });

                $('.result-table-container').on('click', '.btn-danger', function() {
                    var printContent = $('.result-table-container').html();
                    var originalContents = $('body').html();

                    $('body').html(printContent);

                    window.print();

                    $('body').html(originalContents);
                });
            });


            @if (Session::has('success'))
                toastr.options = {
                    "closeButton": true,
                    "progressBar": true,
                    "timeOut": 1000
                };
                toastr.success("{{ session('success') }}");
            @endif

            @if (Session::has('error'))
                toastr.options = {
                    "closeButton": true,
                    "progressBar": true
                };
                toastr.error("{{ session('error') }}");
            @endif
        </script>
    @endpush
@endsection
