@extends('dashboard.master')
@section('title', 'Result')
@push('css')
    <link rel="stylesheet" href="{{ asset('backend/DataTables/datatables.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/css/toggle.css') }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/css/iziToast.min.css"
        integrity="sha512-O03ntXoVqaGUTAeAmvQ2YSzkCvclZEcPQu1eqloPaHfJ5RuNGiS4l+3duaidD801P50J28EHyonCV06CUlTSag=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />

    <style>
        .dropify-wrapper .dropify-message p {
            font-size: initial;
        }

        .swal-title {
            font-size: 17px;
            color: red;
            padding: 0;
        }

        .swal-text {
            margin-top: 5px !important;
            color: black;
            background-color: white;
            box-shadow: none;
        }

        .swal-modal {
            max-width: 299px;
            /* width: auto !important; */
            padding-top: 1px;
            margin-top: 1px;
            padding: 1px 1px;
            vertical-align: top;
        }
    </style>
@endpush

@section('content')

    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="page-title-wrapper">
                    <div class="page-title-heading">
                        <div class="page-title-icon">
                            <i class="nav-icon fas fa-mosque"></i>
                        </div>
                        <span>
                            <b>Result</b>
                        </span>
                    </div>

                    <div class="page-title-actions">
                        <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                            <i class="fas fa-arrow-left mr-1"></i>
                            Back
                        </a>
                        <a title="Create" href="{{ route('result.create.subject') }}" type="button"
                            class="btn btn-sm btn-primary">
                            <i class="fas fa-plus mr-1"></i>
                            Create by Subject Wise
                        </a>
                        <a title="Create" href="{{ route('result.create') }}" type="button" class="btn btn-sm btn-primary">
                            <i class="fas fa-plus mr-1"></i>
                            Create by Student Wise
                        </a>

                        {{-- <a href="{{ route('result.printAll') }}" class="btn btn-sm btn-success print-multiple">Print
                            Selected Results</a> --}}


                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                {{-- Filter Section --}}
                <div class="card filter-section">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="exam_id">পরীক্ষার নাম:</label>
                                    <select name="exam_id" id="exam_id" class="form-control select2">
                                        <option value="">সকল পরীক্ষা</option>
                                        {{-- এখানে আপনার পরীক্ষার অপশনগুলো PHP লুপের মাধ্যমে আসবে --}}
                                        @foreach ($exams as $exam)
                                            <option value="{{ $exam->id }}">{{ $exam->name }}</option>
                                        @endforeach

                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="class_id">শ্রেণী:</label>
                                    <select name="class_id" id="class_id" class="form-control select2">
                                        <option value="">সকল শ্রেণী</option>
                                        {{-- এখানে আপনার শ্রেণীর অপশনগুলো PHP লুপের মাধ্যমে আসবে --}}
                                        @foreach ($classes as $class)
                                            <option value="{{ $class->id }}">{{ $class->name }}</option>
                                        @endforeach

                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="session_id">শিক্ষাবর্ষ:</label>
                                    <select name="session_id" id="session_id" class="form-control select2">
                                        <option value="">সকল শিক্ষাবর্ষ</option>
                                        {{-- এখানে আপনার শিক্ষাবর্ষের অপশনগুলো PHP লুপের মাধ্যমে আসবে --}}
                                        @foreach ($sessions as $session)
                                            <option value="{{ $session->id }}">{{ $session->name }}</option>
                                        @endforeach

                                    </select>
                                </div>
                            </div>
                            <div class="col-md-12 text-right mt-2">
                                <button type="button" id="filterButton" class="btn btn-info">
                                    <i class="fas fa-filter mr-1"></i> ফিল্টার করুন
                                </button>
                                <button type="button" id="clearFilterButton" class="btn btn-warning ml-2">
                                    <i class="fas fa-times mr-1"></i> ফিল্টার মুছে ফেলুন
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                {{-- End Filter Section --}}
                <div class="card">
                    <div class="card-body">
                        <table id="data_table" class="table table-bordered table-striped data-table table-hover">
                            <thead>
                                <tr>
                                    <th>SN</th>
                                    <th>Date</th>
                                    <th>Student</th>
                                    <th>Exam</th>
                                    <th>Session</th>
                                    <th>Class</th>
                                    <th>Subject Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </section>
    </div>

    @push('js')
        <script src="{{ asset('backend/DataTables/datatables.min.js') }}"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/js/iziToast.min.js"
            integrity="sha512-Zq9o+E00xhhR/7vJ49mxFNJ0KQw1E1TMWkPTxrWcnpfEFDEXgUiwJHIKit93EW/XxE31HSI5GEOW06G6BF1AtA=="
            crossorigin="anonymous" referrerpolicy="no-referrer"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
        <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
        <script>
            $(document).ready(function() {
                var dTable = $('#data_table').DataTable({
                    order: [],
                    lengthMenu: [
                        [10, 25, 50, 100, -1],
                        [10, 25, 50, 100, "All"]
                    ],
                    processing: true,
                    responsive: false,
                    serverSide: true,
                    scrollX: true,
                    autoWidth: false,
                    scroller: {
                        loadingIndicator: false
                    },
                    language: {
                        processing: '<i class="ace-icon fa fa-spinner fa-spin orange bigger-500" style="font-size:60px;text-align:center;"></i>'
                    },
                    pagingType: "full_numbers",
                    ajax: {
                        url: "{{ route('results') }}",
                        data: function(d) {

                            d.exam_id = $('#exam_id').val();
                            d.class_id = $('#class_id').val();
                            d.session_id = $('#session_id').val();
                        },
                        type: "get"
                    },

                    columns: [{
                            data: 'DT_RowIndex',
                            name: 'DT_RowIndex',
                            searchable: true,
                            orderable: true
                        },
                        {
                            data: 'date',
                            name: 'date'
                        },
                        {
                            data: 'student',
                            name: 'student'
                        },
                        {
                            data: 'exam',
                            name: 'exam'
                        },
                        {
                            data: 'session',
                            name: 'session'
                        },
                        {
                            data: 'class',
                            name: 'class'
                        },
                        {
                            data: 'subject_status',
                            name: 'subject_status'
                        },
                        {
                            data: 'action',
                            searchable: false,
                            orderable: false
                        }
                    ],
                    dom: "<'row'<'col-sm-2'l><'col-sm-7 text-center'B><'col-sm-3'f>>tipr",
                    buttons: [{
                            extend: 'copy',
                            className: 'btn-sm btn-info',
                            title: 'Result List',
                            header: true,
                            footer: true,
                        },
                        {
                            extend: 'excel',
                            className: 'btn-sm btn-success',
                            title: 'Result',
                            exportOptions: {
                                columns: [0, 1, 2, 3, 4, 5, 6],
                                stripHtml: true
                            }
                        },
                        {
                            extend: 'print',
                            className: 'btn-sm btn-danger',
                            title: 'Result List',
                            pageSize: 'A2',
                            header: true,
                            footer: true,
                            orientation: 'landscape',
                            exportOptions: {
                                columns: ':visible'
                            }
                        },
                        {
                            extend: 'colvis',
                            className: 'btn-sm btn-warning',
                            text: 'Column Visibility',
                            title: 'Column Visibility',
                            columns: ':not(:first-child)'
                        }
                    ],
                });
                $('#filterButton').on('click', function() {
                    dTable.ajax.reload();
                });

                // ফিল্টার মুছে ফেলার বাটন
                $('#clearFilterButton').on('click', function() {
                    $('#exam_id').val('').trigger('change'); // Select2 ব্যবহার করলে .trigger('change') জরুরি
                    $('#class_id').val('').trigger('change');
                    $('#session_id').val('').trigger('change');
                    dTable.ajax.reload(); // ফিল্টার মুছে ফেলার পর ডাটাটেবিল রিলোড করুন
                });
            });

            $('#data_table').on('click', '.btn-delete[data-remote]', function(e) {
                e.preventDefault();

                $.ajaxSetup({
                    headers: {
                        "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
                    }
                });

                const url = $(this).data('remote');
                swal({
                    title: `Are you sure?`,
                    text: "Want to delete this record?",
                    buttons: true,
                    dangerMode: true,
                }).then((willDelete) => {
                    if (willDelete) {
                        $.ajax({
                            url: url,
                            type: 'get',
                            dataType: 'json',
                            data: {
                                submit: true,
                                _method: 'delete',
                                _token: "{{ csrf_token() }}"
                            }
                        }).always(function(data) {
                            $('#data_table').DataTable().ajax.reload();
                            if (data.success === true) {
                                toastr.success(data.message, {
                                    positionClass: 'toast-bottom-full-width',
                                });
                            } else {
                                toastr.error(data.message, {
                                    positionClass: 'toast-bottom-full-width',
                                });
                            }
                        });
                    }
                });
            });

            //toastr.options.timeOut = 300;
            @if (Session::has('success'))
                toastr.options = {
                    "closeButton": true,
                    "progressBar": true,
                    "timeOut": 1000
                };
                toastr.success("{{ session('success') }}");
            @endif

            @if (Session::has('error'))
                toastr.options = {
                    "closeButton": true,
                    "progressBar": true
                };
                toastr.error("{{ session('error') }}");
            @endif


            $(document).on('click', '.print-multiple', function(e) {
                e.preventDefault();

                var ids = [];
                $('.result_ids').each(function() {
                    ids.push($(this).val());
                });
                console.log("ids", ids);

                if (ids.length === 0) {
                    toastr.warning({
                        title: 'Warning',
                        message: 'Please select at least one result to print.',
                        position: 'topRight'
                    });
                    return;
                }

                var form = $('<form>', {
                    action: $(this).attr('href'),
                    method: 'POST',
                    target: '_blank'
                });

                form.append($('<input>', {
                    type: 'hidden',
                    name: '_token',
                    value: '{{ csrf_token() }}'
                }));

                ids.forEach(id => {
                    form.append($('<input>', {
                        type: 'hidden',
                        name: 'result_ids[]',
                        value: id
                    }));
                });

                $('body').append(form);
                form.submit();
                form.remove();
            });
        </script>
    @endpush
@endsection
