<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
   <link rel="stylesheet" href="{{ asset('backend/plugins/fontawesome-free/css/all.min.css') }}">
    <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
    <link rel="stylesheet" href="{{ asset('backend/dist/css/adminlte.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/dist/css/custom.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/plugins/daterangepicker/daterangepicker.css') }}">
    <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=IBM+Plex+Sans:wght@400&display=swap" rel="stylesheet">
  <title>All Results</title>
  <style>
    @media print {
        
        @page {
            size: A4 portrait;
            
            margin: 0;
           
             
        }

        html,body{
          
            margin: 0;
            padding: 0;
            font-family: 'Noto Sans Bengali', sans-serif;
            font-size: 12px;
          
            /* page-break-after: always; */
            color: #000;
        }

        #data_table th, #data_table td{
            background-color: transparent !important;
        }

         body::before {
                content: "";
                position: fixed;
                top: 10mm;
                left: 10mm;
                right: 10mm;
                bottom: 10mm;
            
                box-shadow: 0 0 5px rgba(0,0,0,0.2); /* ⬛ Soft shadow */
                z-index: 9999;
                pointer-events: none;
            }

        .marksheet {
            margin: 10mm auto;
            padding: 20px;
            position: relative;
                border: 6px double #000; /* 🟩 Thick double border */

            /* width: calc(100% - 20mm); */
            page-break-after: always;
            /* border: 6px double #000; */
            /* box-shadow: 0 0 5px rgba(0,0,0,0.1); */
            
         
        }

        .marksheet:last-child {
            page-break-after: auto;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th, td {
            border: 1px solid #000;
            padding: 6px;
            text-align: center;
        }

        #data_table th, #data_table td {
            background-color: transparent !important;
        }
    }
    .marksheet {
            margin: 10mm auto;
            padding: 20px;
            position: relative;
            width: calc(100% - 20mm);
            page-break-after: always;
            /* border: 6px double #000; */
            /* box-shadow: 0 0 5px rgba(0,0,0,0.1); */
              background-image: url('{{ asset('img/' . $invoice->invoice_bg) }}');
            background-size: cover;
            /* background-size: 100% 100%; */
            background-position: center;
            background-repeat: no-repeat;
         
        }
  </style>
</head>
<body>

@foreach($allData as $item)
@php
    $data = $item['data'];
    $results = $item['results'];
    $avgGrade = $item['avgGrade'];
@endphp

<div class="marksheet">
    {{-- Header Image --}}
    <img src="{{ asset('img/' . $invoice->invoice_header) }}" alt="Header" style="max-width:100%; height:auto;">

    {{-- Student Photo --}}
    @if ($data->students->image)
    <div style="position: absolute; top: 20px; right: 20px; width: 18%; height: 180px; border: 2px solid #ccc; padding: 2px; background: #fff;">
        <img src="{{ asset('backend/img/student/' . $data->students->image) }}" alt="Student Photo" style="width: 100%; height: 100%; object-fit: cover;">
    </div>
    @endif

    {{-- Title --}}
    <h2 style="text-align:center">{{ $data->exam->name ?? '' }} <br> Marksheet</h2>

    {{-- Student Info --}}
    <div style="display:flex; justify-content:space-between; margin-bottom: 20px;">
        <div style="text-align:left; width: 48%;">
            <p><strong>Name:</strong> {{ $data->students->name ?? '' }}</p>
            <p><strong>Roll No:</strong> {{ $data->students->roll_no ?? '' }}</p>
            <p><strong>Register No:</strong> {{ $data->students->register_no ?? '' }}</p>
        </div>
        <div style="text-align:right; width: 48%;">
            <p><strong>Class:</strong> {{ $data->stuclass->name ?? '' }}</p>
            <p><strong>Year:</strong> {{ $data->stusession->name ?? '' }}</p>
            <p><strong>Merit Position:</strong> {{ $data->merit_position ?? '' }}</p>
        </div>
    </div>

    {{-- Mark Table --}}
    <table id="data_table" class="table table-bordered table-striped data-table table-hover">
        <thead>
            <tr>
                <th>#</th>
                <th>Subject</th>
                <th>Subject Mark</th>
                <th>Obtained</th>
                <th>Grade</th>
                <th>GPA</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($results as $key => $result)
            <tr>
                <td>{{ $loop->iteration }}</td>
                <td>{{ $result->subjects->name ?? '' }}</td>
                <td>{{ $result->exam_mark ?? '' }}</td>
                <td>{{ $result->mark ?? '' }}</td>
                <td>{{ $result->grade ?? 'N/A' }}</td>
                <td>{{ $result->gpa ?? 'N/A' }}</td>
            </tr>
            @endforeach
        </tbody>
        <tfoot>
            <tr>
                <td colspan="2"><strong>Total</strong></td>
                <td><strong>{{ $item['totalExamMark'] }}</strong></td>
                <td><strong>{{ $item['totalMark'] }}</strong></td>
                <td>Grade: <strong>{{ $avgGrade->name ?? 'N/A' }}</strong></td>
                <td>GPA: <strong>{{ $item['avgGpa'] }}</strong></td>
            </tr>
        </tfoot>
    </table>

    {{-- Signature Section --}}
    <div style="width: 100%; display: flex; justify-content: space-between; margin-top: 70px;">
        <div style="width: 30%; text-align: center;">
            <div style="border-top: 1px solid #000; padding-top: 5px;">
                Teacher Signature
            </div>
        </div>
        <div style="width: 30%; text-align: center;">
            <div style="border-top: 1px solid #000; padding-top: 5px;">
                Guardian Signature
            </div>
        </div>
        <div style="width: 30%; text-align: center;">
            <div style="border-top: 1px solid #000; padding-top: 5px;">
                Principal Signature
            </div>
        </div>
    </div>

    {{-- Footer --}}
    <img src="{{ asset('img/' . $invoice->invoice_footer) }}" alt="Footer" style="max-width:100%; height:auto;">
</div>
@endforeach
 <script src="{{ asset('backend/plugins/jquery/jquery.min.js') }}"></script>
    <script src="{{ asset('backend/plugins/jquery-ui/jquery-ui.min.js') }}"></script>
    <script src="{{ asset('backend/plugins/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ asset('backend/plugins/daterangepicker/daterangepicker.js') }}"></script>
    <script src="{{ asset('backend/dist/js/adminlte.js') }}"></script>
<script>
    window.onload = () => window.print();
</script>

</body>
</html>
