@extends('dashboard.master')
@section('title', 'Result Details')
@section('content')
@push('css')
<style>
    @media print {
        @page {
            size: A4;
            margin: 0;

        }

        /* html, body {
            height: 100%;
            margin: 0;
            padding: 0;
        } */

      

        /* Full-page border */
        body::before {
                content: "";
                position: fixed;
                top: 10mm;
                left: 10mm;
                right: 10mm;
                bottom: 10mm;
                /* border: 6px double #000; */

                box-shadow: 0 0 5px rgba(0,0,0,0.2); 
                z-index: 9999;
                pointer-events: none;
            }


   

        /* Hide everything initially */
        body * {
            visibility: hidden;
        }


        

        /* Make marksheet and its contents visible */
        .marksheet,
        .marksheet * {
            visibility: visible;
        }

        .student-info,
        .student-info * {
            visibility: visible !important;
        }

        .marksheet {
            margin: 0 auto;
            padding: 20px;
            position: relative;
            top: 10px;
            left: 0;
            width: 100%;
              border: 6px double #000; /* 🟩 Thick double border */
            page-break-inside: avoid;
        }

        .student-info {
            justify-content: space-between;
            width: 100% !important;
            margin-bottom: 20px;
        }

        .nameSection,
        .classSection {
            width: 48%;
        }

        .marksheet h2 {
            text-align: center;
            margin-bottom: 30px;
        }

        html,body{
          
            margin: 0;
            padding: 0;
            font-family: 'Noto Sans Bengali', sans-serif;
            font-size: 12px;
            background-image: url('{{ asset('img/' . $invoice->invoice_bg) }}');
            background-size: cover;
            /* background-size: 100% 100%; */
            background-position: center;
            background-repeat: no-repeat;
            color: #000;
        }

        #data_table th, #data_table td{
            background-color: transparent !important;
        }
    }

    
         .card{
          
            margin: 0;
            padding: 0;
            font-family: 'Noto Sans Bengali', sans-serif;
            font-size: 12px;
            background-image: url('{{ asset('img/' . $invoice->invoice_bg) }}');
            background-size: cover;
            /* background-size: 100% 100%;  */
            background-position: center;
            background-repeat: no-repeat;
            color: #000;
        }
</style>
@endpush

    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="page-title-wrapper">
                    <div class="page-title-heading">
                        <div class="page-title-icon">
                            <i class="nav-icon fas fa-mosque"></i>
                        </div>
                        <span>
                            <b>Result Details</b>
                            <p style="font-size:12px">Print on an a5 page</p>
                        </span>
                    </div>

                    <div class="page-title-actions">
                        <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                            <i class="fas fa-arrow-left mr-1"></i>
                            Back
                        </a>
                        <a title="Create" href="{{ route('result.create') }}" type="button" class="btn btn-sm btn-primary">
                            <i class="fas fa-plus mr-1"></i>
                            Create
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                <div class="card">
                    <div class="card-body">
                         <!---markshit update by ashiq  start 202.5.25 --->
                        <div class="marksheet" style="position:relative;">
                            <img src="{{ asset('img/' . $invoice->invoice_header) }}" alt="Header"
                                style="max-width:100%; height:auto;">
                            {{-- Student Photo Overlay --}}
                            {{-- @dd($data->students) --}}
                            @if ($data->students->image)
                                <div
                                    style="position: absolute;top: 20px;right: 20px;width: 18%;height: 180px;border: 2px solid #ccc;padding: 2px;background: #fff;">
                                    <img src="{{ asset('backend/img/student/' . $data->students->image) }}"
                                        alt="Student Photo" style="width: 100%; height: 100%; object-fit: cover;">
                                </div>
                            @endif
                            <h2 style="text-align:center">{{ $data->exam->name ?? '' }} <br> Marksheet</h2>
                                <!---markshit update by ashiq  end 202.5.25 --->
                            <div class="student-info">
                                <div class="row">
                                    <div class="col-md-6 nameSection" style="text-align:left">
                                        <p><strong>Name:</strong> {{ $data->students->name ?? '' }}</p>
                                        <p><strong>Roll No:</strong> {{ $data->students->roll_no ?? '' }}</p>
                                        <p><strong>Register No:</strong> {{ $data->students->register_no ?? '' }}</p>
                                    </div>
                                    <div class="col-md-6 classSection" style="text-align:right">
                                        <p><strong>Class:</strong> {{ $data->stuclass->name ?? '' }}</p>
                                        <p><strong>Year:</strong> {{ $data->stusession->name ?? '' }}</p>
                                        <p><strong>Merit Position:</strong> {{ $data->merit_position ?? '' }}</p>
                                    </div>
                                </div>
                            </div>
 <!----grade mark update by ashiq 21.05.25----->
                            <table id="data_table" class="table table-bordered table-striped data-table table-hover">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Subject</th>
                                        <th style="text-align: center">Subject Mark</th>
                                        <th style="text-align: center">Obtained Mark</th>
                                        <th style="text-align: center">Grade</th>
                                        <th style="text-align: center">GPA</th>
                                    </tr>
                                </thead>
                                <tbody id="student_data">
                                    @foreach ($results as $key => $result)
                                        <tr>
                                            <td>{{ $loop->iteration }}</td>
                                            <td>{{ $result->subjects->name ?? '' }}</td>
                                            <td style="text-align: center">{{ $result->exam_mark ?? '' }}</td>
                                            <td style="text-align: center">{{ $result->mark ?? '' }}</td>
                                            <td style="text-align: center">{{ $result->grade ?? 'N/A' }}</td> <!-- Show grade here -->
                                            <td style="text-align: center">{{ $result->gpa ?? 'N/A' }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr>

                                        <td colspan="2"><strong>Total</strong></td>
                                        <td style="text-align: center"><strong>{{ $totalExamMark ?? '' }}</strong></td>
                                        <td style="text-align: center"><strong>{{ $totalMark ?? '' }}</strong></td>
                                        {{-- @dd($avgGrade) --}}
                                        <td style="text-align: center">Grade: <strong>{{ $avgGrade->name ?? 'N/A' }} </strong></td>
                                        <td style="text-align: center">GPA: <strong>{{ $avgGpa ?? 'N/A' }}</strong></td>
                                        <!-- Show average grade -->
                                    </tr>

                                </tfoot>
                            </table>
                             <!----grade mark update by ashiq end 21.05.25----->

                                <!---markshit update by ashiq  start 202.5.25 --->

                            <div style="width: 100%; display: flex; justify-content: space-between; margin-top: 70px;">
                                <div style="width: 30%; text-align: center;">
                                    <div style="border-top: 1px solid #000; padding-top: 5px;">
                                        Teacher Signature
                                    </div>
                                </div>
                                <div style="width: 30%; text-align: center;">
                                    <div style="border-top: 1px solid #000; padding-top: 5px;">
                                        Gardian Signature
                                    </div>
                                </div>
                                <div style="width: 30%; text-align: center;">
                                    <div style="border-top: 1px solid #000; padding-top: 5px;">
                                        Principal Signature
                                    </div>
                                </div>
                            </div>

                                <!---markshit update by ashiq  end 202.5.25 --->

                            <img src="{{ asset('img/' . $invoice->invoice_footer) }}" alt="Header"
                                style="max-width:100%; height:auto;">

                        </div>

                    </div>
                </div>
            </div>
        </section>
    </div>

    @push('js')
        <script type="text/javascript">
            localStorage.clear();

            function auto_print() {
                window.print()
            }
            setTimeout(auto_print, 1000);
        </script>
    @endpush
@endsection
