@extends('dashboard.master')
@section('title', 'Due Details')
@section('content')

<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Due Details</b>
					</span>
				</div>

				<div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
                    <a title="Create" href="{{ route('due.taken.create') }}" type="button" class="btn btn-sm btn-primary">
                        <i class="fas fa-plus mr-1"></i>
                        Create
                    </a>
                    <a title="Print" id="printButton" type="button" class="btn btn-sm btn-danger">
                        <i class="fas fa-file mr-1"></i>
                        Print
                    </a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card printArea">
				<div class="card-body">
                    <img id="header-img" src="{{ asset('img/' . $invoice->invoice_header) }}" alt="Header" style="width:100%; height:150px; margin-bottom:20px;">
                    <table id="data_table" class="table table-bordered table-striped data-table table-hover" style="text-align: left">
                        <thead>
                            <tr>
                                <th class="text-left" width="30%">Date</th>
                                <td class="text-left" width="70%">{{ \Carbon\Carbon::parse($data->date)->format('d-M-Y') ?? '' }}</td>
                            </tr>
                            <tr>
                                <th class="text-left" width="30%">Shop Name</th>
                                <td class="text-left" width="70%">{{ $data->shop->name ?? '' }}</td>
                            </tr>
                            <tr>
                                <th class="text-left" width="30%">Amount</th>
                                <td class="text-left" width="70%">{{ $data->amount ?? '' }}</td>
                            </tr>

                            <tr>
                                <th class="text-left" width="30%">Purpose</th>
                                <td class="text-left" width="70%">{{ $data->purpose ?? '' }}</td>
                            </tr>

                            <tr>
                                <th class="text-left" width="30%">Fund Name</th>
                                <td class="text-left" width="70%">{{ $data->fund->name ?? '' }}</td>
                            </tr>

                            <tr>
                                <th class="text-left" width="30%">Note</th>
                                <td class="text-left" width="70%">{{ $data->note ?? '' }}</td>
                            </tr>

                        </thead>
                    </table>
                    <div id="footer-img">
                        <img src="{{ asset('img/' . $invoice->invoice_footer) }}" alt="Footer" style="width:100%; height:150px; margin-top:20px;">
                    </div>
				</div>
			</div>
		</div>
	</section>
</div>

@push('js')
<script>
    $('#printButton').on('click', function () {
        var printContents = $('.printArea').html();
        var originalContents = $('body').html();

        $('body').html(printContents);
        window.print();

        // Restore the original content and reload
        $('body').html(originalContents);
        location.reload();
    });
</script>
@endpush
@endsection
