@extends('dashboard.master')
@section('title', 'Loan Taken Edit')
@push('css')
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.1/themes/base/jquery-ui.css">
@endpush
@section('content')
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="page-title-wrapper">
                <div class="page-title-heading">
                    <div class="page-title-icon">
                        <i class="nav-icon fas fa-mosque"></i>
                    </div>
                    <span>
                        <b>Loan Taken Edit</b>
                    </span>
                </div>

                <div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="card">
                <form class="forms-sample add-class" enctype="multipart/form-data" action="{{ route('loan.taken.update', $data->id) }}" method="POST">
                    @csrf
                    @method('PUT')
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Date<span class="text-red">*</span></label>
                                    <input type="text" name="date" id="date" value="{{ \Carbon\Carbon::parse($data->date)->format('Y-m-d') }}" class="form-control" required>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Return By<span class="text-red">*</span></label>
                                    <select name="return_by" id="return_by" class="form-control" required>
                                        <option value="">Select One</option>
                                        @foreach ($users as $user)
                                            <option value="{{ $user->id }}"
                                                data-id="{{ $user->id }}"
                                                data-takenby="{{ $user->taken_by }}"
                                                data-name="{{ $user->takenby->name ?? ''}}"
                                                data-amount="{{ $user->amount }}"
                                                data-phone="{{ $user->takenby->phone ?? '' }}" @if($user->id == $data->return_by) selected @endif>
                                                {{ $user->name }} || {{ $user->phone }} | {{ $user->amount ?? '' }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Loan Amount<span class="text-red">*</span></label>
                                    <input type="number" name="loan_amount" id="loan_amount" class="form-control" value="{{ $loanAmount }}" readonly>
                                    <input type="hidden" name="taken_by" id="taken_by" class="form-control" readonly>
                                    <input type="hidden" name="name" id="name" class="form-control"readonly>
                                    <input type="hidden" name="id" id="id" class="form-control"readonly>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Paid Amount<span class="text-red">*</span></label>
                                    <input type="number" name="paid_amount" value="{{ $paidAmount }}" id="paid_amount" class="form-control" readonly>
                                 </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Due Amount<span class="text-red">*</span></label>
                                    <input type="number" name="due_amount" value="{{ $loanAmount - $paidAmount ?? '' }}" id="due_amount" class="form-control" readonly>
                                 </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Pay Amount<span class="text-red">*</span></label>
                                    <input type="number" name="amount" value="{{ $data->amount }}" id="amount" class="form-control" placeholder="enter amount" required>
                                    <input type="hidden" value="{{ $data->amount }}" id="old_amount" class="form-control" placeholder="enter amount" required>
                                 </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Select Fund<span class="text-red">*</span></label>
                                    <select name="fund_id" id="fund_id" class="form-control">
                                        <option value="">Select One</option>
                                        @foreach($funds as $fund)
                                        <option value="{{ $fund->id }}" @if($data->fund_id == $fund->id) selected @endif>{{ $fund->name ?? '' }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Note</label>
                                    <textarea name="note" id="note" cols="1" rows="1" class="form-control" placeholder="write note here ...">{{ $data->note ?? '' }}</textarea>
                                </div>
                            </div>

                        </div>

						<div class="row mt-20 hideClass">
							<div class="col-sm-12">
								<button title="Update" type="submit" class="btn btn-primary mr-2">Update</button>
							</div>
						</div>

                    </div>
                </form>
            </div>
        </div>
    </section>
</div>
@push('js')
<script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.inputmask/5.0.8/jquery.inputmask.min.js"></script>
<script>
$(document).ready(function() {

    $('#date').datepicker({
        dateFormat: 'yy-mm-dd',
        onSelect: function (dateText) {
            alert("Data will be updated to this date: " + dateText);
        }
    });

    $('#date').inputmask('9999-99-99', {
        placeholder: 'yyyy-mm-dd',
        clearIncomplete: true
    });


    $('#return_by').on('change', function(event) {
        event.preventDefault();

        var selectedOption = $(this).find(':selected');
        var return_by = selectedOption.val();
        var id = selectedOption.data('id');
        var name = selectedOption.data('name');
        var takenby = selectedOption.data('takenby');
        var phone = selectedOption.data('phone');
        var loanAmount = parseFloat(selectedOption.data('amount')) || 0;

        $('#loan_amount').val(loanAmount);
        $('#name').val(name);
        $('#id').val(id);
        $('#phone').val(phone);
        $('#taken_by').val(takenby);

        var _token = $('meta[name="csrf-token"]').attr('content');
        var url = "{{ route('loan.paid.amount') }}";

        $.ajax({
            url: url,
            type: "POST",
            data: {
                return_by: return_by,
                _token: _token,
            },
            success: function(response) {
                var paidAmount = parseFloat(response) || 0;
                $('#paid_amount').val(paidAmount);
                var dueAmount = loanAmount - paidAmount;
                $('#due_amount').val(dueAmount);

                $('#amount').on('input', function() {
                    var payAmount = parseFloat($(this).val()) || 0;
                    var calculatedDueAmount = loanAmount - paidAmount - payAmount;
                    if (payAmount > calculatedDueAmount) {
                        $(this).val(calculatedDueAmount);
                        alert('Pay amount cannot be more than the due amount.');
                        $('#due_amount').val(dueAmount);
                        $('#amount').val(' ');
                    }else{
                        $('#due_amount').val(calculatedDueAmount);
                    }

                });
            },
            error: function(xhr, status, error) {
                alert("An error occurred while processing the request.");
            }
        });
    });

        $('#amount').on('input', function() {
        var loanAmount = parseFloat($('#loan_amount').val()) || 0;
        var paidAmount = parseFloat($('#paid_amount').val()) || 0;
        var oldAmount = parseFloat($('#old_amount').val()) || 0;
        var payAmount = parseFloat($(this).val()) || 0;
        var calculatedDueAmount = loanAmount - paidAmount;
        var dueAmount = loanAmount - paidAmount;

        if (payAmount > calculatedDueAmount + oldAmount) {
            $(this).val(calculatedDueAmount);
            alert('Pay amount cannot be more than the due amount.');
            $('#due_amount').val(dueAmount + oldAmount);
            $('#amount').val(' ');
        } else {
            if (payAmount === 0) {
                $('#due_amount').val(dueAmount + oldAmount);
            } else {
                $('#due_amount').val(calculatedDueAmount);
            }
        }
    });


});

</script>
@endpush
@endsection
