@extends('dashboard.master')
@section('title', 'Properties Edit')
@section('content')
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="page-title-wrapper">
                <div class="page-title-heading">
                    <div class="page-title-icon">
                        <i class="nav-icon fas fa-mosque"></i>
                    </div>
                    <span>
                        <b>Properties Edit</b>
                    </span>
                </div>

                <div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="card">
                <form class="forms-sample add-class" enctype="multipart/form-data" action="{{ route('properties.update', $data->id) }}" method="POST">
                    @csrf
                    @method('PUT')
                    <div class="card-body">
                        <div class="row">

                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="product_name">Type<span class="text-red">*</span></label>
                                    <select name="type" id="type" class="form-control" required>
                                        <option value="">Select One</option>
                                        <option value="1" {{ old('type', $data->type ?? '') == 1 ? 'selected' : '' }}>Fixed Asset</option>
                                        <option value="2" {{ old('type', $data->type ?? '') == 2 ? 'selected' : '' }}>Current Asset</option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="product_name">Name<span class="text-red">*</span></label>
                                    <input type="text" name="product_name" value="{{ $data->product_name }}" id="product_name" class="form-control" placeholder="enter product name" required>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="price">Price</label>
                                    <input type="text" name="price" value="{{ $data->price }}" id="price" class="form-control" placeholder="Enter price">
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="note">Note</label>
                                    <textarea name="note" id="note" cols="2" rows="2" class="form-control" placeholder="Write note here...">{{ $data->note ?? '' }}</textarea>
                                </div>
                            </div>

                        </div>

                        <div class="row mt-20">
                            <div class="col-sm-12">
                                <button title="Update" type="submit" class="btn btn-primary mr-2">Update</button>
                            </div>
                        </div>

                    </div>
                </form>
            </div>
        </div>
    </section>
</div>

@endsection
