@extends('dashboard.master')
@section('title', 'Properties Details')
@section('content')
  <?php
    $invoiceBgPath = 'back_height.jpg';
    if (isset($invoice->invoice_bg) && !empty($invoice->invoice_bg)) {
        $potentialBgFile = 'img/' . $invoice->invoice_bg;
        if (file_exists(public_path($potentialBgFile))) {
            $invoiceBgPath = $potentialBgFile;
        }
    }
    ?>
<style>
    .printArea {
            background-image: url('{{ asset($invoiceBgPath) }}');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            padding: 20px;
        }
    .table th, .table td {
        vertical-align: middle;
        text-align: center;
    }

    .table-bordered {
        border: 1px solid #dee2e6;
    }

    .table-striped tbody tr:nth-of-type(odd) {
        background-color: #f9f9f9;
    }

    .table-hover tbody tr:hover {
        background-color: #f1f1f1;
    }

    .thead-dark th {
        background-color: #343a40;
        color: #fff;
    }

    .thead-light th {
        background-color: #f8f9fa;
        color: #000;
    }

    .bg-primary {
        background-color: #007bff !important;
    }

    .text-white {
        color: white;
    }

    .text-center {
        text-align: center;
    }

    .py-2 {
        padding-top: .5rem;
        padding-bottom: .5rem;
    }

    .mb-0 {
        margin-bottom: 0;
    }

     .printArea {
            background-image: url('{{ asset($invoiceBgPath) }}');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            padding: 20px;
        }

        @media print {
            body * {
                visibility: hidden;
            }

            .printArea,
            .printArea * {
                visibility: visible;
            }

            .printArea {
                position: absolute;
                left: 0;
                top: 0;
                width: 100%;
                background-image: url('{{ asset($invoiceBgPath) }}') !important;
                background-size: cover !important;
                background-position: center !important;
                background-repeat: no-repeat !important;
            }

            .container,
            .container-fluid,
            .content-wrapper>.content {
                padding: 0 !important;
            }

            .print-table th,
            .print-table td {
                background: transparent !important;
            }
        }
</style>
<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Properties Details</b>
					</span>
				</div>

				<div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
                    <a title="a4 print" id="printButton" type="button" class="btn btn-sm btn-danger" >
                        <i class="fas fa-file mr-1"></i>
                        Print
                      </a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body printArea">

                    <img id="header-img" src="{{ asset('img/' . $invoice->invoice_header) }}" alt="Header" style="width:100%; height:150px; margin-bottom:20px;">
                    <table id="data_table" class="table table-bordered table-striped data-table table-hover print-table" style="text-align: left">
                        <thead>
                            <tr>
                                <th class="text-left" width="30%">Date</th>
                                <td class="text-left" width="70%">{{ \Carbon\Carbon::parse($data->date)->format('d-M-Y') ?? '' }}</td>
                            </tr>
                            <tr>
                                <th class="text-left" width="30%">Product Name</th>
                                <td class="text-left" width="70%">{{ $data->product_name ?? '' }}</td>
                            </tr>
                            <tr>
                                <th class="text-left" width="30%">Price</th>
                                <td class="text-left" width="70%">{{ $data->price ?? '' }}</td>
                            </tr>
                            <tr>
                                <th class="text-left" width="30%">Prpoerty Type</th>
                                <td class="text-left" width="70%">
                                    @if($data->type == 1)
                                            Fixed Asset
                                    @elseif($data->type == 2)
                                        Current Asset
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <th class="text-left" width="30%">Note</th>
                                <td class="text-left" width="70%">{{ $data->note ?? '-' }}</td>
                            </tr>

                        </thead>
                    </table>

                    <div id="footer-img">
                        <img src="{{ asset('img/' . $invoice->invoice_footer) }}" alt="Footer" style="width:100%; height:150px; margin-top:20px;">
                      </div>
				</div>
			</div>
		</div>
	</section>
</div>
@push('js')
  <script>
            $('#printButton').on('click', function() {
                window.print();
            });
        </script>
@endpush
@endsection
