@extends('dashboard.master')
@section('title', 'Roshid Stock Details')
@section('content')
<style>
    .table th, .table td {
        vertical-align: middle;
        text-align: center;
    }

    .table-bordered {
        border: 1px solid #dee2e6;
    }

    .table-striped tbody tr:nth-of-type(odd) {
        background-color: #f9f9f9;
    }

    .table-hover tbody tr:hover {
        background-color: #f1f1f1;
    }

    .thead-dark th {
        background-color: #343a40;
        color: #fff;
    }

    .thead-light th {
        background-color: #f8f9fa;
        color: #000;
    }

    .bg-primary {
        background-color: #007bff !important;
    }

    .text-white {
        color: white;
    }

    .text-center {
        text-align: center;
    }

    .py-2 {
        padding-top: .5rem;
        padding-bottom: .5rem;
    }

    .mb-0 {
        margin-bottom: 0;
    }
</style>
<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Roshid Stock Details</b>
					</span>
				</div>

				<div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">
                    <table id="data_table" class="table table-bordered table-striped table-hover">
                        <thead class="thead-light">
                            <tr>
                                <th colspan="2" class="text-lef text-white bg-primary float-left">
                                    <h5 class="mb-0">Roshid Name: <b>{{ $name->name ?? '' }}</b></h5>
                                </th>
                            </tr>
                        </thead>
                    </table>

                    <table id="data_table" class="table table-bordered table-striped table-hover">
                        <thead class="thead-dark">
                            <tr>
                                <th class="text-left">SN</th>
                                <th class="text-left">Serial No</th>
                                <th class="text-left">Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($items as $item)
                            <tr>
                                <td class="text-left">{{ $loop->iteration }}</td>
                                <td class="text-left">{{ $item->serial_no ?? '' }}</td>
                                <td class="text-left">
                                        @if($item->status == 1)
                                             <span class="badge badge-danger">Booked</span>
                                        @else
                                             <span class="badge badge-primary">Not Booked</span>
                                        @endif
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>

				</div>
			</div>
		</div>
	</section>
</div>

@endsection
