@extends('dashboard.master')
@section('title', 'Student Sponsor Details')
@push('css')
<style>
       .header, .footer {
        width: 100%;
        height: auto;
        display: block;
        margin: 0 auto;
    }
    .header img, .footer img {
        width: 100% !important;
        height: auto;
        object-fit: cover;
    }
@media print {
    body * {
        visibility: hidden;
    }
    #printArea, #printArea * {
        visibility: visible;
    }
    #printArea {
        position: relative;
        width: 100%;
        left: 0;
    }
    .header{
        width: 100%;
        height: auto;
        display: block;
        margin: 0 auto;
        top: 0;
    }
    .footer {
        width: 100%;
        height: auto;
        display: block;
        margin: 0 auto;
        bottom: 0;
    }
    .header img{
        width: 100% !important;
        height: auto;
        object-fit: cover;
        top: 0;
    }
  .footer img {
        width: 100% !important;
        height: auto;
        object-fit: cover;
        bottom: 0;
    }
    @page {
        size: A4 portrait;
        margin: 0;
    }
}
</style>
@endpush

@section('content')
<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Student Sponsor Details</b>
					</span>
				</div>

				<div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body" id="printArea">
                        <div class="header">
                            <img src="{{ asset("img/" . $invoice->invoice_header) }}" alt="Header">
                        </div>

                        <table id="data_table" class="table table-bordered table-striped data-table table-hover" style="text-align: left; margin-top:15px;margin-bottom:15px;">
                            <thead>
                                <tr>
                                    <th class="text-left" width="30%">Date</th>
                                    <td class="text-left" width="70%">{{ \Carbon\Carbon::parse($data->date)->format('d-M-Y') ?? '' }}</td>
                                </tr>
                                <tr>
                                    <th class="text-left" width="30%">Student Name</th>
                                    <td class="text-left" width="70%">{{ $data->student->name ?? '' }}</td>
                                </tr>
                                <tr>
                                    <th class="text-left" width="30%">Student Roll</th>
                                    <td class="text-left" width="70%">{{ $data->student->roll_no ?? '' }}</td>
                                </tr>
                                <tr>
                                    <th class="text-left" width="30%">Student Register No</th>
                                    <td class="text-left" width="70%">{{ $data->student->register_no ?? '' }}</td>
                                </tr>
                                <tr>
                                    <th class="text-left" width="30%">Student Class</th>
                                    <td class="text-left" width="70%">{{ $data->student->stuclass->name ?? '' }}</td>
                                </tr>
                                {{-- <tr>
                                    <th class="text-left" width="30%">Monthly Amount</th>
                                    <td class="text-left" width="70%">{{ $data->amount ?? '' }}</td>
                                </tr> --}}

                                <tr>
                                    <th class="text-left" width="30%">Donor Name</th>
                                    <td class="text-left" width="70%">{{ $data->donar->name ?? '' }}</td>
                                </tr>

                                <tr>
                                    <th class="text-left" width="30%">Donor Phone</th>
                                    <td class="text-left" width="70%">{{ $data->donar->phone ?? '' }}</td>
                                </tr>

                                <tr>
                                    <th class="text-left" width="30%">Note</th>
                                    <td class="text-left" width="70%">{{ $data->note ?? '-' }}</td>
                                </tr>
                            </thead>
                        </table>

                        <div class="footer">
                            <img src="{{ asset("img/" . $invoice->invoice_footer) }}" alt="Footer">
                        </div>
				</div>
			</div>
		</div>
	</section>
</div>

@push('js')
<script type="text/javascript">
    localStorage.clear();

    function auto_print() {
        window.print();
    }

    setTimeout(auto_print, 1000);
</script>
@endpush
@endsection
