@extends('dashboard.master')
@section('title', 'Admission Fee')
@push('css')
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/css/iziToast.min.css" integrity="sha512-O03ntXoVqaGUTAeAmvQ2YSzkCvclZEcPQu1eqloPaHfJ5RuNGiS4l+3duaidD801P50J28EHyonCV06CUlTSag==" crossorigin="anonymous" referrerpolicy="no-referrer" />
@endpush

@section('content')
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="page-title-wrapper">
                <div class="page-title-heading">
                    <div class="page-title-icon">
                        <i class="nav-icon fas fa-mosque"></i>
                    </div>
                    <span>
                        <b>Admission Fee</b>
                    </span>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="card">
                <div class="card-body">
                    <form id="form" enctype="multipart/form-data" action="{{ route('admission.fee.store') }}" method="POST">
                        @csrf
                        <input type="hidden" name="id" value="{{ isset($data) ? $data->id : '' }}">

                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group">
                                    <label for="amount">Admission Fee<span class="text-red">*</span></label>
                                    <input type="number" name="amount" id="amount" class="form-control" value="{{ isset($data) ? $data->amount : old('amount') }}" placeholder="Enter admission fee" required >
                                </div>
                            </div>
                        </div>

                        <div class="row mt-30">
                            <div class="col-sm-12">
                                <button title="Create Button" type="submit" class="btn btn-success mr-2">{{ isset($data) ? 'Update' : 'Save' }}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>
</div>

@push('js')
<!-- Toastr for notifications -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<!-- SweetAlert2 (replacing SweetAlert v1) -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
@if(Session::has('success'))
    toastr.options = {
        "closeButton": true,
        "progressBar": true,
        "timeOut": 2000
    };
    toastr.success("{{ session('success') }}");
@endif

@if(Session::has('error'))
    toastr.options = {
        "closeButton": true,
        "progressBar": true
    };
    toastr.error("{{ session('error') }}");
@endif

$(document).ready(function () {
    $('#form').on('submit', function (e) {
        @if(!isset($data) || !$data->day)
        e.preventDefault();
        Swal.fire({
            title: 'আপনি কি নিশ্চিত?',
            text: 'ডাটা সেভ করার পর আর এডিট করা যাবে না',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#28a745',
            cancelButtonColor: '#d33',
            confirmButtonText: 'হ্যাঁ, নিশ্চিত!',
            cancelButtonText: 'না, বাতিল করুন'
        }).then((result) => {
            if (result.isConfirmed) {
                this.submit();
            }
        });
        @endif
    });
});
</script>
@endpush
@endsection
