@extends('dashboard.master')
@section('title', 'Attendance Setting')
@push('css')

<link rel="stylesheet" href="{{ asset('backend/DataTables/datatables.min.css') }}">
<link rel="stylesheet" href="{{ asset('backend/css/toggle.css') }}">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/css/iziToast.min.css" integrity="sha512-O03ntXoVqaGUTAeAmvQ2YSzkCvclZEcPQu1eqloPaHfJ5RuNGiS4l+3duaidD801P50J28EHyonCV06CUlTSag==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
<link href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css" rel="stylesheet" />
@endpush

@section('content')

<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Attendance Setting</b>
					</span>
				</div>

				<div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
					<a title="Create" href="#" type="button" class="btn btn-sm btn-primary" data-toggle="modal" data-target="#addClass">
                        <i class="fas fa-plus mr-1"></i>
                        Create
                    </a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">
					<table id="data_table" class="table table-bordered table-striped data-table table-hover">
                        <thead>
                            <tr>
                                <th>SN</th>
                                <th>Shift</th>
                                <th>Entry Start</th>
                                <th>Entry End</th>
                                <th>Exit Start</th>
                                <th>Exit End</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
				</div>
			</div>
		</div>
	</section>
</div>

{{-- add modal --}}
<div class="modal fade" id="addClass" tabindex="-1" role="dialog" aria-labelledby="demoModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="demoModalLabel">{{ __('Create Attendance Setting')}}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
                <form class="forms-sample add-class" enctype="multipart/form-data" action="#" method="POST">
                    @csrf

                    <div class="row">
                        <div class="mb-3 col-md-12">
                            <label>Shift Name<span class="text-red">*</span></label>
                            <input class="form-control" type="text" name="" id="shift_name" placeholder="Morning shift" required>
                        </div>
                        <div class="mb-3 col-md-12">
                            <label>Entry Start Time<span class="text-red">*</span></label>
                            <input class="form-control timepicker" type="text" name="" id="entry_start_time" placeholder="8:00am" required>
                        </div>
                        <div class="mb-3 col-md-12">
                            <label>Entry End Time<span class="text-red">*</span></label>
                            <input class="form-control timepicker" type="text" name="" id="entry_end_time" placeholder="4:00pm" required>
                        </div>
                        <div class="mb-3 col-md-12">
                            <label>Exit Start Time<span class="text-red">*</span></label>
                            <input class="form-control timepicker" type="text" name="" id="exit_start_time" placeholder="4:00pm" required>
                        </div>
                        <div class="mb-3 col-md-12">
                            <label>Exit End Time<span class="text-red">*</span></label>
                            <input class="form-control timepicker" type="text" name="" id="exit_end_time" placeholder="4:20pm" required>
                        </div>
                    </div>

                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger" data-dismiss="modal">{{ __('Close')}}</button>
                <button type="button" id="save" class="btn btn-primary">{{ __('Create')}}</button>
            </div>
        </div>
    </div>
</div>

{{-- edit modal --}}
<div class="modal fade" id="editClass" tabindex="-1" role="dialog" aria-labelledby="demoModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="demoModalLabel">{{ __('Edit Attendance Setting')}}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
                <form id="edit-menu" action="#">
                    @csrf
                    @method('PUT')
                    <input type="hidden" name="" id="editId">

                    <div class="row">
                        <div class="mb-3 col-md-12">
                            <label>Shift Name<span class="text-red">*</span></label>
                            <input class="form-control" type="text" name="" id="shift_nameEdit" required>
                        </div>
                        <div class="mb-3 col-md-12">
                            <label>Entry Start Time<span class="text-red">*</span></label>
                            <input class="form-control timepicker" type="text" name="" id="entry_start_timeEdit" required>
                        </div>
                        <div class="mb-3 col-md-12">
                            <label>Entry End Time<span class="text-red">*</span></label>
                            <input class="form-control timepicker" type="text" name="" id="entry_end_timeEdit" required>
                        </div>
                        <div class="mb-3 col-md-12">
                            <label>Exit Start Time<span class="text-red">*</span></label>
                            <input class="form-control timepicker" type="text" name="" id="exit_start_timeEdit" required>
                        </div>
                        <div class="mb-3 col-md-12">
                            <label>Exit End Time<span class="text-red">*</span></label>
                            <input class="form-control timepicker" type="text" name="" id="exit_end_timeEdit" required>
                        </div>
                    </div>

                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger" data-dismiss="modal">{{ __('Close')}}</button>
                <button type="button" id="update" class="btn btn-primary">{{ __('Update')}}</button>
            </div>
        </div>
    </div>
</div>
@push('js')
<script src="{{ asset('backend/DataTables/datatables.min.js') }}"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/js/iziToast.min.js" integrity="sha512-Zq9o+E00xhhR/7vJ49mxFNJ0KQw1E1TMWkPTxrWcnpfEFDEXgUiwJHIKit93EW/XxE31HSI5GEOW06G6BF1AtA==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<script>
    // add menu
    $(document).ready(function($){

        flatpickr(".timepicker", {
            enableTime: true,
            noCalendar: true,
            dateFormat: "h:i K",
        });

        $(document).ready(function() {
            $('#save').on('click', function (event) {
                event.preventDefault();

                var url = "{{ route('attendance.setting.store') }}";
                var shift_name = $('#shift_name').val();
                var entry_start_time = $('#entry_start_time').val();
                var entry_end_time = $('#entry_end_time').val();
                var exit_start_time = $('#exit_start_time').val();
                var exit_end_time = $('#exit_end_time').val();

                $.ajax({
                    url: url,
                    type: "POST",
                    data: {
                        shift_name : shift_name,
                        entry_start_time : entry_start_time,
                        entry_end_time : entry_end_time,
                        exit_start_time : exit_start_time,
                        exit_end_time : exit_end_time,
                        _token: '{{ csrf_token() }}',
                    },
                    success: function(data) {
                        if (data.success) {
                            toastr.success(data.message);
                            $('.add-class').trigger('clear');
					        $('.add-class')[0].reset();
                            location.reload();
					        $('#data_table').DataTable().ajax.reload();
                        } else {
                            toastr.error(data.message);
                            $('#add-class')[0].reset();
                            $('#addClass').modal('show');
                        }
                    },
                    error: function(xhr, status, error) {
                        toastr.error('An error occurred. Please try again.');
                    }
                });

                $.noConflict();
                $('#addClass').modal('hide');
            });
        });


    $('#data_table').on('click', '#edit[href]', function (e) {
        e.preventDefault();
        var url = $(this).attr('href');
        $.ajax({
            type: "GET",
            url: url,
            success: function(resp) {
                $('#shift_nameEdit').val(resp.shift_name);
                $('#entry_start_timeEdit').val(formatTime24To12(resp.entry_start_time));
                $('#entry_end_timeEdit').val(formatTime24To12(resp.entry_end_time));
                $('#exit_start_timeEdit').val(formatTime24To12(resp.exit_start_time));
                $('#exit_end_timeEdit').val(formatTime24To12(resp.exit_end_time));
                $('#editId').val(resp.id);
            }
        });
    });

    function formatTime24To12(timeStr) {
    const [hours, minutes] = timeStr.split(':');
    const h = parseInt(hours);
    const suffix = h >= 12 ? "PM" : "AM";
    const hour12 = ((h + 11) % 12 + 1);
    return `${hour12.toString().padStart(2, '0')}:${minutes} ${suffix}`;
}


    $('#update').on('click',function (event) {
        event.preventDefault();
        var id = $('#editId').val();
        var shift_name = $('#shift_nameEdit').val();
        var entry_start_time = $('#entry_start_timeEdit').val();
        var entry_end_time = $('#entry_end_timeEdit').val();
        var exit_start_time = $('#exit_start_timeEdit').val();
        var exit_end_time = $('#exit_end_timeEdit').val();
        var url = '{{ route("attendance.setting.update",":id") }}';
        $.ajax({
            url: url.replace(':id', id),
            type: 'POST',
            data: {
                shift_name: shift_name,
                entry_start_time: entry_start_time,
                entry_end_time: entry_end_time,
                exit_start_time: exit_start_time,
                exit_end_time: exit_end_time,
                _token: '{{ csrf_token() }}',
            },
            success:function(data) {
                if (data.success === true) {
                    toastr.success(data.message);
                    $('#data_table').DataTable().ajax.reload();
                    $('#editClass').modal('hide');
                } else {
                    toastr.error(data.message);
                    $('#editClass').modal('show');
                }
            }
        });
    });
});

$(document).ready( function () {
    var dTable = $('#data_table').DataTable({
        order: [],
        lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        processing: true,
        responsive: false,
        serverSide: true,
         scrollX: true,
          autoWidth: false,
        scroller: {
            loadingIndicator: false
        },
        language: {
              processing: '<i class="ace-icon fa fa-spinner fa-spin orange bigger-500" style="font-size:60px;text-align:center;"></i>'
            },
        pagingType: "full_numbers",
        ajax: {
            url: "{{route('attendance.setting')}}",
            type: "get"
        },

        columns: [
            {data: 'DT_RowIndex', name: 'DT_RowIndex', searchable: true, orderable: true},
            {data: 'name', name: 'name'},
            {data: 'entry_start', name: 'entry_start'},
            {data: 'entry_end', name: 'entry_end'},
            {data: 'exit_start', name: 'exit_start'},
            {data: 'exit_end', name: 'exit_end'},
            {data: 'action', searchable: false, orderable: false}
        ],

        });
    });

    $('#data_table').on('click', '.btn-delete[data-remote]', function (e) {
            e.preventDefault();

            $.ajaxSetup({
                headers: {
                    "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
                }
            });

            const url = $(this).data('remote');
            swal({
                    title: `Are you sure?`,
                    text: "Want to delete this record?",
                    buttons: true,
                    dangerMode: true,
                }).then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    url: url,
                    type: 'get',
                    dataType: 'json',
                    data: {submit: true, _method: 'delete', _token: "{{ csrf_token() }}"}
                }).always(function (data) {
                    $('#data_table').DataTable().ajax.reload();
                    if (data.success === true) {
                        toastr.success(data.message, { positionClass: 'toast-bottom-full-width', });
                    }else{
                        toastr.error(data.message, { positionClass: 'toast-bottom-full-width', });
                    }
                });
            }
            });
        });

    //  toastr.options.timeOut = 300;
@if(Session::has('success'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true,
        "timeOut" : 2000
    };

    toastr.success("{{ session('success') }}");
  @endif

 @if(Session::has('error'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    };
    toastr.error("{{ session('error') }}");
 @endif
</script>
@endpush
@endsection




