@extends('dashboard.master')
@section('title', 'Exam Routing')
@push('css')
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet"/>
@endpush

@section('content')
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="page-title-wrapper">
                    <div class="page-title-heading">
                        <div class="page-title-icon">
                            <i class="nav-icon fas fa-mosque"></i>
                        </div>
                        <span><b>পরীক্ষার রুটিন তৈরি</b></span>
                    </div>

                    <div class="page-title-actions">
                        <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                            <i class="fas fa-arrow-left mr-1"></i> Back
                        </a>
                        <a title="Create" href="{{ route('exam.routing') }}" class="btn btn-sm btn-primary">
                            <i class="fas fa-plus mr-1"></i> List</a>
                    </div>
                </div>

                @if (Session::has('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        {{ Session::get('success') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif

                @if (Session::has('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        {{ Session::get('error') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif


            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                <div class="card">
                    <div class="card-body">
                        <form action="{{ route('exam.routing.store') }}" method="POST">
                            @csrf
                            <div class="row">
                                <div class="col-md-4">
                                    <label for="class_id" class="form-label">Class</label>
                                    <select class="form-control select2" name="class_id" id="class_id">
                                        <option value="">Select Class</option>
                                        @foreach ($classes as $class)
                                            <option value="{{ $class->id }}">{{ $class->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-4">
                                    <label for="session_id" class="form-label">Session</label>
                                    <select class="form-control select2" name="session_id" id="session_id">
                                        <option value="">Select Session</option>
                                        @foreach ($sessions as $session)
                                            <option value="{{ $session->id }}">{{ $session->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-4">
                                    <label for="exam_id" class="form-label">Exam</label>
                                    <select class="form-control select2" name="exam_id" id="exam_id">
                                        <option value="">Select Exam</option>
                                        @foreach ($exams as $exam)
                                            <option value="{{ $exam->id }}">{{ $exam->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <hr>

                            <h5>Exam Details</h5>

                            <table class="table table-bordered" id="examTable">
                                <thead>
                                    <tr>
                                        <th width="20%">Subject</th>
                                        <th>Date</th>
                                        <th>Day</th>
                                        <th>Room</th>
                                        <th>Time</th>
                                        <th>Marks</th>
                                        <th>Summary</th>

                                    </tr>
                                </thead>
                                <tbody>
                                    <!-- Initially empty -->
                                </tbody>
                            </table>



                            <button type="submit" class="btn btn-primary mt-2">Submit</button>
                        </form>

                    </div>
                </div>
            </div>
        </section>
    </div>

    @push('js')
     <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
        <script>
            $(document).ready(function() {

                // Add More Row manually
                $('#addRow').click(function() {
                    appendRow();
                });

                // Remove Row
                $(document).on('click', '.removeRow', function() {
                    $(this).closest('tr').remove();
                });

                // Class change => load subjects and generate rows
                $('#class_id').change(function() {
                    var classId = $(this).val();
                    if (classId) {
                        $.ajax({
                            url: '/get-subjects-by-class/' + classId,
                            type: 'GET',
                            success: function(data) {
                                $('#examTable tbody').empty(); // clear previous rows

                                data.forEach(function(subject) {
                                    appendRow(subject.id, subject.name);
                                });
                            }
                        });
                    } else {
                        $('#examTable tbody').empty();
                    }
                });

                function appendRow(subjectId = '', subjectName = '') {
                    let subjectSelect =
                        '<select readonly class="form-control subject-select" name="subject_id[]" class="form-control subject-select" required>';
                    if (subjectId && subjectName) {
                        subjectSelect += `<option value="${subjectId}" selected>${subjectName}</option>`;
                    } else {
                        subjectSelect += `<option value="">Select Subject</option>`;
                    }
                    subjectSelect += '</select>';

                    var row = `<tr>
            <td>${subjectSelect}</td>
            <td><input type="date" name="date[]" class="form-control" required></td>
            <td><input type="text" name="day[]" class="form-control" required></td>
            <td><input type="text" name="room[]" class="form-control" required></td>
            <td><input type="time" name="time[]" class="form-control" required></td>
            <td><input type="text" name="marks[]" class="form-control" required></td>
            <td><input type="text" name="summary[]" class="form-control" required></td>
            
        </tr>`;
                    $('#examTable tbody').append(row);
                }

            });
              toastr.options = {
        "closeButton": true,           // ✅ ক্রস বাটন
        "progressBar": true,
        "positionClass": "toast-top-right",
        "timeOut": "5000"
    };

     @if(Session::has('success'))
        toastr.success("{{ Session::get('success') }}");
    @endif

    @if(Session::has('error'))
        toastr.error("{{ Session::get('error') }}");
    @endif

    @if(Session::has('info'))
        toastr.info("{{ Session::get('info') }}");
    @endif

    @if(Session::has('warning'))
        toastr.warning("{{ Session::get('warning') }}");
    @endif
        </script>
    @endpush



@endsection
