@extends('dashboard.master')
@section('title', 'Edit Exam Routing')
@push('css')
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet"/>
@endpush

@section('content')
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="page-title-wrapper">
                    <div class="page-title-heading">
                        <div class="page-title-icon">
                            <i class="nav-icon fas fa-mosque"></i>
                        </div>
                        <span><b>পরীক্ষার রুটিন এডিট</b></span>
                    </div>

                    <div class="page-title-actions">
                        <a title="Back" href="{{ route('exam.routing') }}" type="button" class="btn btn-sm btn-dark">
                            <i class="fas fa-arrow-left mr-1"></i> Back
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                <div class="card">
                    <div class="card-body">
                        <form action="{{ route('exam.routing.update', $examRouting->id) }}" method="POST">
                            @csrf
                            @method('PUT')
                            <div class="row">
                                <div class="col-md-4">
                                    <label class="form-label">Class</label>
                                    <input type="text" class="form-control" value="{{ $examRouting->class->name ?? '' }}"
                                        readonly>
                                    <input type="hidden" name="class_id" value="{{ $examRouting->class_id }}">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">Session</label>
                                    <input type="text" class="form-control"
                                        value="{{ $examRouting->session->name ?? '' }}" readonly>
                                    <input type="hidden" name="session_id" value="{{ $examRouting->session_id }}">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">Exam</label>
                                    <input type="text" class="form-control" value="{{ $examRouting->exam->name ?? '' }}"
                                        readonly>
                                    <input type="hidden" name="exam_id" value="{{ $examRouting->exam_id }}">
                                </div>
                            </div>

                            <hr>
                            <h5>Exam Details</h5>

                            <table class="table table-bordered" id="examTable">
                                <thead>
                                    <tr>
                                        <th>Subject</th>
                                        <th>Date</th>
                                        <th>Day</th>
                                        <th>Room</th>
                                        <th>Time</th>
                                        <th>Marks</th>
                                        <th>Summary</th>

                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($examRouting->details as $detail)
                                        <tr>
                                            <td>
                                                <select class="form-control" name="subject_id[]" readonly>
                                                    <option value="{{ $detail->subject_id }}">
                                                        {{ $detail->subject->name ?? '' }}</option>
                                                </select>
                                            </td>
                                            <td><input type="date" name="date[]" class="form-control"
                                                    value="{{ $detail->date }}"></td>
                                            <td><input type="text" name="day[]" class="form-control"
                                                    value="{{ $detail->day }}"></td>
                                            <td><input type="text" name="room[]" class="form-control"
                                                    value="{{ $detail->room }}"></td>
                                            <td><input type="time" name="time[]" class="form-control"
                                                    value="{{ $detail->time }}"></td>
                                            <td><input type="text" name="marks[]" class="form-control"
                                                    value="{{ $detail->mark }}"></td>
                                            <td><input type="text" name="summary[]" class="form-control"
                                                    value="{{ $detail->summary }}"></td>

                                        </tr>
                                    @endforeach

                                    @if ($newSubjects->count() > 0)
                                        @foreach ($newSubjects as $subject)
                                            <tr>
                                                <td>
                                                    <select class="form-control" name="subject_id[]" required>
                                                        <option value="{{ $subject->id }}" selected>{{ $subject->name }}
                                                        </option>
                                                    </select>
                                                </td>
                                                <td><input type="date" name="date[]" class="form-control"></td>
                                                <td><input type="text" name="day[]" class="form-control"></td>
                                                <td><input type="text" name="room[]" class="form-control"></td>
                                                <td><input type="time" name="time[]" class="form-control"></td>
                                                <td><input type="text" name="marks[]" class="form-control"></td>
                                                <td><input type="text" name="summary[]" class="form-control"></td>
                                            </tr>
                                        @endforeach
                                    @else
                                        <tr>
                                            <td colspan="7" class="text-center text-muted">
                                                <i class="fas fa-info-circle"></i>
                                            </td>
                                        </tr>
                                    @endif

                                </tbody>
                            </table>


                            <button type="submit" class="btn btn-primary mt-2">Update</button>
                        </form>

                    </div>
                </div>
            </div>
        </section>
    </div>

    @push('js')
     <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
        <script>
           
            $(document).ready(function() {
                // Add More Row manually
                $('#addRow').click(function() {
                    appendRow();
                });

                // Remove Row
                $(document).on('click', '.removeRow', function() {
                    $(this).closest('tr').remove();
                });

                function appendRow() {
                    let row = `<tr>
            <td>
                <select name="subject_id[]" class="form-control" required>
                    <option value="">Select Subject</option>
                    @foreach ($examRouting->class->subjects as $subject)
                        <option value="{{ $subject->id }}">{{ $subject->name }}</option>
                    @endforeach
                </select>
            </td>
            <td><input type="date" name="date[]" class="form-control" required></td>
            <td><input type="text" name="day[]" class="form-control"></td>
            <td><input type="text" name="room[]" class="form-control"></td>
            <td><input type="time" name="time[]" class="form-control"></td>
            <td><input type="text" name="marks[]" class="form-control"></td>
            <td><input type="text" name="summary[]" class="form-control"></td>
      
        </tr>`;
                    $('#examTable tbody').append(row);
                }
            });


           toastr.options = {
        "closeButton": true,           // ✅ ক্রস বাটন
        "progressBar": true,
        "positionClass": "toast-top-right",
        "timeOut": "5000"
    };

    @if(Session::has('success'))
        toastr.success("{{ Session::get('success') }}");
    @endif

    @if(Session::has('error'))
        toastr.error("{{ Session::get('error') }}");
    @endif

    @if(Session::has('info'))
        toastr.info("{{ Session::get('info') }}");
    @endif

    @if(Session::has('warning'))
        toastr.warning("{{ Session::get('warning') }}");
    @endif
        </script>
    @endpush

@endsection
