@extends('dashboard.master')
@section('title', 'View Exam Routine')

@push('css')
    <style>
        /* Page setup for landscape orientation */
        @page {
            size: A4 landscape;
            margin: 0;
        }

        .page {
            background-image: url('{{ asset('img/back_height.jpg') }}');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            page-break-after: always;
            width: 100%;
            min-height: 100vh;
        }

        .page:last-child {
            page-break-after: auto;
        }

        @media print {
            body {
                margin: 0;
                font-family: Arial, sans-serif;
            }

            .no-print {
                display: none !important;
            }

            .page {
                width: 100%;
                min-height: 100vh;
            }

            /* Table styles */
            .print-table th,
            .print-table td {
                background: transparent !important;
                text-align: center;
                vertical-align: middle;
                padding: 8px;
            }

            .content-wrapper > .content,
            .container,
            .container-fluid {
                padding: 0 !important;
            }

            .main-footer {
                display: none !important;
            }

            .card-body {
                padding: 0;
            }

            .table th {
                background-color: #f0f0f0;
                text-align: center;
                font-weight: bold;
            }

            .table td {
                text-align: center;
                padding: 6px;
            }

            .exam-table {
                width: 100%;
                border-collapse: collapse;
            }

            .exam-table th, .exam-table td {
                border: 1px solid #ddd;
            }
        }
    </style>
@endpush

@section('content')
    <div class="content-wrapper">
        <div class="content-header no-print">
            <div class="container-fluid d-flex justify-content-between align-items-center">
                <div>
                    <h5 class="mb-0"><b>পরীক্ষার রুটিন ( Print Preview )</b></h5>
                    <small>Session: 2025 | Exam: 1st Tutorial Exam</small>
                </div>
                <div>
                    <a href="{{ route('exam.routing') }}" class="btn btn-sm btn-dark"><i class="fas fa-arrow-left mr-1"></i>
                        Back</a>
                    <button onclick="window.print()" class="btn btn-sm btn-success ml-2">
                        <i class="fas fa-print mr-1"></i> Print / Save as PDF
                    </button>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                <div class="card page">
                    <div class="card-body">
                        <div class="text-center mb-3">
                            <h3><b>Exam Routine - 2025</b></h3>
                            <small>Class: All Classes</small>
                        </div>

                        <table class="exam-table">
                            <thead>
                                <tr>
                                    <th rowspan="2">Date</th>
                                    <th colspan="2">HIFZ</th>
                                    <th colspan="2">PRE-NURSERY</th>
                                    <th colspan="2">NURSERY</th>
                                    <th colspan="2">ONE</th>
                                    <th colspan="2">TWO</th>
                                </tr>
                                <tr>
                                    <th>Morning</th>
                                    <th>Day</th>
                                    <th>Morning</th>
                                    <th>Day</th>
                                    <th>Morning</th>
                                    <th>Day</th>
                                    <th>Morning</th>
                                    <th>Day</th>
                                    <th>Morning</th>
                                    <th>Day</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>15/03/2025</td>
                                    <td>Kalima & Mas'ala</td>
                                    <td>Math</td>
                                    <td>Quran Mazid</td>
                                    <td>English</td>
                                    <td>Arabic Writing</td>
                                    <td>Arabic Writing</td>
                                    <td>Kalima & Hadith Sharif</td>
                                    <td>Math</td>
                                    <td>Quran Mazid</td>
                                    <td>Arabic Writing</td>
                                </tr>
                                <tr>
                                    <td>16/03/2025</td>
                                    <td>Arabic Writing</td>
                                    <td>Math</td>
                                    <td>Arabic Writing</td>
                                    <td>Kalima & Hadith Sharif</td>
                                    <td>Math</td>
                                    <td>Kalima & Mas'ala</td>
                                    <td>Quran Mazid & Hadith Sharif</td>
                                    <td>Bangla</td>
                                    <td>Bangla</td>
                                    <td>Bangladesh & Global Studies</td>
                                </tr>
                                <tr>
                                    <td>17/03/2025</td>
                                    <td>English</td>
                                    <td>Arabic 1st Paper</td>
                                    <td>Arabic Writing</td>
                                    <td>English</td>
                                    <td>Kalima & Hadith Sharif</td>
                                    <td>English</td>
                                    <td>Arabic Writing</td>
                                    <td>Bangla</td>
                                    <td>Math</td>
                                    <td>Arabic 1st Paper</td>
                                </tr>
                                <tr>
                                    <td>18/03/2025</td>
                                    <td>Bangla</td>
                                    <td>Arabic Writing</td>
                                    <td>English</td>
                                    <td>Bangla</td>
                                    <td>Kalima & Hadith Sharif</td>
                                    <td>Bangla</td>
                                    <td>Mas'ala & Dua</td>
                                    <td>Arabic 1st Paper</td>
                                    <td>Bangla</td>
                                    <td>Bangladesh & Global Studies</td>
                                </tr>
                                <tr>
                                    <td>19/03/2025</td>
                                    <td>Kerat</td>
                                    <td>Mas'ala</td>
                                    <td>English</td>
                                    <td>Quran Mazid</td>
                                    <td>Bangla</td>
                                    <td>Math</td>
                                    <td>English</td>
                                    <td>Arabic Writing</td>
                                    <td>English</td>
                                    <td>Quran Mazid</td>
                                </tr>
                                <tr>
                                    <td>20/03/2025</td>
                                    <td>Quran Mazid & Fiqh</td>
                                    <td>Math</td>
                                    <td>Quran Mazid</td>
                                    <td>Bangla</td>
                                    <td>Bangladesh & Global Studies</td>
                                    <td>Bangladesh & Global Studies</td>
                                    <td>Arabic Writing</td>
                                    <td>Arabic Writing</td>
                                    <td>English</td>
                                    <td>Quran Mazid</td>
                                </tr>
                            </tbody>
                        </table>

                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
