@extends('dashboard.master')
@section('title', 'Licence')
@push('css')
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
@endpush
@section('content')
<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Licence</b>
					</span>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">
                    <form action="{{ route('licence.store')}}" class="form-submit" method="POST" enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" name="id" value="{{ isset($data) ? $data->id : '' }}">

                        <div class="row">
                            <div class="mb-3 col-md-6">
                                <label for="username" class="form-label">User Name<span class="text-red">*</span></label>
                                <input class="form-control" type="text" id="username" name="username" placeholder="user name" value="{{ isset($data) ? $data->username : old('username') }}" required {{ isset($data) ? 'readonly' : '' }}>
                            </div>

                            <div class="mb-3 col-md-6">
                                <label for="licence_key" class="form-label">Licence Key<span class="text-red">*</span></label>
                                <input class="form-control" type="text" id="licence_key" name="licence_key" placeholder="xxxx-xxxx-xxxx-xxxx" value="{{ isset($data) ? $data->licence_key : old('licence_key') }}" required {{ isset($data) ? 'readonly' : '' }}>
                            </div>
                        </div>

                        @if(!empty($data))
                            @else
                            <div class="mt-2">
                            <button title="submit" type="submit" class="btn btn-primary mr-2">Save</button>
                        </div>
                        @endif

                    </form>
				</div>
			</div>
		</div>
	</section>
</div>

@push('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<script>
@if(Session::has('success'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true,
        "timeOut" : 2000
    };

    toastr.success("{{ session('success') }}");
  @endif

 @if(Session::has('error'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    };
    toastr.error("{{ session('error') }}");
 @endif
</script>
@endpush
@endsection
