@extends('dashboard.master')
@section('title', 'Site Settings')
@push('css')
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/css/dropify.min.css"
        integrity="sha512-EZSUkJWTjzDlspOoPSpUFR0o0Xy7jdzW//6qhUkoZ9c4StFkVsp9fbbd0O06p9ELS3H486m4wmrCELjza4JEog=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />

    <style>
        .dropify-wrapper .dropify-message p {
            font-size: initial;
        }
    </style>
@endpush

@section('content')
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="page-title-wrapper">
                    <div class="page-title-heading">
                        <div class="page-title-icon">
                            <i class="nav-icon fas fa-mosque"></i>
                        </div>
                        <span>
                            <b>Site Settings</b>
                        </span>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                <div class="card">
                    <div class="card-body">
                        <form enctype="multipart/form-data" action="{{ route('settings.store') }}" method="POST">
                            @csrf
                            <input type="hidden" name="id" value="{{ isset($data) ? $data->id : ' ' }}">
                            <div class="row">
                                <div class="col-sm-8">
                                    <div class="form-group">
                                        <label for="long_name">প্রতিষ্ঠানের পুরো নাম<span class="text-red">*</span></label>
                                        <input type="text" name="long_name" id="long_name"
                                            value="{{ isset($data) ? $data->long_name : old('long_name') }}"
                                            class="form-control" placeholder="Enter institute full name" required>

                                        @error('long_name')
                                            <span class="text-danger" role="alert">
                                                <p>{{ $message }}</p>
                                            </span>
                                        @enderror

                                    </div>
                                </div>

                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="name">এসএমএস প্রতিষ্ঠান নাম<span class="text-red">*</span></label>
                                        <input type="text" name="name" id="name"
                                            value="{{ isset($data) ? $data->name : old('name') }}" class="form-control"
                                            placeholder="Enter short name" required>

                                        @error('name')
                                            <span class="text-danger" role="alert">
                                                <p>{{ $message }}</p>
                                            </span>
                                        @enderror

                                    </div>
                                </div>

                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="website">প্রতিষ্ঠাতার নাম<span class="text-red">*</span></label>
                                        <input type="text" name="website" id="website"
                                            value="{{ isset($data) ? $data->website : old('website') }}"
                                            class="form-control" placeholder="Enter institute web address" required>

                                        @error('name')
                                            <span class="text-danger" role="alert">
                                                <p>{{ $message }}</p>
                                            </span>
                                        @enderror

                                    </div>
                                </div>

                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="email">ইমেইল<span class="text-red">*</span></label>
                                        <input type="email" name="email" id="email"
                                            value="{{ isset($data) ? $data->email : old('email') }}"
                                            class="form-control email @error('email') is-invalid @enderror"
                                            placeholder="Enter email address " required>

                                        @error('email')
                                            <span class="text-danger" role="alert">
                                                <p>{{ $message }}</p>
                                            </span>
                                        @enderror

                                    </div>
                                </div>

                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="phone">মোবাইল নাম্বার <span class="text-red">*</span></label>

                                        <input type="text" name="phone" id="phone"
                                            value="{{ isset($data) ? $data->phone : old('phone') }}"
                                            class="form-control @error('phone') is-invalid @enderror"
                                            placeholder="Enter phone number" required>

                                        @error('phone')
                                            <span class="text-danger" role="alert">
                                                <p>{{ $message }}</p>
                                            </span>
                                        @enderror

                                    </div>
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="logo">প্রতিষ্ঠানের লোগো<span class="text-red">*</span></label>
                                        <input type="file" name="logo" id="logo" data-height="150"
                                            @if ($data) data-default-file="{{ asset('img/' . $data->logo) }}" @endif
                                            class="dropify form-control @error('logo') is-invalid @enderror">

                                        @error('logo')
                                            <span class="text-danger" role="alert">
                                                <p>{{ $message }}</p>
                                            </span>
                                        @enderror

                                    </div>
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="favicon">প্রতিষ্ঠানের ফেব আইকন<span class="text-red">*</span></label>
                                        <input type="file" name="favicon" id="favicon" data-height="150"
                                            @if ($data) data-default-file="{{ asset('img/' . $data->favicon) }}" @endif
                                            class="dropify form-control @error('favicon') is-invalid @enderror">

                                        @error('favicon')
                                            <span class="text-danger" role="alert">
                                                <p>{{ $message }}</p>
                                            </span>
                                        @enderror

                                    </div>
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="address">প্রতিষ্ঠানের ঠিকানা<span class="text-red">*</span></label>
                                        <textarea name="address" class="form-control" rows="3" placeholder="Write address..." required>{{ isset($data) ? $data->address : old('address') }}</textarea>

                                        @error('address')
                                            <span class="text-danger" role="alert">
                                                <p>{{ $message }}</p>
                                            </span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="map">প্রতিষ্ঠানের সংক্ষিপ্ত বিবরণ<span
                                                class="text-red">*</span></label>
                                        <textarea name="map" class="form-control" rows="3" placeholder="Enter map location" required>{{ isset($data) ? $data->map : old('map') }}</textarea>

                                        @error('map')
                                            <span class="text-danger" role="alert">
                                                <p>{{ $message }}</p>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            @if (auth()->user()->canPerm('site_setting.update') || auth()->user()->type == '1' || auth()->user()->role_id == '1')
                                <div class="row mt-30">
                                    <div class="col-sm-12">
                                        <button title="Create Button" type="submit"
                                            class="btn btn-success mr-2">{{ isset($data) ? 'Update' : 'Save' }}</button>
                                    </div>
                                </div>
                            @endif

                        </form>
                    </div>
                </div>
            </div>
        </section>
    </div>
    @push('js')
        <script src="https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/js/dropify.min.js"
            integrity="sha512-8QFTrG0oeOiyWo/VM9Y8kgxdlCryqhIxVeRpWSezdRRAvarxVtwLnGroJgnVW9/XBRduxO/z1GblzPrMQoeuew=="
            crossorigin="anonymous" referrerpolicy="no-referrer"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
        <script>
            $(document).ready(function() {
                $('.dropify').dropify();
            });
            @if (Session::has('success'))
                toastr.options = {
                    "closeButton": true,
                    "progressBar": true,
                    "timeOut": 2000
                };

                toastr.success("{{ session('success') }}");
            @endif

            @if (Session::has('error'))
                toastr.options = {
                    "closeButton": true,
                    "progressBar": true
                };
                toastr.error("{{ session('error') }}");
            @endif
        </script>
    @endpush
@endsection
