@extends('dashboard.master')
@section('title', 'Sms Setting')
@push('css')
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
@endpush
@section('content')
<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Sms Setting</b>
					</span>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">

                    <form enctype="multipart/form-data" action="{{ route('sms.store') }}" method="POST">
                        @csrf
                        <input type="hidden" name="id" value="{{ isset($data) ? $data->id : ' ' }}">
                        <div class="row">

                            <div class="col-sm-12">
                                <div class="form-group">
                                    <label for="sender_id">Sender ID<span class="text-red">*</span></label>

                                     <input type="text" name="sender_id" id="sender_id" value="{{ isset($data) ? $data->sender_id : old('sender_id') }}" class="form-control @error('sender_id') is-invalid @enderror" placeholder="ex: 8809617619609" required>

                                </div>
                            </div>

                            <div class="col-sm-12">
                                <div class="form-group">
                                    <label for="api_key">Api Key<span class="text-red">*</span></label>
                                     <input type="text" name="api_key" id="api_key" value="{{ isset($data) ? $data->api_key : old('api_key') }}" class="form-control @error('api_key') is-invalid @enderror" placeholder="ex: ZtzhSc7IeRlmrlPpdbeP" required>
                                </div>
                            </div>
                            <div class="col-sm-12">
                                <div class="form-group">
                                    <label for="api_url">Api Url<span class="text-red">*</span></label>
                                     <input type="text" name="api_url" id="api_url" value="{{ isset($data) ? $data->api_url : old('api_url') ?? '' }}" class="form-control @error('api_url') is-invalid @enderror" placeholder="ex: http://139.99.39.237/api/smsapi" required>
                                </div>
                            </div>

                            <div class="col-sm-12">
                                <div class="form-group">
                                    <label for="status"> Status<span class="text-red">*</span></label>
                                     <select name="status" id="status" class="form-control @error('status') is-invalid @enderror" required>
                                        <option value="1" @if(isset($data) && $data->status == 1) selected @endif>On</option>
                                        <option value="2" @if(isset($data) && $data->status == 2) selected @endif>Off</option>
                                     </select>

                                </div>
                            </div>

                        </div>

                        <div class="row mt-30">
                            <div class="col-sm-12">
                                <button title="Create Button" type="submit" class="btn btn-success mr-2">{{ isset($data) ? 'Update' : 'Save' }}</button>
                            </div>
                        </div>

                    </form>
				</div>
			</div>
		</div>
	</section>
</div>
@push('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<script>
@if(Session::has('success'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true,
        "timeOut" : 2000
    };

    toastr.success("{{ session('success') }}");
@endif

 @if(Session::has('error'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    };
    toastr.error("{{ session('error') }}");
 @endif
</script>
@endpush
@endsection



