@extends('dashboard.master')
@section('title', 'Create Staff ')
@push('css')

<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/css/dropify.min.css" integrity="sha512-EZSUkJWTjzDlspOoPSpUFR0o0Xy7jdzW//6qhUkoZ9c4StFkVsp9fbbd0O06p9ELS3H486m4wmrCELjza4JEog==" crossorigin="anonymous" referrerpolicy="no-referrer" />

<style>
    .dropify-wrapper .dropify-message p {
        font-size: initial;
    }
</style>

 @endpush

@section('content')

<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Create Staff</b>
					</span>
				</div>

				<div class="page-title-actions">
					<a title="Back Button" href="{{ route('staff.index') }}" type="button" class="btn btn-sm btn-dark">
						<i class="fas fa-arrow-left mr-1"></i>
						Back
					</a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">
					<form enctype="multipart/form-data" action="{{ route('staff.store') }}" method="POST">
                        @csrf
						<div class="row">
							<div class="col-sm-4">
								<div class="form-group">
									<label for="reg_no">Staff ID<span class="text-red">*</span></label>
									<input type="text" name="staff_user_id" id="staff_user_id" value="DUSPSTFUID-000{{ $staff + 1 }}" class="form-control" placeholder="Teacher ID" readonly>
								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="name">Staff Name<span class="text-red">*</span></label>
									<input type="text" name="name" id="name" value="{{ old('name') }}" class="form-control @error('name') is-invalid @enderror" placeholder="Enter staff name" required>

									@error('name')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="join_date"> Join Date <span class="text-red">*</span></label>
									<input type="date" name="join_date" id="join_date" value="{{ old('join_date') }}" class="form-control datepicker @error('join_date') is-invalid @enderror" placeholder="Enter join date" required>

									@error('join_date')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="gender">Gender <span class="text-red">*</span></label>
									<select name="gender" id="gender" class="form-control @error('gender') is-invalid @enderror" required>
										<option value="1">Male</option>
										<option value="2">Female</option>
									</select>

									@error('gender')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="designation">Designation <span class="text-red">*</span></label>
									<input type="text" name="designation" id="designation" value="{{ old('designation') }}" class="form-control @error('designation') is-invalid @enderror" placeholder="Enter designation" required>

									@error('designation')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

                            <div class="col-sm-4">
								<div class="form-group">
									<label for="email">Email <span class="text-red">*</span></label>
									<input type="email" name="email" id="email" value="{{ old('email') }}" class="form-control @error('email') is-invalid @enderror" placeholder="Enter email address"  autocomplete="off" required>

									@error('email')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="phone">Phone <span class="text-red">*</span></label>
									<input type="text" name="phone" id="phone" value="{{ old('phone') }}" class="form-control @error('phone') is-invalid @enderror" placeholder=" Enter phone number" required>

									@error('phone')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

                            <div class="col-sm-3">
								<div class="form-group">
									<label for="salary">Salary <span class="text-red">*</span></label>
									<input type="text" name="salary" id="salary" value="{{ old('salary') }}" class="form-control @error('salary') is-invalid @enderror" placeholder="Enter salary" required>

									@error('salary')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>


							<div class="col-sm-2">
								<div class="form-group">
									<label for="blood_group">Blood Group <span class="text-red"></span></label>
									<input type="text" name="blood_group" id="blood_group" value="{{ old('blood_group') }}" class="form-control @error('blood_group') is-invalid @enderror" placeholder="Enter blood group"  autocomplete="off">

									@error('blood_group')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							<div class="col-sm-3">
								<div class="form-group">
									<label for="status"> Status <span class="text-red">*</span></label>
									<select name="status" id="status" class="form-control">
										<option value="1" @if (old('status') == "1") {{ 'selected' }} @endif>Active</option>
										<option value="0" @if (old('status') == "0") {{ 'selected' }} @endif>Inactive</option>
									</select>
								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="address">Address<span class="text-red"></span></label>
									<textarea rows="3" name="address" id="address" class="form-control @error('address') is-invalid @enderror" placeholder="Write address" >{!! old('address') !!}</textarea>

									@error('address')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="description">Description </label>
									<textarea rows="3" name="description" id="description" class="form-control" placeholder="Describe here...">{!! old('description') !!}</textarea>
								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="image">Profile Picture<span class="text-red"></span></label>
									<input type="file"  class="dropify form-control @error('image') is-invalid @enderror" name="image" id="image" placeholder="Image" data-height="auto" >
                                    @error('image')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror
                                </div>
							</div>
						</div>

						{{-- <div class="row">
                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label for="card_name">Select Card Name<span class="text-red"></span></label>
                                    <select name="card_name[]" id="card_name" class="form-control card_name @error('card_name') is-invalid @enderror" >
                                        <option value="">Select</option>
                                        <option value="1" @if (old('card_name') == "1") {{ 'selected' }} @endif>NID</option>
                                        <option value="2" @if (old('card_name') == "2") {{ 'selected' }} @endif>Passport</option>
                                        <option value="3" @if (old('card_name') == "3") {{ 'selected' }} @endif>Birth Certificate</option>
                                        <option value="4" @if (old('card_name') == "4") {{ 'selected' }} @endif>Driving License</option>
                                    </select>

                                    @error('card_name')
                                    <span class="text-danger" role="alert">
                                        <p>{{ $message }}</p>
                                    </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label for="card_no">Identity Card No<span class="text-red"></span></label>
                                    <input type="text" id="card_no" name="card_no[]" value="{{ old('card_no') }}" class="form-control @error('card_no') is-invalid @enderror" placeholder="Enter card no" >

                                     @error('card_no')
                                    <span class="text-danger" role="alert">
                                        <p>{{ $message }}</p>
                                    </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label for="card_photo">Upload ID Card<span class="text-red"></span></label>
                                    <div class="d-flex">
                                        <input type="file" name="card_photo[]" id="card_photo" class="form-control @error('card_photo') is-invalid @enderror" >
                                        <button style="margin-left: 5px; height:37px; font-size:14px; text-align:center" type="button" name="add" id="add" class="btn btn-success">+</button>

                                        @error('card_photo')
                                        <span class="text-danger" role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div> --}}

						<div id="AddField">

                        </div>

						<div class="row mt-30">
							<div class="col-sm-12">
								<button type="submit" class="btn btn-success mr-2">Create</button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
	</section>
</div>
@push('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/js/dropify.min.js"
        integrity="sha512-8QFTrG0oeOiyWo/VM9Y8kgxdlCryqhIxVeRpWSezdRRAvarxVtwLnGroJgnVW9/XBRduxO/z1GblzPrMQoeuew==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script>
    $(document).ready(function() {
            $('.dropify').dropify();
        });
</script>
<script>
        //field append
        var i = 1;
        $("#add").click(function () {

            if( i < 4 ){
            ++i;
            $("#AddField").append(`<div class="row" id="removed">
                <div class="col-sm-4">
                    <div class="form-group">
                        <label for="card_name">Select Card Name<span class="text-red"></span></label>
                        <select name="card_name[]" id="card_name" class="form-control card_name @error('card_name') is-invalid @enderror">
                            <option value="">Select Card</option>
                            <option value="1">NID</option>
                            <option value="2">Passport</option>
                            <option value="3">Birth Certificate</option>
                            <option value="4">Driving License</option>
                        </select>
                        @error('card_name')
                            <span class="text-danger" role="alert">
                                <p>{{ $message }}</p>
                            </span>
                            @enderror
                    </div>
                </div>

                <div class="col-sm-4">
                    <div class="form-group">
                        <label for="card_no">Identity Card No<span class="text-red"></span></label>
                        <input type="number" id="card_no" name="card_no[]"  class="form-control @error('card_no') is-invalid @enderror" placeholder="Enter card no">
                        @error('card_no')
                            <span class="text-danger" role="alert">
                                <p>{{ $message }}</p>
                            </span>
                            @enderror
                    </div>
                </div>

                <div class="col-sm-4">
                    <div class="form-group">
                        <label for="card_photo">Upload ID Card<span class="text-red"></span></label>
                        <div class="d-flex">
                            <input type="file" name="card_photo[]" id="card_photo" class="form-control @error('card_photo') is-invalid @enderror">
                            <button style="margin-left: 5px; height:35px; font-size:14px; text-align:center" type="button" name="del" id="del" class="btn btn-danger btn_remove">-</button>

                            @error('card_photo')
                            <span class="text-danger" role="alert">
                                <p>{{ $message }}</p>
                            </span>
                            @enderror

                        </div>
                    </div>
                </div>
            </div>`);
        }else{
            alert("You can not add new option");
        }
    });

        $(document).on('click', '.btn_remove', function() {
            $(this).parents('#removed').remove();
            i--;
        });

        // card type duplicate validation check
        $(document).on('click', 'select.card_name', function () {
        $('select[name*="card_name[]"] option').attr('disabled',false);
        $('select[name*="card_name[]"]').each(function(){
            var $this = $(this);
            $('select[name*="card_name[]"]').not($this).find('option').each(function(){
                if($(this).attr('value') == $this.val())
                $(this).attr('disabled',true);
            });
        });
        });

    </script>
    @endpush
@endsection



