@extends('dashboard.master')
@section('title', 'Edit Staff ')
@push('css')

<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/css/dropify.min.css" integrity="sha512-EZSUkJWTjzDlspOoPSpUFR0o0Xy7jdzW//6qhUkoZ9c4StFkVsp9fbbd0O06p9ELS3H486m4wmrCELjza4JEog==" crossorigin="anonymous" referrerpolicy="no-referrer" />

<style>
    .dropify-wrapper .dropify-message p {
        font-size: initial;
    }
</style>

@endpush

@section('content')

<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="page-title-wrapper">
                <div class="page-title-heading">
                    <div class="page-title-icon">
                        <i class="nav-icon fas fa-mosque"></i>
                    </div>
                    <span>
                        <b>Edit Staff</b>
                    </span>
                </div>

                <div class="page-title-actions">
                    <a title="Back Button" href="{{ route('staff.index') }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="card">
                <div class="card-body">
                    <form enctype="multipart/form-data" action="{{ route('staff.update', $staff->id) }}" method="POST">
                        @csrf
                        @method('PUT') <!-- Use PUT method for updating -->
                        
                        <div class="row">
                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label for="staff_user_id">Staff ID<span class="text-red">*</span></label>
                                    <input type="text" name="staff_user_id" id="staff_user_id" value="{{ $staff->staff_user_id }}" class="form-control" readonly>
                                </div>
                            </div>

                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label for="name">Staff Name<span class="text-red">*</span></label>
                                    <input type="text" name="name" id="name" value="{{ old('name', $staff->name) }}" class="form-control @error('name') is-invalid @enderror" placeholder="Enter staff name" required>
                                    @error('name')
                                    <span class="text-danger" role="alert">
                                        <p>{{ $message }}</p>
                                    </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label for="join_date">Join Date<span class="text-red">*</span></label>
                                    <input type="date" name="join_date" id="join_date" value="{{ old('join_date', $staff->join_date) }}" class="form-control @error('join_date') is-invalid @enderror" required>
                                    @error('join_date')
                                    <span class="text-danger" role="alert">
                                        <p>{{ $message }}</p>
                                    </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label for="gender">Gender<span class="text-red">*</span></label>
                                    <select name="gender" id="gender" class="form-control @error('gender') is-invalid @enderror" required>
                                        <option value="1" @if(old('gender', $staff->gender) == 1) selected @endif>Male</option>
                                        <option value="2" @if(old('gender', $staff->gender) == 2) selected @endif>Female</option>
                                    </select>
                                    @error('gender')
                                    <span class="text-danger" role="alert">
                                        <p>{{ $message }}</p>
                                    </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label for="designation">Designation<span class="text-red">*</span></label>
                                    <input type="text" name="designation" id="designation" value="{{ old('designation', $staff->designation) }}" class="form-control @error('designation') is-invalid @enderror" required>
                                    @error('designation')
                                    <span class="text-danger" role="alert">
                                        <p>{{ $message }}</p>
                                    </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label for="email">Email<span class="text-red">*</span></label>
                                    <input type="email" name="email" id="email" value="{{ old('email', $staff->email) }}" class="form-control @error('email') is-invalid @enderror" required>
                                    @error('email')
                                    <span class="text-danger" role="alert">
                                        <p>{{ $message }}</p>
                                    </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label for="phone">Phone<span class="text-red">*</span></label>
                                    <input type="text" name="phone" id="phone" value="{{ old('phone', $staff->phone) }}" class="form-control @error('phone') is-invalid @enderror" required>
                                    @error('phone')
                                    <span class="text-danger" role="alert">
                                        <p>{{ $message }}</p>
                                    </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-sm-3">
                                <div class="form-group">
                                    <label for="salary">Salary<span class="text-red">*</span></label>
                                    <input type="text" name="salary" id="salary" value="{{ old('salary', $staff->salary) }}" class="form-control @error('salary') is-invalid @enderror" required>
                                    @error('salary')
                                    <span class="text-danger" role="alert">
                                        <p>{{ $message }}</p>
                                    </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-sm-3">
                                <div class="form-group">
                                    <label for="status">Status<span class="text-red">*</span></label>
                                    <select name="status" id="status" class="form-control">
                                        <option value="1" @if(old('status', $staff->status) == "1") selected @endif>Active</option>
                                        <option value="0" @if(old('status', $staff->status) == "0") selected @endif>Inactive</option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label for="address">Address</label>
                                    <textarea rows="3" name="address" id="address" class="form-control @error('address') is-invalid @enderror">{{ old('address', $staff->address) }}</textarea>
                                    @error('address')
                                    <span class="text-danger" role="alert">
                                        <p>{{ $message }}</p>
                                    </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label for="image">Profile Picture</label>
                                    <input type="file" class="dropify form-control @error('image') is-invalid @enderror" name="image" id="image" data-default-file="{{ asset('/backend/img/staff/'.$staff->image) }}">
                                    @error('image')
                                    <span class="text-danger" role="alert">
                                        <p>{{ $message }}</p>
                                    </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mt-30">
                            <div class="col-sm-12">
                                <button type="submit" class="btn btn-success mr-2">Update</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>
</div>

@push('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/js/dropify.min.js" integrity="sha512-8QFTrG0oeOiyWo/VM9Y8kgxdlCryqhIxVeRpWSezdRRAvarxVtwLnGroJgnVW9/XBRduxO/z1GblzPrMQoeuew==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script>
    $(document).ready(function() {
        $('.dropify').dropify();
    });
</script>
@endpush

@endsection
