@extends('dashboard.master')
@section('title', 'Student Comment Create')
@push('css')
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
@endpush
@section('content')

<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="page-title-wrapper">
                <div class="page-title-heading">
                    <div class="page-title-icon">
                        <i class="nav-icon fas fa-mosque"></i>
                    </div>
                    <span>
                        <b>Student Comment Create</b>
                    </span>
                </div>

                <div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="card">
                <form class="forms-sample add-class" enctype="multipart/form-data" action="{{ route('student.comment.store') }}" method="POST">
                    @csrf
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Exam<span class="text-red">*</span></label>
                                    <select name="exam_id" id="exam_id" class="form-control">
                                        <option value="">Select One</option>
                                        @foreach ($exams as $exam)
                                        <option value="{{ $exam->id }}">{{ $exam->name }}</option>
                                        @endforeach
                                    </select>

                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Session<span class="text-red">*</span></label>
                                    <select name="session_id" id="session_id" class="form-control">
                                        <option value="">Select One</option>
                                        @foreach ($stusessions as $stdession)
                                        <option value="{{ $stdession->id }}">{{ $stdession->name }}</option>
                                        @endforeach
                                    </select>

                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Class<span class="text-red">*</span></label>
                                    <select name="class_id" id="class_id" class="form-control">
                                        <option value="">Select One</option>
                                        @foreach ($classes as $class)
                                        <option value="{{ $class->id }}">{{ $class->name }}</option>
                                        @endforeach
                                    </select>

                                </div>
                            </div>

                        </div>
                        <hr>
                        <div class="table-responsive hideClass">
                            <table id="data_table" class="table table-bordered table-striped data-table table-hover">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Student</th>
                                        <th>Comment</th>
                                    </tr>
                                </thead>
                                <tbody id="student_data">

                                </tbody>
                            </table>

                        </div>


						<div class="row mt-20 hideClass">
							<div class="col-sm-12">
								<button title="Save" type="submit" class="btn btn-primary mr-2">Save</button>
							</div>
						</div>

                    </div>
                </form>
            </div>
        </div>
    </section>
</div>

@push('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<script>
$('.hideClass').hide();
$(document).ready(function() {
    $('#class_id, #session_id, #exam_id').on('change', function(event) {
        event.preventDefault();

        var session_id = $('#session_id').val();
        var class_id = $('#class_id').val();
        var exam_id = $('#exam_id').val();
        var _token = $('meta[name="csrf-token"]').attr('content');

        if (!session_id || !class_id || !exam_id) {
            return;
        }

        $.ajax({
            url: "{{ route('exam.wise.student') }}",
            type: "POST",
            data: {
                class_id: class_id,
                session_id: session_id,
                exam_id: exam_id,
                _token: _token
            },
            success: function(response) {
                $('#student_data').empty();

                $.each(response, function(index, student) {
                    let commentText = student.exam_comment?.comment ?? '';
                    let isReadonly = commentText ? 'readonly' : '';

                    var row = `<tr>
                        <td>${index + 1}</td>
                        <td>${student.name} | ${student.roll_no} | ${student.register_no}
                            <input type="hidden" name="student_id[]" value="${student.id}">
                        </td>
                        <td>
                            <textarea name="comment[]" class="form-control" rows="2" ${isReadonly}>${commentText}</textarea>
                        </td>
                    </tr>`;

                    $('#student_data').append(row);
                });


                $('.hideClass').show();
            },
            error: function(xhr, status, error) {
                console.error(error);
                alert("An error occurred while processing the request.");
            }
        });
    });
});


@if(Session::has('error'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    };
    toastr.error("{{ session('error') }}");
 @endif
</script>
@endpush
@endsection
