@extends('dashboard.master')
@section('title', 'Edit Student Leave')
@push('css')
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.1/themes/base/jquery-ui.css">
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
@endpush

@section('content')

<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Edit Student Leave</b>
					</span>
				</div>

				<div class="page-title-actions">
					<a title="Back" href="{{ URL::previous() }}" type="button" class="btn btn-sm btn-dark">
						<i class="fas fa-arrow-left mr-1"></i>
						Back
					</a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">
					<form enctype="multipart/form-data" action="{{ route('student.leave.update', $data->id) }}" method="POST">
						@csrf
                        @method('PUT')
						<div class="row">

							<div class="col-sm-6">
								<div class="form-group">
									<label for="class_id">Class<span class="text-red">*</span></label>
									<select name="class_id" id="class_id" class="form-control" required>
                                        <option value="">Choose One</option>
                                       @foreach($classes as $item)
                                        <option value="{{ $item->id }}" @if($item->id == $data->class_id) selected @endif>{{ $item->name }}</option>
                                       @endforeach
                                    </select>
								</div>
							</div>

							<div class="col-sm-6">
								<div class="form-group">
									<label for="student_id">Student<span class="text-red">*</span></label>
									<select name="student_id" id="student_id" class="form-control" required>
                                        <option value="{{ $data->student_id }}">{{ $data->students->name ?? ''}} || {{ $data->students->roll_no ?? ''}} || {{ $data->students->register_no ?? ''}}</option>
                                    </select>
								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="from_date">From Date<span class="text-red">*</span></label>
                                    <input type="text" name="from_date" id="from_date" value="{{ \Carbon\Carbon::parse($data->from_date)->format('d-F-Y') }}" class="form-control @error('from_date') is-invalid @enderror" placeholder="From date" required>

									@error('from_date')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="to_date">To Date<span class="text-red">*</span></label>
                                    <input type="text" name="to_date" id="to_date" value="{{ \Carbon\Carbon::parse($data->to_date)->format('d-F-Y') }}" class="form-control @error('to_date') is-invalid @enderror" placeholder="From date" required>

									@error('to_date')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="days">Total Days</label>
									<input type="text" name="days" id="days" value="{{ $data->days }}" class="form-control " readonly>
								</div>
							</div>

							<div class="col-sm-4">
                                <div class="form-group">
                                    <label for="leave_type">Take By</label>
                                    <select name="leave_type" id="leave_type" class="form-control" required>
                                        <option value="1" {{ $data->leave_type == 1 ? 'selected' : '' }}>Self</option>
                                        <option value="2" {{ $data->leave_type == 2 ? 'selected' : '' }}>Guardian</option>
                                    </select>
                                </div>
                            </div>

                            @if($data->leave_type == 2)
                                <div class="col-sm-4 gurdian">
                                    <div class="form-group">
                                        <label for="gurdian_name">Gurdian Name </label>
                                        <input type="text" name="gurdian_name" id="gurdian_name" value="{{ $data->gurdian_name ?? '' }}" class="form-control " >
                                    </div>
                                </div>

                                <div class="col-sm-4 gurdian">
                                    <div class="form-group">
                                        <label for="gurdian_phone">Gurdian Phone </label>
                                        <input type="text" name="gurdian_phone" id="gurdian_phone" value="{{ $data->gurdian_phone ?? '' }}" class="form-control " >
                                    </div>
                                </div>
                            @endif

                            <div class="col-sm-12">
								<div class="form-group">
									<label for="days">Note</label>
									<textarea rows="2" name="note" id="note" class="form-control" placeholder="note">{!! $data->note ?? '' !!}</textarea>
								</div>
							</div>

						</div>

						<div class="row mt-20">
							<div class="col-sm-12">
								<button title="Update" type="submit" class="btn btn-primary mr-2">Update</button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
	</section>
</div>

@push('js')
<script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<script>

$('#leave_type').on('change', function(event) {
    event.preventDefault();
    var leave_type = $(this).val();
    if(leave_type == 2){
        $('.gurdian').show();
    }else{
        $('.gurdian').hide();
    }
});
$(function () {
    $('#from_date').datepicker({
        dateFormat: 'dd-MM-yy'
    });
    $('#to_date').datepicker({
        dateFormat: 'dd-MM-yy'
    });

    $('#from_date, #to_date').on('change', function () {
        var fromDate = $('#from_date').val();
        var toDate = $('#to_date').val();

        if (fromDate && toDate) {
            var from = new Date(fromDate.split("-").reverse().join("-"));
            var to = new Date(toDate.split("-").reverse().join("-"));

            from.setHours(0, 0, 0, 0);
            to.setHours(0, 0, 0, 0);

            if (from && to && to >= from) {
                var timeDiff = to - from;
                var days = timeDiff / (1000 * 3600 * 24);
                $('#days').val(days + 1);
            } else {
                $('#days').val('');
                alert("To Date should be greater than or equal to From Date.");
            }
        }
    });
});
$(document).ready(function() {
    $('#class_id').on('change', function(event) {
        event.preventDefault();

        var url = "{{ route('class.wise.student') }}";
        var class_id = $('#class_id').val();
        var _token = $('meta[name="csrf-token"]').attr('content');

        $('#student_id').empty().append('<option value="">Choose One</option>');

        if (class_id) {
            $.ajax({
                url: url,
                type: "POST",
                data: {
                    class_id: class_id,
                    _token: _token,
                },
                success: function(response) {
                    if (response.length > 0) {
                        $.each(response, function(index, student) {
                            $('#student_id').append(
                                '<option value="' + student.id + '">' + student.name + ' || ' + student.register_no + ' || ' + student.roll_no + '</option>'
                            );
                        });
                    } else {
                        alert('No students found for this class.');
                    }
                },
                error: function(xhr, status, error) {
                    console.error(error);
                    alert("An error occurred while processing the request.");
                }
            });
        }
    });
});
@if(Session::has('success'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true,
        "timeOut" : 1000
    };

    toastr.success("{{ session('success') }}");
  @endif

 @if(Session::has('error'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    };
    toastr.error("{{ session('error') }}");
 @endif
</script>
@endpush
@endsection


