@extends('dashboard.master')
@section('title', 'Student Neshab Create')
@push('css')
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
@endpush
@section('content')

<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="page-title-wrapper">
                <div class="page-title-heading">
                    <div class="page-title-icon">
                        <i class="nav-icon fas fa-mosque"></i>
                    </div>
                    <span>
                        <b>Student Neshab Create</b>
                    </span>
                </div>

                <div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="card">
                <form class="forms-sample add-class" enctype="multipart/form-data" action="{{ route('student.neshab.store') }}" method="POST">
                    @csrf
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Exam<span class="text-red">*</span></label>
                                    <select name="exam_id" id="exam_id" class="form-control">
                                        <option value="">Select One</option>
                                        @foreach ($exams as $exam)
                                        <option value="{{ $exam->id }}">{{ $exam->name }}</option>
                                        @endforeach
                                    </select>

                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Session<span class="text-red">*</span></label>
                                    <select name="session_id" id="session_id" class="form-control">
                                        <option value="">Select One</option>
                                        @foreach ($stusessions as $stdession)
                                        <option value="{{ $stdession->id }}">{{ $stdession->name }}</option>
                                        @endforeach
                                    </select>

                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Class<span class="text-red">*</span></label>
                                    <select name="class_id" id="class_id" class="form-control">
                                        <option value="">Select One</option>
                                        @foreach ($classes as $class)
                                        <option value="{{ $class->id }}">{{ $class->name }}</option>
                                        @endforeach
                                    </select>

                                </div>
                            </div>

                        </div>
                        <hr>
                        <div class="table-responsive hideClass">
                            <table id="data_table" class="table table-bordered table-striped data-table table-hover">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Subject</th>
                                        <th>Start Page</th>
                                        <th>End Page</th>
                                        <th>Note</th>
                                    </tr>
                                </thead>
                                <tbody id="lession_data">

                                </tbody>
                            </table>

                        </div>


						<div class="row mt-20 hideClass">
							<div class="col-sm-12">
								<button title="Save" type="submit" class="btn btn-primary mr-2">Save</button>
							</div>
						</div>

                    </div>
                </form>
            </div>
        </div>
    </section>
</div>

@push('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>

<script>
    $('.hideClass').hide();

    function checkNeshabExist() {
        let class_id = $('#class_id').val();
        let exam_id = $('#exam_id').val();
        let session_id = $('#session_id').val();
        let _token = $('meta[name="csrf-token"]').attr('content');

        if (class_id && exam_id && session_id) {
            $.ajax({
                url: "{{ route('student.neshab.check') }}",
                type: "POST",
                data: {
                    class_id: class_id,
                    exam_id: exam_id,
                    session_id: session_id,
                    _token: _token
                },
                success: function(response) {
                    if (response.exists) {
                        toastr.error("Neshab data already exists");
                        $('#class_id').val('');
                        $('#exam_id').val('');
                        $('#session_id').val('');
                        $('#lession_data').html('');
                        $('.hideClass').hide();
                    } else {
                        loadSubjects(class_id, _token);
                    }
                },
                error: function(xhr, status, error) {
                    toastr.error("Something went wrong while checking existing data.");
                }
            });
        }
    }

    function loadSubjects(class_id, _token) {
        var url = "{{ route('subject.find') }}";
        $.ajax({
            url: url,
            type: "POST",
            data: {
                class_id: class_id,
                _token: _token,
            },
            success: function(response) {
                if (response.html && response.html.trim() !== '') {
                    $('#lession_data').html(response.html);
                    $('.hideClass').show();
                } else {
                    $('#lession_data').html('');
                    $('.hideClass').hide();
                }
            },
            error: function(xhr, status, error) {
                toastr.error("Failed to load subjects.");
            }
        });
    }

    $(document).ready(function() {
        $('#class_id, #exam_id, #session_id').on('change', function() {
            checkNeshabExist();
        });
    });

    // Show Laravel flash messages using Toastr
    @if(Session::has('success'))
        toastr.options = {
            "closeButton" : true,
            "progressBar" : true,
            "timeOut" : 2000
        };
        toastr.success("{{ session('success') }}");
    @endif

    @if(Session::has('error'))
        toastr.options = {
            "closeButton" : true,
            "progressBar" : true
        };
        toastr.error("{{ session('error') }}");
    @endif
</script>
@endpush

@endsection

