@extends('dashboard.master')
@section('title', 'Student Neshab Edit')
@push('css')
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
@endpush
@section('content')

<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="page-title-wrapper">
                <div class="page-title-heading">
                    <div class="page-title-icon">
                        <i class="nav-icon fas fa-mosque"></i>
                    </div>
                    <span>
                        <b>Student Neshab Edit</b>
                    </span>
                </div>

                <div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="card">
                <form class="forms-sample add-class" enctype="multipart/form-data" action="{{ route('student.neshab.update', $data->id) }}" method="POST">
                   @csrf
                   @method('PUT')
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Exam<span class="text-red">*</span></label>
                                    <select name="exam_id" id="exam_id" class="form-control">
                                        <option value="">Select One</option>
                                        @foreach ($exams as $exam)
                                        <option value="{{ $exam->id }}" @if($exam->id == $data->exam_id) selected @endif>{{ $exam->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Sessions<span class="text-red">*</span></label>
                                    <select name="session_id" id="session_id" class="form-control">
                                        <option value="">Select One</option>
                                        @foreach ($stusessions as $session)
                                        <option value="{{ $session->id }}" @if($session->id == $data->session_id) selected @endif>{{ $session->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Class<span class="text-red">*</span></label>
                                    <select name="class_id" id="class_id" class="form-control">
                                        <option value="">Select One</option>
                                        @foreach ($classes as $class)
                                        <option value="{{ $class->id }}" @if($class->id == $data->class_id) selected @endif>{{ $class->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                        </div>
                        <hr>
                        <div class="table-responsive ">
                            <table id="data_table" class="table table-bordered table-striped data-table table-hover">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Subject</th>
                                        <th>Start Page</th>
                                        <th>End Page</th>
                                        <th>Note</th>
                                    </tr>
                                </thead>
                                <tbody id="lession_data">
                                    @foreach ($subjects as $subject)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $subject->subject->name }}</td>
                                        <td> <input name="start_page[]" type="text" class="form-control" value="{{ $subject->start_page }}" required>
                                            <input type="hidden" name="subject_id[]" value="{{ $subject->subject_id }}">
                                        </td>
                                        <td> <input name="end_page[]" type="text" class="form-control" value="{{ $subject->end_page }}" required> </td>
                                        <td> <textarea name="note[]" class="form-control" rows="1">{{ $subject->note }} </textarea> </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <div class="row mt-20">
                            <div class="col-sm-12">
                                <button title="Update" type="submit" class="btn btn-primary mr-2">Update</button>
                            </div>
                        </div>

                    </div>
                </form>
            </div>
        </div>
    </section>
</div>

@push('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<script>

    $('.hideClass').hide();

    function checkNeshabExist() {
        let class_id = $('#class_id').val();
        let exam_id = $('#exam_id').val();
        let session_id = $('#session_id').val();
        let _token = $('meta[name="csrf-token"]').attr('content');

        if (class_id && exam_id && session_id) {
            $.ajax({
                url: "{{ route('student.neshab.check') }}",
                type: "POST",
                data: {
                    class_id: class_id,
                    exam_id: exam_id,
                    session_id: session_id,
                    _token: _token
                },
                success: function(response) {
                    if (response.exists) {
                        // toastr.error("Neshab data already exists");
                        loadExistingData(class_id, exam_id, session_id, _token);
                    } else {
                        loadSubjects(class_id, _token);
                    }
                },
                error: function(xhr, status, error) {
                    toastr.error("Something went wrong while checking existing data.");
                }
            });
        }
    }

    // Function to load the existing data
    function loadExistingData(class_id, exam_id, session_id, _token) {
        $.ajax({
            url: "{{ route('student.neshab.get_existing') }}",
            type: "POST",
            data: {
                class_id: class_id,
                exam_id: exam_id,
                session_id: session_id,
                _token: _token
            },
            success: function(response) {
                if (response.html) {
                    $('#lession_data').html(response.html);
                    $('.hideClass').show();
                } else {
                    $('#lession_data').html('');
                    $('.hideClass').hide();
                }
            },
            error: function(xhr, status, error) {
                toastr.error("Failed to load existing data.");
            }
        });
    }

    function loadSubjects(class_id, _token) {
        var url = "{{ route('subject.find') }}";
        $.ajax({
            url: url,
            type: "POST",
            data: {
                class_id: class_id,
                _token: _token,
            },
            success: function(response) {
                if (response.html && response.html.trim() !== '') {
                    $('#lession_data').html(response.html);
                    $('.hideClass').show();
                } else {
                    $('#lession_data').html('');
                    $('.hideClass').hide();
                }
            },
            error: function(xhr, status, error) {
                toastr.error("Failed to load subjects.");
            }
        });
    }


    $(document).ready(function() {
        checkNeshabExist();

        $('#class_id, #exam_id, #session_id').on('change', function() {
            checkNeshabExist();
        });
    });

    @if(Session::has('success'))
        toastr.options = {
            "closeButton" : true,
            "progressBar" : true,
            "timeOut" : 2000
        };
        toastr.success("{{ session('success') }}");
    @endif

    @if(Session::has('error'))
        toastr.options = {
            "closeButton" : true,
            "progressBar" : true
        };
        toastr.error("{{ session('error') }}");
    @endif
</script>
@endpush

@endsection
