@extends('dashboard.master')
@section('title', 'Admission Due')

@push('css')
    {{-- DataTables Core + Buttons CSS (all-in-one) --}}
    <link rel="stylesheet" href="{{ asset('backend/DataTables/datatables.min.css') }}">
    <style>
        .dataTables_wrapper .dataTables_filter input {
            height: 32px
        }

        #admission_due_table {
            width: 100% !important;
            table-layout: auto !important;
        }

        #admission_due_table th,
        #admission_due_table td {
            white-space: nowrap;
        }

        .print-header {
            text-align: center;
            margin-bottom: 12px;
        }

        .print-header h3 {
            margin: 0;
            font-weight: 700;
        }

        .print-header .sub {
            font-size: 12px;
            margin-top: 2px;
        }
    </style>
@endpush

@section('content')
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid d-flex justify-content-between align-items-center">
                <div class="page-title-heading d-flex align-items-center gap-2">
                    <i class="nav-icon fas fa-money-check-alt"></i>
                    <h4 class="m-0">Admission Due List</h4>
                </div>
                <a href="{{ url()->previous() }}" class="btn btn-sm btn-dark">
                    <i class="fas fa-arrow-left me-1"></i>Back
                </a>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">

                {{-- Flash alerts --}}
                @if (session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        {{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif
                @if (session('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        {{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif
                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul class="mb-0">
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <div class="card">
                    <div class="card-body table-responsive">
                        <table id="admission_due_table" class="table table-sm table-bordered table-striped align-middle">
                            <thead>
                                <tr>
                                    <th>SN</th>
                                    <th>Student</th>
                                    <th>Total</th>
                                    <th>Paid</th>
                                    <th>Discount</th>
                                    <th>Due</th>
                                    <th class="text-center">Action</th>
                                </tr>
                            </thead>
                        </table>

                    </div>
                </div>

            </div>
        </section>
    </div>

    {{-- Modal: Collect Due --}}
    <div class="modal fade" id="collectDueModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <form id="collect-due-form" method="POST" action="{{ route('admission.due.collect') }}">
                @csrf
                <input type="hidden" name="fund_detail_id" id="fund_detail_id">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Collect Admission Due</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"> </button>
                    </div>
                    <div class="modal-body">
                        <div class="row g-2">
                            <div class="col-6">
                                <label class="form-label">Total</label>
                                <input type="text" class="form-control" id="m_total" readonly>
                            </div>
                            <div class="col-6">
                                <label class="form-label">Paid</label>
                                <input type="text" class="form-control" id="m_paid" readonly>
                            </div>
                            <div class="col-6">
                                <label class="form-label">Discount</label>
                                <input type="text" class="form-control" id="m_discount" readonly>
                            </div>
                            <div class="col-6">
                                <label class="form-label">Due</label>
                                <input type="text" class="form-control" id="m_due" readonly>
                            </div>

                            <div class="col-12">
                                <label class="form-label">Receive Now <small class="text-muted">(max = Due)</small></label>
                                <input type="number" step="0.01" min="0" class="form-control" id="m_receive"
                                    name="receive_amount" required>
                            </div>

                            <div class="col-12">
                                <label class="form-label">Note (optional)</label>
                                <textarea class="form-control" name="note" rows="2" placeholder="Note"></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-light" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-success">Confirm Collection</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection

@push('js')
    {{-- DataTables Core + Buttons (single min bundle) --}}
    <script src="{{ asset('backend/DataTables/datatables.min.js') }}"></script>

    {{-- If you want real PDF export (buttons.pdfHtml5), include pdfmake + vfs --}}
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"
        integrity="sha512-tqLTm4gE0XxWw+eJXo92wo7G2O6lO4m7y7uIO9b0qzQv2R8+Qf3S3rTLIq8I0p5jTpqYd2qFhEYXhQ3nZ2L1xQ=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"
        integrity="sha512-4u9X8mFMWb8Bq0wz8E7sG4B+5oXWf8+v3FBeH1WZ3p8pB6QyUe8oV1qCq2g3nVQO9T3Jr6Qv9rQriTQ2Zl7xwg=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>

    {{-- Bootstrap 5 modal (if not already included by layout) --}}
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

    <script>
        $(function() {
            // ---- DataTable init with Buttons & export ----
        $('#admission_due_table').DataTable({
       processing: true,
  serverSide: true,
  ajax: "{{ route('admission.due') }}",
  // Default order: Due DESC (index 5)
  order: [[5, 'desc']],
  columns: [
    { data: 'DT_RowIndex', name: 'DT_RowIndex', orderable: false, searchable: false }, // ❗ no ordering on index
    { data: 'student',     name: 'students.name' },          // allow server ordering by name
    { data: 'total',       name: 'fund_details.total' },
    { data: 'amount',      name: 'fund_details.amount' },
    { data: 'discount',    name: 'fund_details.discount' },
    { data: 'due',         name: 'fund_details.due' },
    { data: 'action',      name: 'action', orderable: false, searchable: false }
  ],
        dom: "<'row'<'col-sm-2'l><'col-sm-7 text-center'B><'col-sm-3'f>>tipr",
        buttons: [
            { extend: 'copy', className: 'btn btn-sm btn-info', exportOptions: { columns: [0,1,2,3,4,5] } },
            { extend: 'excel', className: 'btn btn-sm btn-success', exportOptions: { columns: [0,1,2,3,4,5] } },
            { extend: 'pdfHtml5', className: 'btn btn-sm btn-primary', exportOptions: { columns: [0,1,2,3,4,5] } },
            { extend: 'print', className: 'btn btn-sm btn-danger', exportOptions: { columns: [0,1,2,3,4,5] } },
            { extend: 'colvis', className: 'btn btn-sm btn-warning' }
        ]
    });

            // ---- Open Modal with row data ----
            $(document).on('click', '.collect-btn', function() {
                const id = $(this).data('id');
                const total = parseFloat($(this).data('total')) || 0;
                const paid = parseFloat($(this).data('paid')) || 0;
                const discount = parseFloat($(this).data('discount')) || 0;
                const due = parseFloat($(this).data('due')) || 0;

                $('#fund_detail_id').val(id);
                $('#m_total').val(total.toFixed(2));
                $('#m_paid').val(paid.toFixed(2));
                $('#m_discount').val(discount.toFixed(2));
                $('#m_due').val(due.toFixed(2));
                $('#m_receive').val(due.toFixed(2)).attr('max', due.toFixed(2));

                new bootstrap.Modal(document.getElementById('collectDueModal')).show();
            });

            // ---- Clamp receive amount to [0, due] ----
            $('#m_receive').on('input', function() {
                const max = parseFloat($('#m_due').val()) || 0;
                let val = parseFloat($(this).val()) || 0;
                if (val < 0) val = 0;
                if (val > max) val = max;
                $(this).val(val);
            });
        });
    </script>
@endpush
