@extends('dashboard.master')
@section('title', 'Subject Print')
@push('css')
    <?php
    $invoiceBgPath = 'back_height.jpg';
    if (isset($invoice->invoice_bg) && !empty($invoice->invoice_bg)) {
        $potentialBgFile = 'img/' . $invoice->invoice_bg;
        if (file_exists(public_path($potentialBgFile))) {
            $invoiceBgPath = $potentialBgFile;
        }
    }
    ?>
    <style>
        .header,
        .footer {
            width: 100%;
            height: auto;
            display: block;
            margin: 0 auto;
        }

        .header img,
        .footer img {
            width: 100% !important;
            height: auto;
            object-fit: cover;
        }

        @media print {
            body * {
                visibility: hidden;
            }

            #printArea,
            #printArea * {
                visibility: visible;
            }

            #printArea {
                position: relative;
                width: 100%;
                left: 0;
                background-image: url('{{ asset($invoiceBgPath) }}') !important;
                background-size: cover !important;
                background-position: center !important;
                background-repeat: no-repeat !important;
            }

            .container,
            .container-fluid,
            .content-wrapper>.content {
                padding: 0 !important;
            }

            .print-table th,
            .print-table td {
                background: transparent !important;
            }

            .header {
                width: 100%;
                height: auto;
                display: block;
                margin: 0 auto;
                top: 0;
            }

            .footer {
                width: 100%;
                height: auto;
                display: block;
                margin: 0 auto;
                bottom: 0;
            }

            .header img {
                width: 100% !important;
                height: auto;
                object-fit: cover;
                top: 0;
            }

            .footer img {
                width: 100% !important;
                height: auto;
                object-fit: cover;
                bottom: 0;
            }

            @page {
                size: A4 portrait;
                margin: 0;
            }
        }
    </style>
@endpush

@section('content')
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="page-title-wrapper">
                    <div class="page-title-heading">
                        <div class="page-title-icon">
                            <i class="nav-icon fas fa-mosque"></i>
                        </div>
                        <span>
                            <b>Subject Print</b>
                        </span>
                    </div>

                    <div class="page-title-actions">
                        <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                            <i class="fas fa-arrow-left mr-1"></i>
                            Back
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                <div class="card">
                    <div class="card-body" id="printArea">
                        <div class="header">
                            <img src="{{ asset('img/' . $invoice->invoice_header) }}" alt="Header">
                        </div>

                        <div class="row">
                            <div class="col-6">
                                <h5>Class : {{ $data->stuclass->name ?? '' }}</h5>
                            </div>
                            <div class="col-6 text-right">
                                <p><strong>Date:</strong> {{ now()->format('d/m/Y') }}</p>
                            </div>
                        </div>

                        <table id="data_table" class="table table-bordered table-striped data-table table-hover print-table"
                            style="text-align: left; margin-top:15px;margin-bottom:15px;">
                            <thead>
                                <tr>
                                    <th>SN</th>
                                    <th>Subject</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($subjects as $key => $subject)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $subject->subjects->name ?? '' }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>

                        <div class="footer">
                            <img src="{{ asset('img/' . $invoice->invoice_footer) }}" alt="Footer">
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>

    @push('js')
        <script type="text/javascript">
            localStorage.clear();

            function auto_print() {
                window.print();
            }

            setTimeout(auto_print, 1000);
        </script>
    @endpush
@endsection
