@extends('dashboard.master')
@section('title', 'Edit Student ')
@push('css')
    <link rel="stylesheet" href="https://code.jquery.com/ui/1.13.1/themes/base/jquery-ui.css">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/css/dropify.min.css"
        integrity="sha512-EZSUkJWTjzDlspOoPSpUFR0o0Xy7jdzW//6qhUkoZ9c4StFkVsp9fbbd0O06p9ELS3H486m4wmrCELjza4JEog=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />

    <style>
        .dropify-wrapper .dropify-message p {
            font-size: initial;
        }

        .checkmark {
            height: 20px;
            width: 20px;
            background-color: #eee;
        }

        .bangla {
            font-weight: 0;
            font-size: 15px;
        }
    </style>
@endpush

@section('content')

    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="page-title-wrapper">
                    <div class="page-title-heading">
                        <div class="page-title-icon">
                            <i class="nav-icon fas fa-mosque"></i>
                        </div>
                        <span>
                            <b>Edit Student</b>
                        </span>
                    </div>

                    <div class="page-title-actions">
                        <a title="Back Button" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                            <i class="fas fa-arrow-left mr-1"></i>
                            Back
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                <div class="card">
                    <div class="card-body">
                        <form enctype="multipart/form-data" action="{{ route('student.update', $data->id) }}"
                            method="POST">
                            @csrf
                            @method('PUT')
                            <div class="row">

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="form_no"><span class="bangla">ফর্ম নং</span>/Form No <span
                                                class="text-red">*</span></label>
                                        <input type="text" name="form_no" id="form_no" value="{{ $data->form_no }}"
                                            class="form-control datepicker @error('form_no') is-invalid @enderror"
                                            placeholder="ফর্ম নং লিখুন" readonly>
                                        <input type="hidden" name="register_no" id="register_no"
                                            value="{{ $data->register_no ?? '' }}">
                                    </div>
                                </div>


                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="join_date"> <span class="bangla">তারিখ</span>/Date <span
                                                class="text-red">*</span></label>
                                        <input type="text" name="join_date" id="date"
                                            value="{{ $data->join_date ?? '' }}"
                                            class="form-control @error('join_date') is-invalid @enderror"
                                            placeholder="তারিখ লিখুন" required>

                                        @error('join_date')
                                            <span class="text-danger" role="alert">
                                                <p>{{ $message }}</p>
                                            </span>
                                        @enderror

                                    </div>
                                </div>

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="admission_type"><span class="bangla">ভর্তির ধরন</span>/Admission
                                            Type<span class="text-red">*</span></label>
                                        <select name="admission_type" id="admission_type"
                                            class="form-control @error('admission_type') is-invalid @enderror" required>
                                            <option value=""> <span class="bangla">Select One</span></option>
                                            <option value="1" {{ $data->admission_type == 1 ? 'selected' : '' }}> <span
                                                    class="bangla">নতুন </span></option>
                                            <option value="2" {{ $data->admission_type == 2 ? 'selected' : '' }}> <span
                                                    class="bangla">পুরাতন </span></option>
                                        </select>

                                        @error('admission_type')
                                            <span class="text-danger" role="alert">
                                                <p>{{ $message }}</p>
                                            </span>
                                        @enderror

                                    </div>
                                </div>

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="name"><span class="bangla">নাম</span>/Student Name<span
                                                class="text-red">*</span></label>
                                        <input type="text" name="name" id="name" value="{{ $data->name ?? '' }}"
                                            class="form-control @error('name') is-invalid @enderror" placeholder="নাম লিখুন"
                                            required>

                                        @error('name')
                                            <span class="text-danger" role="alert">
                                                <p>{{ $message }}</p>
                                            </span>
                                        @enderror

                                    </div>
                                </div>

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="father_name"><span class="bangla">পিতা</span>/Father Name<span
                                                class="text-red">*</span></label>
                                        <input type="text" name="father_name" id="father_name"
                                            value="{{ $data->father_name ?? '' }}"
                                            class="form-control @error('father_name') is-invalid @enderror"
                                            placeholder="পিতার নাম লিখুন" required>

                                        @error('father_name')
                                            <span class="text-danger" role="alert">
                                                <p>{{ $message }}</p>
                                            </span>
                                        @enderror

                                    </div>
                                </div>

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="mother_name"><span class="bangla">মাতা</span>/Mother Name<span
                                                class="text-red"></span></label>
                                        <input type="text" name="mother_name" id="mother_name"
                                            value="{{ $data->mother_name ?? '' }}"
                                            class="form-control @error('mother_name') is-invalid @enderror"
                                            placeholder="মাতার নাম লিখুন">

                                    </div>
                                </div>

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="birth_date"><span class="bangla">জন্ম তারিখ</span>/Date Of
                                            Birth</label>
                                        <input type="text" name="birth_date" id="birth_date"
                                            value="{{ $data->birth_date ?? '' }}"
                                            class="form-control @error('birth_date') is-invalid @enderror"
                                            placeholder="জন্ম তারিখ লিখুন">

                                    </div>
                                </div>

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="fingerprint_id"><span class="bangla">ফিঙ্গারপ্রিন্ট
                                                আইডি</span>/Fingerprint ID</label>
                                        <input type="number" name="fingerprint_id" id="fingerprint_id"
                                            value="{{ $data->fingerprint_id ?? '' }}"
                                            class="form-control @error('fingerprint_id') is-invalid @enderror"
                                            placeholder="ফিঙ্গারপ্রিন্ট আইডি লিখুন">

                                    </div>
                                </div>

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="birthcertificate"><span class="bangla">জন্ম
                                                নিবন্ধন</span>/Birthcertificate</label>
                                        <input type="number" name="birthcertificate" id="birthcertificate"
                                            value="{{ $data->birthcertificate ?? '' }}"
                                            class="form-control @error('birthcertificate') is-invalid @enderror"
                                            placeholder="জন্ম নিবন্ধন লিখুন">

                                    </div>
                                </div>

                                <div class="col-sm-3 preData">
                                    <div class="form-group">
                                        <label for="pre_madrasha"><span class="bangla">পূর্ববর্তী মাদ্রাসার
                                                নাম</span>/Previous Madrasha</label>
                                        <input type="text" name="pre_madrasha" id="pre_madrasha"
                                            value="{{ $data->pre_madrasha ?? '' }}" class="form-control"
                                            placeholder="পূর্ববর্তী মাদ্রাসার নাম লিখুন">

                                    </div>
                                </div>

                                <div class="col-sm-3 preData">
                                    <div class="form-group">
                                        <label for="pre_class"><span class="bangla">পূর্ববর্তী ক্লাসের নাম
                                            </span>/Previous Class</label>
                                        <input type="text" name="pre_class" id="pre_class"
                                            value="{{ $data->pre_class ?? '' }}"
                                            class="form-control @error('pre_class') is-invalid @enderror"
                                            placeholder="পূর্ববর্তী ক্লাসের নাম লিখুন">

                                    </div>
                                </div>

                                <div class="col-sm-3 newData">
                                    <div class="form-group">
                                        <label for="new_result"><span class="bangla">নতুন শিক্ষার্থীর রেজাল্ট</span>/New
                                            Student Result</label>
                                        <input type="text" name="new_result" id="new_result"
                                            value="{{ $data->new_result ?? '' }}"
                                            class="form-control @error('new_result') is-invalid @enderror"
                                            placeholder="নতুন শিক্ষার্থীর রেজাল্ট লিখুন">

                                    </div>
                                </div>

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="student_type"><span class="bangla">শিক্ষার্থীর ধরন</span>/Student Type
                                            <span class="text-red">*</span></label>
                                        <select name="student_type" id="student_type"
                                            class="form-control @error('student_type') is-invalid @enderror" required>
                                            <option value="2" {{ $data->student_type == 2 ? 'selected' : '' }}> <span
                                                    class="bangla">আবাসিক</span></option>
                                            <option value="1" {{ $data->student_type == 1 ? 'selected' : '' }}> <span
                                                    class="bangla">অনাবাসিক</span></option>
                                            <option value="3" {{ $data->student_type == 3 ? 'selected' : '' }}> <span
                                                    class="bangla">ডে কেয়ার</span></option>

                                        </select>

                                        @error('student_type')
                                            <span class="text-danger" role="alert">
                                                <p>{{ $message }}</p>
                                            </span>
                                        @enderror

                                    </div>
                                </div>

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="session_id"><span class="bangla">শিক্ষার্থীর সেশন</span><span
                                                class="text-red">*</span></label>
                                        <select name="session_id" id="session_id"
                                            class="form-control @error('session_id') is-invalid @enderror" required>
                                            <option value=""> <span class="bangla">Select One</span></option>
                                            @foreach ($sessions as $item)
                                                <option value="{{ $item->id }}"
                                                    @if ($item->id == $data->session_id) selected @endif>
                                                    {{ $item->name ?? '' }}</option>
                                            @endforeach
                                        </select>

                                        @error('session_id')
                                            <span class="text-danger" role="alert">
                                                <p>{{ $message }}</p>
                                            </span>
                                        @enderror

                                    </div>
                                </div>

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="class_id"><span class="bangla">ক্লাস</span>/Class<span
                                                class="text-red">*</span></label>

                                        <select name="class_id" id="class_id"
                                            class="form-control @error('class_id') is-invalid @enderror" required>
                                            <option value=""><span class="bangla">ক্লাস নির্বাচন করুন</span>
                                            </option>
                                            @foreach ($class as $key => $item)
                                                <option value="{{ $item->id }}"
                                                    @if ($item->id == $data->class_id) selected @endif>
                                                    {{ $item->name ?? '' }} </option>
                                            @endforeach
                                        </select>

                                        @error('class_id')
                                            <span class="text-danger" role="alert">
                                                <p>{{ $message }}</p>
                                            </span>
                                        @enderror

                                    </div>
                                </div>

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="form_no"><span class="bangla">রোল নং</span>/Roll No<span
                                                class="text-red">*</span></label>
                                        <input type="text" name="roll_no" id="roll_no"
                                            value="{{ $data->roll_no ?? '' }}"
                                            class="form-control @error('form_no') is-invalid @enderror"
                                            placeholder="রোল নং লিখুন">

                                    </div>
                                </div>


                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="gender"><span class="bangla">শিক্ষার্থীর লিঙ্গ</span>/Student
                                            Gender<span class="text-red">*</span></label>

                                        <select name="gender" id="gender"
                                            class="form-control @error('gender') is-invalid @enderror" required>
                                            <option value=""><span class="bangla">লিঙ্গ নির্বাচন করুন</span>
                                            </option>
                                            <option value="1" {{ $data->gender == 1 ? 'selected' : '' }}>ছেলে
                                            </option>
                                            <option value="2" {{ $data->gender == 2 ? 'selected' : '' }}>মেয়ে
                                            </option>
                                        </select>

                                        @error('gender')
                                            <span class="text-danger" role="alert">
                                                <p>{{ $message }}</p>
                                            </span>
                                        @enderror

                                    </div>
                                </div>

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="etim"><span class="bangla">এতিম <span
                                                    class="text-red">*</span></label>
                                        <select name="etim" id="etim"
                                            class="form-control @error('etim') is-invalid @enderror" required>
                                            <option value=""> <span class="bangla"> সিলেক্ট করুন</span></option>
                                            <option value="1" {{ $data->etim == 1 ? 'selected' : '' }}> <span
                                                    class="bangla">হ্যাঁ</span></option>
                                            <option value="2" {{ $data->etim == 2 ? 'selected' : '' }}> <span
                                                    class="bangla">না</span></option>
                                        </select>

                                        @error('etim')
                                            <span class="text-danger" role="alert">
                                                <p>{{ $message }}</p>
                                            </span>
                                        @enderror

                                    </div>
                                </div>

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="village"><span class="bangla">গ্রাম</span>/Village </label>
                                        <input type="text" name="village" id="village"
                                            value="{{ $data->village ?? '' }}"
                                            class="form-control @error('village') is-invalid @enderror"
                                            placeholder="গ্রাম লিখুন">

                                        @error('village')
                                            <span class="text-danger" role="alert">
                                                <p>{{ $message }}</p>
                                            </span>
                                        @enderror

                                    </div>
                                </div>

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="post_office"><span class="bangla">ডাকঘর</span>/Post Office </label>
                                        <input type="text" name="post_office" id="post_office"
                                            value="{{ $data->post_office ?? '' }}"
                                            class="form-control @error('post_office') is-invalid @enderror"
                                            placeholder="ডাকঘর লিখুন">

                                        @error('post_office')
                                            <span class="text-danger" role="alert">
                                                <p>{{ $message }}</p>
                                            </span>
                                        @enderror

                                    </div>
                                </div>

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="police_station"><span class="bangla">থানা</span>/Police Station
                                        </label>
                                        <input type="text" name="police_station" id="police_station"
                                            value="{{ $data->police_station ?? '' }}"
                                            class="form-control @error('police_station') is-invalid @enderror"
                                            placeholder="থানা লিখুন">

                                        @error('police_station')
                                            <span class="text-danger" role="alert">
                                                <p>{{ $message }}</p>
                                            </span>
                                        @enderror

                                    </div>
                                </div>

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="district"><span class="bangla">জেলা</span>/District</label>
                                        <input type="text" name="district" id="district"
                                            value="{{ $data->district ?? '' }}"
                                            class="form-control @error('district') is-invalid @enderror"
                                            placeholder="জেলা লিখুন">

                                        @error('district')
                                            <span class="text-danger" role="alert">
                                                <p>{{ $message }}</p>
                                            </span>
                                        @enderror

                                    </div>
                                </div>

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="gurdian_name"><span class="bangla">অভিভাবকের নাম</span>/Gurdian
                                            Name</label>
                                        <input type="text" name="gurdian_name"
                                            value="{{ $data->gurdian_name ?? '' }}" class="form-control"
                                            id="gurdian_name" placeholder="অভিভাবকের নাম লিখুন">
                                    </div>
                                </div>

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="gurdian_mobile"><span class="bangla">মোবাইল</span>/Mobile<span
                                                class="text-red">*</span></label>
                                        <input type="number" value="{{ $data->gurdian_mobile ?? '' }}"
                                            id="gurdian_mobile" name="gurdian_mobile" class="form-control"
                                            placeholder="মোবাইল নং লিখুন" required>
                                    </div>
                                </div>

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="gurdian_name_two"><span class="bangla">অভিভাবকের নাম ২</span>/Gurdian
                                            Name 2</label>
                                        <input type="text" value="{{ $data->gurdian_name_two ?? '' }}"
                                            id="gurdian_name_two" name="gurdian_name_two" class="form-control"
                                            placeholder="অভিভাবকের নাম লিখুন">
                                    </div>
                                </div>

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="gurdian_mobile_two"><span class="bangla">অভিভাবকের মোবাইল
                                                ২</span>/Gurdian Mobile 2</label>
                                        <input type="number" maxlength="11" name="gurdian_mobile_two"
                                            value="{{ $data->gurdian_mobile_two ?? '' }}" class="form-control"
                                            id="gurdian_mobile_two" placeholder="অভিভাবকের মোবাইল লিখুন">
                                    </div>

                                </div>

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="gurdian_name_three"><span class="bangla">অভিভাবকের নাম
                                                ৩</span>/Gurdian Name 3</label>
                                        <input type="text" value="{{ $data->gurdian_name_three ?? '' }}"
                                            id="gurdian_name_three" name="gurdian_name_three" class="form-control"
                                            placeholder="অভিভাবকের নাম লিখুন">
                                    </div>
                                </div>

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="gurdian_mobile_three"><span class="bangla">অভিভাবকের মোবাইল
                                                ৩</span>/Gurdian Mobile 3</label>
                                        <input type="number" maxlength="11" name="gurdian_mobile_three"
                                            value="{{ $data->gurdian_mobile_three ?? '' }}" class="form-control"
                                            id="gurdian_mobile_three" placeholder="অভিভাবকের মোবাইল লিখুন">
                                    </div>

                                </div>



                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="gurdian_nid"><span class="bangla">অভিভাবকের এন আইডি </span>/Gurdian
                                            NID</label>
                                        <input type="text" name="gurdian_nid" value="{{ $data->gurdian_nid ?? '' }}"
                                            class="form-control" id="gurdian_nid" placeholder="অভিভাবকের এন আইডি লিখুন">
                                    </div>
                                </div>

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="id_number"><span class="bangla">আইডি নাম্বার</span>/Id Number</label>
                                        <input type="text" name="id_number"
                                            value="{{ old('id_number', $data->id_number) }}" class="form-control"
                                            id="id_number" placeholder=" আইডি নাম্বার লিখুন">
                                    </div>
                                </div>

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="relation"><span class="bangla">সম্পর্ক</span>/Relation</label>
                                        <input type="text" value="{{ $data->relation ?? '' }}" id="relation"
                                            name="relation" class="form-control" placeholder="সম্পর্ক লিখুন">
                                    </div>
                                </div>



                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="monthly_dis"><span class="bangla">মাসিক ফী ডিসকাউন্ট</label>
                                        <input type="number" id="monthly_dis" value="{{ $data->monthly_dis ?? 0 }}"
                                            name="monthly_dis" class="form-control" placeholder="monthly discount">
                                    </div>
                                </div>

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="admission_fee">
                                            <span class="bangla">ভর্তি ফী
                                                @if (empty($admissionFee->amount))
                                                    <span style="color: red;">Set admission fee first</span>
                                                @endif
                                            </span>/Admission Fee<span class="text-red">*</span>
                                        </label>
                                        <input type="number" name="admission_fee" value="{{ $admissionFee->amount ?? '' }}"
                                            id="admission_fee" class="form-control" readonly>
                                    </div>
                                </div>

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="admission_fee_receive"><span class="bangla">ভর্তি ফী
                                                গ্রহণ</span>/Admission Fee Receive<span class="text-red">*</span></label>
                                        <input type="number" value="{{ $fees->amount ?? '' }}"
                                            id="admission_fee_receive" name="admission_fee_receive" class="form-control"
                                            placeholder="Admission fee" readonly>
                                    </div>
                                </div>

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="discount"><span class="bangla">ভর্তি ফী ডিসকাউন্ট</label>
                                        <input type="number" value="{{ $fees->discount ?? 0 }}" id="discount"
                                            name="discount" class="form-control" placeholder="discount">
                                    </div>
                                </div>

                                 <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="due"><span class="bangla">বাকি ভর্তি ফী</span>/Admission Fee
                                            Due</label>
                                        <input type="number" id="due" name="due" value="{{ $fees->due ?? 0 }}"
                                            min="0" class="form-control" placeholder="due">
                                    </div>
                                </div>


                            </div>

                            <div class="row">

                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="gurdian_address"><span class="bangla">অভিভাবকের
                                                ঠিকানা</span>/Gurdian's Address</label>
                                        <textarea name="gurdian_address" class="form-control" rows="3" placeholder="অভিভাবকের ঠিকানা লিখুন">{{ $data->gurdian_address ?? '' }}</textarea>
                                    </div>
                                </div>

                                {{-- <div class="col-sm-6">
                            <div class="form-group">
                                <label for="image"><span class="bangla">শিক্ষার্থীর ছবি</span>/Picture</label>
                                <input data-height="auto" type="file" class="dropify form-control @error('image') is-invalid @enderror" name="image" id="image" placeholder="Image" data-default-file="{{ asset('backend/img/student/'.$data->image) }}" accept="image/*">
                                <input type="hidden" name="current_image" value="{{ $data->image ?? '' }}" />
                                <input type="hidden" id="remove_image" name="remove_image" value="0">
                            </div>
                        </div> --}}


                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label><span class="bangla">শিক্ষার্থীর ছবি</span>/Student Photo</label><br>

                                        <!-- Buttons -->
                                        <button type="button" class="btn btn-sm btn-primary mb-2" id="openCamera" style="width: 45%">📷
                                            Take Photo</button>
                                        <button type="button" class="btn btn-sm btn-secondary mb-2" id="openGallery" style="width: 45%">🖼️
                                            Select from Gallery</button>

                                        <!-- One input only -->
                                        <input type="file" name="image" id="image" accept="image/*"
                                            class="form-control d-none">

                                        <!-- Preview -->
                                        <div id="preview-container" class="mt-2">
                                            <img id="preview-image"
                                                src="{{ isset($data->image) ? asset('backend/img/student/' . $data->image) : '#' }}"
                                                alt="Preview"
                                                style="max-width: 200px; {{ isset($data->image) ? '' : 'display:none;' }}">
                                        </div>

                                        @error('image')
                                            <span class="text-danger" role="alert">
                                                <p>{{ $message }}</p>
                                            </span>
                                        @enderror
                                    </div>
                                </div>



                            </div>

                            {{-- <div class="row" id="newForm">

                        <div class=" @if ($data->student_type == 1) col-md-12 @else col-md-6 @endif">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>SN</th>
                                        <th>Academic Fees</th>
                                        <th class="text-center">Amount</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($academicFees as $fee)
                                        <tr>
                                            <td>{{ $loop->iteration }}</td>
                                            <td class="text-left">
                                                {{ $fee->fees->name }}
                                                <input type="hidden" name="fee_id[]" value="{{ $fee->fee_id }}">
                                                <input type="hidden" name="fee_assign_id[]" value="{{ $fee->fee_assign_id }}">
                                            </td>
                                            <td class="text-center" style="width: 30%;">
                                                <input type="number" class="form-control text-center" value="{{ $fee->feeAssign->amount }}" step="any" min="0" name="amount[]" placeholder="Amount" readonly>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        @if ($data->student_type == 2)
                        <div class="col-md-6">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>SN</th>
                                        <th>Hostel Fees</th>
                                        <th class="text-center">Amount</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($hostelFees as $fee)
                                        <tr>
                                            <td>{{ $loop->iteration }}</td>
                                            <td class="text-left">
                                                {{ $fee->fees->name }}
                                                <input type="hidden" name="fee_id[]" value="{{ $fee->fee_id }}">
                                                <input type="hidden" name="fee_assign_id[]" value="{{ $fee->fee_assign_id }}">
                                            </td>
                                            <td class="text-center" style="width: 30%;">
                                                <input type="number" class="form-control text-center" value="{{ $fee->feeAssign->amount }}" step="any" min="0" name="amount[]" placeholder="Amount" readonly>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        @endif
                    </div> --}}


                            <div class="row mt-30">
                                <div class="col-sm-12">
                                    <button type="submit" class="btn btn-success mr-2">Update</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </section>
    </div>
    @push('js')
        <script src="https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/js/dropify.min.js"
            integrity="sha512-8QFTrG0oeOiyWo/VM9Y8kgxdlCryqhIxVeRpWSezdRRAvarxVtwLnGroJgnVW9/XBRduxO/z1GblzPrMQoeuew=="
            crossorigin="anonymous" referrerpolicy="no-referrer"></script>

        <script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.inputmask/5.0.8/jquery.inputmask.min.js"></script>
        <script>
            $(document).ready(function() {
                $('.dropify').dropify();

                var drEvent = $('.dropify').dropify();

                drEvent.on('dropify.beforeClear', function(event, element) {
                    return confirm("Are you sure you want to remove this image?");
                });

                drEvent.on('dropify.afterClear', function(event, element) {
                    $('#remove_image').val(1);
                });
            });



            $(function() {
                $('#date').datepicker({
                    dateFormat: 'yy-mm-dd',
                    onSelect: function(dateText) {
                        alert("Data will be updated to this date: " + dateText);
                    }
                });

                $('#date').inputmask('9999-99-99', {
                    placeholder: 'yyyy-mm-dd',
                    clearIncomplete: true
                });
            });

            $(function() {
                $('#birth_date').datepicker({
                    dateFormat: 'yy-mm-dd'
                });

                $('#birth_date').inputmask('9999-99-99', {
                    placeholder: 'yyyy-mm-dd',
                    clearIncomplete: true
                });
            });

            // $(document).ready(function() {
            //     function fetchFees() {
            //         var class_id = $('#class_id').val();
            //         var type = $('#student_type').val();
            //         $.ajax({
            //             url: "{{ route('class.fees') }}",
            //             type: 'POST',
            //             data: {
            //                 type: type,
            //                 class_id: class_id,
            //                 _token: '{{ csrf_token() }}'
            //             },
            //             success: function(data) {
            //                 $('#newForm').html(data.html);
            //             }
            //         });
            //     }

            //     $('#class_id').on('change', function() {
            //         fetchFees();
            //     });

            //     $('#student_type').on('change', function() {
            //         fetchFees();
            //     });
            // });

            // $(document).ready(function() {
            //     $('#discount').on('input', function() {
            //         var admissionFee = parseFloat($('#admission_fee').val()) || 0;
            //         var discount = parseFloat($(this).val()) || 0;

            //         if (discount > admissionFee) {
            //             discount = 0;
            //             $('#discount').val(discount);
            //         }

            //         var discountedAmount = admissionFee - discount;
            //         $('#admission_fee_receive').val(discountedAmount);
            //     });
            // });


              $(document).ready(function() {
                function calculateDue() {
                    var admissionFee = parseFloat($('#admission_fee').val()) || 0;
                    var discount = parseFloat($('#discount').val()) || 0;
                    var due = parseFloat($('#due').val()) || 0;

                    // Clamp discount
                    if (discount < 0) discount = 0;
                    if (discount > admissionFee) discount = admissionFee;
                    $('#discount').val(discount);

                    // Remaining after discount
                    var remaining = admissionFee - discount;

                    // Clamp due (cannot exceed remaining)
                    if (due < 0) due = 0;
                    if (due > remaining) due = remaining;
                    $('#due').val(due);

                    // Amount to receive now
                    var receive = remaining - due;
                    $('#admission_fee_receive').val(receive);
                }

                // Recalculate when any of these change
                $('#discount, #due').on('input', calculateDue);

                // Initial calc
                calculateDue();
            });

            $(document).ready(function() {
                $('#class_id, #session_id').on('change', function() {
                    var class_id = $('#class_id').val();
                    var session_id = $('#session_id').val();
                    var student_id = {{ $data->id ?? '' }};

                    if (class_id && session_id) {
                        $.ajax({
                            url: "{{ route('roll.check') }}",
                            type: 'POST',
                            data: {
                                class_id: class_id,
                                session_id: session_id,
                                student_id: student_id,
                                _token: '{{ csrf_token() }}'
                            },
                            success: function(data) {
                                $('#roll_no').val(data);
                                console.log(data);
                            },
                            error: function(xhr, status, error) {
                                console.log('Error:', error);
                            }
                        });
                    }
                });
            });


            // Trigger camera or gallery
            $('#openCamera').on('click', function() {
                $('#image').attr('capture', 'environment').click();
            });

            $('#openGallery').on('click', function() {
                $('#image').removeAttr('capture').click();
            });

            // Show preview
            $('#image').on('change', function() {
                if (this.files && this.files[0]) {
                    const reader = new FileReader();
                    reader.onload = function(e) {
                        $('#preview-image').attr('src', e.target.result).show();
                    };
                    reader.readAsDataURL(this.files[0]);
                }
            });
        </script>
    @endpush
@endsection
