@extends('dashboard.master')
@section('title', 'Student Details')
@push('css')
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
 @endpush
@section('content')
<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Student Details</b>
					</span>
				</div>

				<div class="page-title-actions">

                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
						<i class="fas fa-arrow-left mr-1"></i>
						Back
					</a>

                    <a title="Edit" id="edit" href="{{ route('student.edit', $data->id) }}" class="btn btn-sm btn-primary edit" title="Edit"><i class="fa fa-edit"></i> Edit</a>

                    <a title="list" href="{{ route('student.index') }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Student List
                    </a>

					<a title="print" target="_blank" href="{{ route('form-print', $data->id) }}" type="button" class="btn btn-sm btn-danger">
                        <i class="fas fa-file mr-1"></i>
                        Print
                    </a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">
                    <div class="row">
                        <div class="col-sm-6">
                        <table id="data_table" class="table table-bordered table-striped data-table table-hover">
                            <tbody>
                                <tr>
                                    <td width="50%"><span class="bangla">ফর্ম নং</span>/Form No</td>
                                    <td>{{ $data->form_no ?? '--' }}</td>
                                </tr>
                                <tr>
                                    <td width="50%"><span class="bangla">নিবন্ধন নং</span>/Register No</td>
                                    <td>{{ $data->register_no ?? '--' }}</td>
                                </tr>

                                <tr>
                                    <td><span class="bangla">নাম</span>/Student Name</td>
                                    <td>{{ $data->name ?? '--' }}</td>
                                </tr>

                                <tr>
                                    <td><span class="bangla">পিতা</span>/Father Name</td>
                                    <td>{{ $data->father_name ?? '--' }}</td>
                                </tr>

                                <tr>
                                    <td><span class="bangla">মাতা</span>/Mother Name</td>
                                    <td>{{ $data->mother_name ?? '--' }}</td>
                                </tr>

                                <tr>
                                    <td><span class="bangla">ভর্তির ধরন</span>/Admission Type</td>
                                    <td>
                                        @if($data->admission_type == 1)
                                        নতুন ভর্তি
                                        @elseif($data->admission_type == 2)
                                        পুরাতন ভর্তি
                                        @endif
                                    </td>
                                </tr>

                                <tr>
                                    <td><span class="bangla">জন্ম তারিখ</span>/Birth Date</td>
                                    <td>@if(!empty($birthDay)) {{ $birthDay  ?? '' }} @endif </td>
                                </tr>

                                <tr>
                                    <td><span class="bangla">জন্ম নিবন্ধন</span>/Birthcertificate</td>
                                    <td>{{ $data->birthcertificate  ?? '' }}</td>
                                </tr>

                                <tr>
                                    <td><span class="bangla">ক্লাস</span>/Class</td>
                                    <td>{{ $data->stuclass->name }}</td>
                                </tr>

                                <tr>
                                    <td><span class="bangla">ছাত্রের ধরন</span>/Student Type</td>
                                    <td>
                                        @if($data->student_type == 1)
                                        অনাবাসিক
                                        @elseif($data->student_type == 2)
                                        আবাসিক
                                        @elseif($data->student_type == 3)
                                        ডে- কেয়ার
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td><span class="bangla">লিঙ্গ</span>/Student Gender</td>
                                    <td>
                                        @if($data->gender == 1)
                                        ছেলে
                                        @elseif($data->gender == 2)
                                        মেয়ে
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td><span class="bangla">এতিমের ধরন</span>/Etim Type</td>
                                    <td>
                                        @if($data->etim == 1)
                                        হ্যাঁ
                                        @elseif($data->etim == 2)
                                        না
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td><span class="bangla">তারিখ/Date</span></td>
                                    <td>{{ $date ?? '--' }}</td>
                                </tr>
                                @if($data->admission_type == 1)
                                <tr>
                                    <td><span class="bangla">নতুন ছাত্রের রেজাল্ট/New Student Result</span></td>
                                    <td>{{ $data->new_result ?? '--' }}</td>
                                </tr>
                                @endif

                                <tr>
                                    <td><span class="bangla">আইডি নাম্বার /Id Number</span></td>
                                    <td>{{ $data->id_number ?? '--' }}</td>
                                </tr>


                            </tbody>
                        </table>
                        </div>

                        <div class="col-sm-6">
                        <table id="data_table" class="table table-bordered table-striped data-table table-hover">
                            <tbody>
                                <tr>
                                    <td><span class="bangla">রোল নং /Roll No</span></td>
                                    <td>{{ $data->roll_no ?? '--' }}</td>
                                </tr>
                                <tr>
                                    <td><span class="bangla">ভর্তি ফী/Admission Fee</span></td>
                                    <td>{{ $admissionFee->amount ?? '--' }}</td>
                                </tr>

                                @if($data->admission_type == 2)
                                <tr>
                                    <td><span class="bangla">পূর্ববর্তী মাদ্রাসার নাম</span>/Previous Madrasha</td>
                                    <td>{{ $data->pre_madrasha ?? '--' }}</td>
                                </tr>
                                <tr>
                                    <td><span class="bangla">পূর্ববর্তী ক্লাসের নাম</span>/Previous Class</td>
                                    <td>{{ $data->pre_class ?? '--' }}</td>
                                </tr>
                                @endif

                                <tr>
                                    <td><span class="bangla">গ্রাম</span>/Village</td>
                                    <td>{{ $data->village ?? '--' }}</td>
                                </tr>


                                <tr>
                                    <td><span class="bangla">ডাকঘর</span>/Post Office</td>
                                    <td>{{ $data->post_office ?? '--' }}</td>
                                </tr>

                                <tr>
                                    <td><span class="bangla">থানা</span>/Police Station</td>
                                    <td>{{ $data->police_station ?? '--' }}</td>
                                </tr>

                                <tr>
                                    <td><span class="bangla">জেলা</span>/District</td>
                                    <td>{{ $data->district ?? '--' }}</td>
                                </tr>

                                <tr>
                                    <td><span class="bangla">অভিভাবকের নাম</span>/Gurdian Name</td>
                                    <td>{{ $data->gurdian_name ?? '--' }}</td>
                                </tr>
                                @if ($data->gurdian_name_two)
                                <tr>
                                    <td><span class="bangla">অভিভাবকের নাম ২</span>/Gurdian Name 2</td>
                                    <td>{{ $data->gurdian_name_two ?? '--' }}</td>
                                </tr>
                                @endif
                                @if ($data->gurdian_name_three)
                                <tr>
                                    <td><span class="bangla">অভিভাবকের নাম ৩</span>/Gurdian Name 3</td>
                                    <td>{{ $data->gurdian_name_three ?? '--' }}</td>
                                </tr>
                                @endif
                                 @if ($data->gurdian_mobile_two)
                                     <tr>
                                    <td><span class="bangla">অভিভাবকের মোবাইল ২</span>/Gurdian Mobile 2</td>
                                    <td>{{ $data->gurdian_mobile_two ?? '--' }}</td>
                                     </tr>
                                 @endif

                                @if ($data->gurdian_mobile_three)
                                    <tr>
                                    <td><span class="bangla">অভিভাবকের মোবাইল ৩</span>/Gurdian Mobile 3</td>
                                    <td>{{ $data->gurdian_mobile_three ?? '--' }}</td>
                                    </tr>
                                @endif
                                <tr>
                                    <td><span class="bangla">অভিভাবকের এন আইডি</span>/Gurdian NID</td>
                                    <td>{{ $data->gurdian_nid ?? '--' }}</td>
                                </tr>
                                <tr>
                                    <td><span class="bangla">সম্পর্ক</span>/Relation</td>
                                    <td>{{ $data->relation ?? '--' }}</td>
                                </tr>
                                <tr>
                                    <td><span class="bangla">অভিভাবকের মোবাইল</span>/Gurdian Mobile</td>
                                    <td>{{ $data->gurdian_mobile ?? '--' }}</td>
                                </tr>
                                <tr>
                                    <td><span class="bangla">অভিভাবকের ঠিকানা</span>/Gurdian Address</td>
                                    <td>{{ $data->gurdian_address?? '--' }}</td>
                                </tr>

                                <tr>
                                    <td><span class="bangla">ছাত্রের ছবি</span>/Student Photo</td>
                                    <td><img height="50px" width="100px" src="{{ asset('backend/img/student/'.$data->image)}}" alt="Photo">
                                    </td>
                                </tr>

                                <tr>
                                    <td>
                                        <span class="bangla">ভর্তি ফী গ্রহণ/Received</span> <br>
                                        <span class="bangla">ভর্তি ফী বাকি/Due</span> <br>
                                           @if(!empty($addmissionFees->discount))<span class="bangla">ভর্তি ফী ডিসকাউন্ট /Discount</span>@endif <br>
                                        @if(!empty($data->monthly_dis))<span class="bangla">মাসিক ফী ডিসকাউন্ট /Monthly Discount</span> @endif
                                    </td>
                                    <td>
                                        {{ $addmissionFees->amount ?? '--' }} <br>
                                        {{ $addmissionFees->due ?? '--' }} <br>
                                       @if(!empty($data->discount))  {{ $data->discount ?? '--' }}@endif<br>
                                        @if(!empty($data->monthly_dis)) {{ $data->monthly_dis ?? '--' }}@endif
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <span class="bangla">ফিঙ্গারপ্রিন্ট আইডি/Fingerprint ID</span>
                                    </td>
                                    <td> {{ $data->fingerprint_id ?? ''}} </td>
                                </tr>

                            </tbody>
                        </table>
                        </div>
                    </div>
				</div>
			</div>

            <div class="card">
				<div class="card-body">

                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div @if($data->student_type == 1) class="col-md-12" @else class="col-md-6" @endif>
                                    <table id="data_table" class="table table-bordered table-striped data-table table-hover">
                                        <thead>
                                            <tr>
                                                <th>SN</th>
                                                <th>Month</th>
                                                <th class="text-center">Name</th>
                                                <th class="text-center">Amount</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php $sn = 1; @endphp
                                            @foreach($academicFees as $month => $items)
                                                <tr>
                                                    <td>{{ $sn++ }}</td>
                                                    <td>{{ \Carbon\Carbon::parse($month)->format('F, Y') }}</td>
                                                    <td colspan="2">
                                                        <table class="table">
                                                            <tbody>
                                                                @foreach($items as $fee)
                                                                    <tr>
                                                                        <td class="text-left" style="width: 24.40%;">{{ $fee->fees->name ?? '' }}</td>
                                                                        <td class="text-center" style="width: 30%;">{{ $fee->amount }}</td>
                                                                    </tr>
                                                                @endforeach
                                                            </tbody>
                                                        </table>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>

                                @if($data->student_type == 2 && $hostelFees->isNotEmpty())

                                <div class="col-md-6">
                                    <table id="data_table" class="table table-bordered table-striped data-table table-hover">
                                        <thead>
                                            <tr>
                                                <th>SN</th>
                                                <th class="text-center">Hostel Fee</th>
                                                <th class="text-center">Amount</th>
                                            </tr>
                                        </thead>

                                        <tbody>
                                            @php $sn = 1; @endphp
                                            @foreach($hostelFees as $month => $items)
                                                <tr>
                                                    <td>{{ $sn++ }}</td>
                                                    <td>{{ \Carbon\Carbon::parse($month)->format('F, Y') }}</td>
                                                    <td colspan="2">
                                                        <table class="table">
                                                            <tbody>
                                                                @foreach($items as $fee)
                                                                    <tr>
                                                                        <td class="text-left" style="width: 24.40%;">{{ $fee->fees->name ?? '' }}</td>
                                                                        <td class="text-center" style="width: 30%;">{{ $fee->amount }}</td>
                                                                    </tr>
                                                                @endforeach
                                                            </tbody>
                                                        </table>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                @endif
                            </div>
                        </div>
                    </div>

				</div>
			</div>

		</div>
	</section>
</div>
@push('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<script>
@if(Session::has('success'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true,
        "timeOut" : 2000
    };

    toastr.success("{{ session('success') }}");
  @endif

 @if(Session::has('error'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    };
    toastr.error("{{ session('error') }}");
 @endif
</script>
@endpush
@endsection




