@extends('dashboard.master')
@section('title', 'Create Student ')
@push('css')
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.1/themes/base/jquery-ui.css">
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/css/dropify.min.css" integrity="sha512-EZSUkJWTjzDlspOoPSpUFR0o0Xy7jdzW//6qhUkoZ9c4StFkVsp9fbbd0O06p9ELS3H486m4wmrCELjza4JEog==" crossorigin="anonymous" referrerpolicy="no-referrer" />

<style>
    .dropify-wrapper .dropify-message p {
        font-size: initial;
    }
    .checkmark {
        height: 20px;
        width: 20px;
        background-color: #eee;
    }
    .bangla{
            font-weight: 0;
            font-size:15px;
        }
</style>

@endpush

@section('content')

<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Create Student</b>
					</span>
				</div>

				<div class="page-title-actions">
					<a title="Back Button" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
						<i class="fas fa-arrow-left mr-1"></i>
						Back
					</a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">
					<form enctype="multipart/form-data" action="{{ route('student.store') }}" method="POST">
                        @csrf
						<div class="row">

                            <div class="col-sm-2">
								<div class="form-group">
									<label for="form_no"><span class="bangla">ফর্ম নং</span>/Form No <span class="text-red">*</span></label>
									<input type="text" name="form_no" id="form_no" value="{{ $formNo }}" class="form-control datepicker @error('form_no') is-invalid @enderror" placeholder="ফর্ম নং লিখুন" readonly>

									@error('form_no')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>
                            <div class="col-sm-3">
								<div class="form-group">
									<label for="register_no"><span class="bangla">নিবন্ধন নং/</span>Register No <span class="text-red">*</span></label>
									<input type="text" name="register_no" id="register_no" value="duspmsrid-{{ $student + 1 }}" class="form-control datepicker @error('register_no') is-invalid @enderror" readonly>

								</div>
							</div>

                            <div class="col-sm-3">
								<div class="form-group">
									<label for="join_date"> <span class="bangla">তারিখ</span>/ Date</label>
									<input type="text" name="join_date" id="date" value="{{ old('join_date') }}" class="form-control @error('join_date') is-invalid @enderror" placeholder="তারিখ লিখুন">

									@error('join_date')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="name"><span class="bangla">নাম</span>/Student Name<span class="text-red">*</span></label>
									<input type="text" name="name" id="name" value="{{ old('name') }}" class="form-control @error('name') is-invalid @enderror" placeholder="নাম লিখুন" required>

									@error('name')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="father_name"><span class="bangla">পিতা</span>/Father Name</label>
									<input type="text" name="father_name" id="father_name" value="{{ old('father_name') }}" class="form-control @error('father_name') is-invalid @enderror" placeholder="পিতার নাম লিখুন">

									@error('father_name')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="mother_name"><span class="bangla">মাতা</span>/Mother Name</label>
									<input type="text" name="mother_name" id="mother_name" value="{{ old('mother_name') }}" class="form-control @error('mother_name') is-invalid @enderror" placeholder="মাতার নাম লিখুন">

								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="birth_date"><span class="bangla">জন্ম তারিখ</span>/Date Of Birth</label>
									<input type="text" name="birth_date" id="birth_date" value="{{ old('birth_date') }}" class="form-control @error('birth_date') is-invalid @enderror" placeholder="জন্ম তারিখ লিখুন">

								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="student_type"><span class="bangla">ছাত্রের ধরন</span>/Student Type <span class="text-red">*</span></label>
									<select name="student_type" id="student_type" class="form-control @error('student_type') is-invalid @enderror" required>
										<option value="1"> <span class="bangla">আবাসিক</span></option>
										<option value="2"> <span class="bangla">অনাবাসিক</span></option>
									</select>

									@error('student_type')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="department"><span class="bangla">ক্লাস</span>/Class<span class="text-red">*</span></label>

									<select name="department_id" id="department_id" class="form-control @error('department_id') is-invalid @enderror" required>
										<option value=""><span class="bangla">ক্লাস নির্বাচন করুন</span></option>
                                        @foreach ($departments as $key => $department)
                                            <option value="{{ $department->id }}" > {{ $department->department_name }} </option>
                                        @endforeach
									</select>

									@error('department_id')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							<div class="col-sm-4 hideInput">
								<div class="form-group">
									<label for="admission_fee"><span class="bangla">ভর্তি ফি</span>/Admission Fees </label>
									<input type="text" name="admission_fee" id="admission_fee" value="{{ old('admission_fee') ?? 0 }}" class="form-control @error('admission_fee') is-invalid @enderror" placeholder="ভর্তি ফি লিখুন">

									@error('admission_fee')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							<div class="col-sm-4 ">
								<div class="form-group">
									<label for="monthly_fee"><span class="bangla">মাসিক বেতন</span>/Monthly Fees </label>
									<input type="text" name="monthly_fee" id="monthly_fee" value="{{ old('monthly_fee') ?? 0 }}" class="form-control @error('monthly_fee') is-invalid @enderror" placeholder="মাসিক বেতন লিখুন">

									@error('monthly_fee')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							<div class="col-sm-4 ">
								<div class="form-group">
									<label for="meal_cost"><span class="bangla">মাসিক খাবার</span>/Monthly Meal Cost </label>
									<input type="text" name="meal_cost" id="meal_cost" value="{{ old('meal_cost') ?? 0}}" class="form-control @error('meal_cost') is-invalid @enderror" placeholder="মাসিক খাবার লিখুন">

									@error('meal_cost')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="village"><span class="bangla">গ্রাম</span>/Village </label>
									<input type="text" name="village" id="village" value="{{ old('village') }}" class="form-control @error('village') is-invalid @enderror" placeholder="গ্রাম লিখুন">

									@error('village')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="post_office"><span class="bangla">ডাকঘর</span>/Post Office </label>
									<input type="text" name="post_office" id="post_office" value="{{ old('post_office') }}" class="form-control @error('post_office') is-invalid @enderror" placeholder="ডাকঘর লিখুন">

									@error('post_office')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="police_station"><span class="bangla">থানা</span>/Police Station </label>
									<input type="text" name="police_station" id="police_station" value="{{ old('police_station') }}" class="form-control @error('police_station') is-invalid @enderror" placeholder="থানা লিখুন">

									@error('police_station')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="district"><span class="bangla">জেলা</span>/District</label>
									<input type="text" name="district" id="district" value="{{ old('district') }}" class="form-control @error('district') is-invalid @enderror" placeholder="জেলা লিখুন">

									@error('district')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label for="gurdian_name"><span class="bangla">অভিভাবকের নাম</span>/Gurdian Name</label>
                                    <input type="text" name="gurdian_name" value="{{old('gurdian_name')}}" class="form-control" id="gurdian_name" placeholder="অভিভাবকের নাম লিখুন">
                                </div>
                            </div>

                        <div class="col-sm-4">
                            <div class="form-group">
                                <label for="relation"><span class="bangla">সম্পর্ক</span>/Relation</label>
                                <input type="text" value="{{old('relation')}}"  id="relation" name="relation" class="form-control" placeholder="সম্পর্ক লিখুন">
                            </div>
                        </div>

                        <div class="col-sm-4">
                            <div class="form-group">
                                <label for="gurdian_mobile"><span class="bangla">মোবাইল</span>/Mobile<span class="text-red">*</span></label>
                                <input type="text" value="{{old('gurdian_mobile')}}" id="gurdian_mobile" name="gurdian_mobile" class="form-control" placeholder="মোবাইল নং লিখুন" required>
                            </div>
                        </div>

                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="gurdian_address"><span class="bangla">অভিভাবকের ঠিকানা</span>/Gurdian's Address</label>
                                <textarea name="gurdian_address" class="form-control" rows="3" placeholder="অভিভাবকের ঠিকানা লিখুন">{{ old('gurdian_address') }}</textarea>
                            </div>
                        </div>

                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="image"><span class="bangla">ছাত্রের ছবি</span>/Photo</label>
                                <input data-height="auto" type="file" class="dropify form-control @error('image') is-invalid @enderror" name="image" id="image" placeholder="Image">
                            </div>
                        </div>

                    </div>

						<div class="row mt-30">
							<div class="col-sm-12">
								<button type="submit" class="btn btn-success mr-2">Create</button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
	</section>
</div>
@push('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/js/dropify.min.js"
        integrity="sha512-8QFTrG0oeOiyWo/VM9Y8kgxdlCryqhIxVeRpWSezdRRAvarxVtwLnGroJgnVW9/XBRduxO/z1GblzPrMQoeuew==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>

<script>
    $(document).ready(function() {
        $('.dropify').dropify();
    });

       $(function () {
           $('#date').datepicker({
               dateFormat: 'dd MM yy'
           });
       });

       $(function () {
           $('#birth_date').datepicker({
               dateFormat: 'dd MM yy'
           });
       });
</script>

@endpush
@endsection
