@extends('dashboard.master')
@section('title', 'Bonus List')
@push('css')
<link rel="stylesheet" href="{{ asset('backend/DataTables/datatables.min.css') }}">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/css/iziToast.min.css" integrity="sha512-O03ntXoVqaGUTAeAmvQ2YSzkCvclZEcPQu1eqloPaHfJ5RuNGiS4l+3duaidD801P50J28EHyonCV06CUlTSag==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
@endpush

@section('content')

<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="page-title-wrapper">
                <div class="page-title-heading">
                    <div class="page-title-icon">
                        <i class="nav-icon fas fa-mosque"></i>
                    </div>
                    <span>
                        <b>Bonus List</b>
                    </span>
                </div>

                <div class="page-title-actions">
                    <a title="Back Button" href="{{ URL::previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>

                    <a title="Create" href="#" type="button" class="btn btn-sm btn-primary" data-toggle="modal" data-target="#addClass">
                        <i class="fas fa-plus mr-1"></i>
                        Create
                    </a>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="card">
                <div class="card-body">
                    <table id="data_table" class="table table-bordered table-striped data-table table-hover">
                        <thead>
                            <tr>
                                <th>SN</th>
                                <th>Date</th>
                                <th>Purpose</th>
                                <th>Bonus</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </section>
</div>

{{-- add modal --}}
<div class="modal fade" id="addClass" tabindex="-1" role="dialog" aria-labelledby="demoModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="demoModalLabel">{{ __('Create bonus')}}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">

                <form class="forms-sample add-class" enctype="multipart/form-data" action="#" method="POST">
                    @csrf

                    <label for="name" class="row col-form-label">Name<span class="text-red">*</span></label>
                    <div class="form-group row">
                        <input type="hidden" name="name" id="teacher_id" value="{{ $teacher->id }}" class="form-control" readonly>
                        <input type="text" name="name" id="name" value="{{ $teacher->name }}" class="form-control" readonly>
                    </div>

                    <label for="name" class="row col-form-label">Fund<span class="text-red">*</span></label>
                    <div class="form-group row">
                        <select name="fund_id" id="fund_id" class="form-control"  required>
                            <option value="">Select Fund</option>
                            @foreach ($funds as $fund)
                                <option value="{{ $fund->id }}">{{ $fund->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <label for="name" class="row col-form-label">Bonus Amount<span class="text-red">*</span><span id="showAmount" style="display:none;">(Available: <b id="availableAmount"></b>)</span></label>
                    <div class="form-group row">
                        <input type="number" name="name" id="amount" min="0" class="form-control" placeholder="Enter bonus amount" required>
                    </div>

                    <label for="purpose" class="row col-form-label">Purpose<span class="text-red">*</span></label>
                    <div class="form-group row">
                        <textarea name="purpose" id="purpose" class="form-control" cols="2" rows="2" required> </textarea>
                    </div>

                </form>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger" data-dismiss="modal">{{ __('Close')}}</button>
                <button type="button" id="save" class="btn btn-primary">{{ __('Save')}}</button>
            </div>
        </div>
    </div>
</div>

{{-- edit modal --}}
<div class="modal fade" id="editClass" tabindex="-1" role="dialog" aria-labelledby="demoModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="demoModalLabel">{{ __('Edit Bonus')}}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
                <form id="edit-menu" action="#">
                    @csrf
                    @method('PUT')
                    <input type="hidden" name="" id="editId">
                    <label for="name" class="row col-form-label">Name<span class="text-red">*</span></label>
                    <div class="form-group row">
                        <input type="text" name="name" id="nameEdit" value="{{ $teacher->name }}" class="form-control" readonly>
                    </div>

                    <label for="name" class="row col-form-label">Fund<span class="text-red">*</span></label>
                    <div class="form-group row">
                        <select name="fund_id" id="fund_idEdit" class="form-control"  required>
                            <option value="">Select Fund</option>
                            @foreach ($funds as $fund)
                                <option value="{{ $fund->id }}">{{ $fund->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <label for="name" class="row col-form-label">Bonus Amount<span class="text-red">*</span><span id="showAmountEdit">(Available: <b id="availableAmountEdit"></b>)</span></label>
                    <div class="form-group row">
                        <input type="number" name="name" id="amountEdit" min="0" class="form-control" placeholder="Enter bonus amount" required>
                    </div>

                    <label for="purpose" class="row col-form-label">Purpose<span class="text-red">*</span></label>
                    <div class="form-group row">
                        <textarea name="purpose" id="purposeEdit" class="form-control" cols="2" rows="2" required> </textarea>
                    </div>

                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger" data-dismiss="modal">{{ __('Close')}}</button>
                <button type="button" id="update" class="btn btn-primary">{{ __('Update')}}</button>
            </div>
        </div>
    </div>
</div>
@push('js')
<script src="{{ asset('backend/DataTables/datatables.min.js') }}"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/js/iziToast.min.js" integrity="sha512-Zq9o+E00xhhR/7vJ49mxFNJ0KQw1E1TMWkPTxrWcnpfEFDEXgUiwJHIKit93EW/XxE31HSI5GEOW06G6BF1AtA==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script>
$(document).ready(function() {
    var dTable = $('#data_table').DataTable({
        order: [],
        lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        processing: true,
        responsive: false,
        serverSide: true,
        scroller: {
            loadingIndicator: false
        },
        language: {
            processing: '<i class="ace-icon fa fa-spinner fa-spin orange bigger-500" style="font-size:60px;text-align:center;"></i>'
        },
        pagingType: "full_numbers",
        ajax: {
            url: "{{ route('teacher.bonus', $teacher->id) }}",
            type: "get"
        },
        columns: [
            { data: 'DT_RowIndex', name: 'DT_RowIndex', searchable: false },
            { data: 'date', name: 'date' },
            { data: 'amount', name: 'amount' },
            { data: 'purpose', name: 'purpose' },
            { data: 'action', searchable: false, orderable: false }
        ],
    });
});

$(document).ready(function($){
    $('#save').on('click',function (event) {
        event.preventDefault();
        var url = "{{ route('teacher.bonus.store') }}";
        var teacher_id = $('#teacher_id').val();
        var amount = $('#amount').val();
        var purpose = $('#purpose').val();
        var fund_id = $('#fund_id').val();
        $.ajax({
            url: url,
            type: "POST",
            data: {
                teacher_id : teacher_id,
                amount : amount,
                purpose : purpose,
                fund_id : fund_id,
                _token: '{{ csrf_token() }}',
            },
            success: function(data) {
                if (data.success === true) {
                    location.reload();
                    toastr.success(data.message);
                    $('#add-class').trigger('clear');
                    $('#add-class')[0].reset();
                }else{
                    toastr.error(data.message);
                    $('#add-class').trigger('clear');
                    $('#add-class')[0].reset();
                    $('#addClass').modal('show');
                }
            },

            });
            $.noConflict();
            $('#addClass').modal('hide');
    });

    $('#data_table').on('click', '#edit[href]', function (e) {
        e.preventDefault();
        var url = $(this).attr('href');
        if (!url) {
            console.error('Edit URL not found');
            return;
        }
        $.ajax({
            type: "GET",
            url: url,
            success: function(resp) {
                if (resp) {
                    $('#amountEdit').val(resp.amount);
                    $('#fund_idEdit').val(resp.fund_id);
                    $('#purposeEdit').val(resp.purpose);
                    $('#editId').val(resp.id);
                    $('#editClass').modal('show');
                    fetchAvailableAmountForEdit(resp.fund_id);
                }
            },
            error: function(xhr, status, error) {
                console.error('AJAX error:', error);
            }
        });
    });

    function fetchAvailableAmountForEdit(fund_id) {
        if (fund_id) {
            $.ajax({
                url: "{{ route('fund.amount') }}",
                type: 'POST',
                data: {
                    fund_id: fund_id,
                    _token: '{{ csrf_token() }}'
                },
                success: function(data) {
                    let availableAmount = parseFloat(data);
                    var amount = parseFloat($('#amountEdit').val());
                    if (!isNaN(amount)) {
                        availableAmount += amount;
                    }
                    $('#availableAmountEdit').text(availableAmount);
                    $('#showAmountEdit').show();
                },
                error: function(xhr, status, error) {
                    console.log('Error:', error);
                }
            });
        } else {
            $('#showAmountEdit').hide();
        }
    }

    $('#fund_idEdit').on('change', function() {
        var fund_id = $(this).val();
        fetchAvailableAmountForEdit(fund_id);
    });

    $('#amountEdit').on('input', function() {
        var inputAmount = parseFloat($(this).val());
        var availableAmount = parseFloat($('#availableAmountEdit').text());

        if (inputAmount > availableAmount) {
            toastr.error('The amount cannot exceed the available amount of ' + availableAmount);
            $(this).val(availableAmount);
        }
    });

    $('#update').on('click', function(event) {
        event.preventDefault();
        var id = $('#editId').val();
        var amount = $('#amountEdit').val();
        var purpose = $('#purposeEdit').val();
        var fund_id = $('#fund_idEdit').val();
        var teacher_id = $('#teacher_id').val();
        var url = '{{ route("teacher.bonus.update", ":id") }}'.replace(':id', id);
        $.ajax({
            url: url,
            type: 'POST',
            data: {
                teacher_id: teacher_id,
                amount: amount,
                purpose: purpose,
                fund_id: fund_id,
                _token: '{{ csrf_token() }}',
            },
            success: function(data) {
                if (data.success === true) {
                    toastr.success(data.message);
                    $('#data_table').DataTable().ajax.reload();
                    $('#editClass').modal('hide');
                } else {
                    toastr.error(data.message);
                    $('#editClass').modal('show');
                }
            },
            error: function(xhr, status, error) {
                console.error('Update error:', error);
            }
        });
    });
});


$(document).ready(function($){
    $('#data_table').on('click', '.btn-delete[data-remote]', function (e) {
        e.preventDefault();

        $.ajaxSetup({
            headers: {
                "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
            }
        });

        const url = $(this).data('remote');
        swal({
                title: `Are you sure?`,
                text: "Want to delete this record?",
                buttons: true,
                dangerMode: true,
            }).then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    url: url,
                    type: 'get',
                    dataType: 'json',
                    data: {submit: true, _method: 'delete', _token: "{{ csrf_token() }}"}
                }).always(function (data) {
                    $('#data_table').DataTable().ajax.reload();
                    if (data.success === true) {
                        toastr.success(data.message, { positionClass: 'toast-bottom-full-width', });
                    }else{
                        toastr.error(data.message, { positionClass: 'toast-bottom-full-width', });
                    }
                });
            }
        });
    });
});

$(document).ready(function($){

    let availableAmount = 0;

    $('#fund_id').on('change', function() {
        var fund_id = $(this).val();

        if (fund_id) {
            $.ajax({
                url: "{{ route('fund.amount') }}",
                type: 'POST',
                data: {
                    fund_id: fund_id,
                    _token: '{{ csrf_token() }}'
                },
                success: function(data) {
                    availableAmount = parseFloat(data);
                    $('#availableAmount').text(availableAmount);
                    $('#showAmount').show();
                },
                error: function(xhr, status, error) {
                    console.log('Error:', error);
                }
            });
        } else {
            $('#showAmount').hide();
        }
    });

    $('#amount').on('input', function() {
        var inputAmount = parseFloat($(this).val());

        if (inputAmount > availableAmount) {
            toastr.error('The amount cannot exceed the available amount of ' + availableAmount);
            $(this).val(availableAmount);
        }
    });
});

$(document).ready(function($){

    let availableAmount = 0;

    $('#fund_idEdit').on('change', function() {
        var fund_id = $(this).val();

        if (fund_id) {
            $.ajax({
                url: "{{ route('fund.amount') }}",
                type: 'POST',
                data: {
                    fund_id: fund_id,
                    _token: '{{ csrf_token() }}'
                },
                success: function(data) {
                    availableAmount = parseFloat(data);
                    var amount = parseFloat($('#amountEdit').val());
                    if (!isNaN(amount)) {
                        availableAmount += amount;
                    }

                    $('#availableAmountEdit').text(availableAmount);
                    $('#showAmountEdit').show();
                },
                error: function(xhr, status, error) {
                    console.log('Error:', error);
                }
            });
        } else {
            $('#showAmountEdit').hide();
        }
    });

    $('#amountEdit').on('input', function() {
        var inputAmount = parseFloat($(this).val());

        if (inputAmount > availableAmount) {
            toastr.error('The amount cannot exceed the available amount of ' + availableAmount);
            $(this).val(availableAmount);
        }
    });
});

@if(Session::has('success'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true,
        "timeOut" : 2000
    };

    toastr.success("{{ session('success') }}");
  @endif

 @if(Session::has('error'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    };
    toastr.error("{{ session('error') }}");
 @endif
</script>
@endpush
@endsection
