@extends('dashboard.master')
@section('title', 'Create Teacher Distribute')
@push('css')
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
@endpush
@section('content')
<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Create Teacher Distribute</b>
					</span>
				</div>

				<div class="page-title-actions">
					<a title="Back" href="{{ URL::previous() }}" type="button" class="btn btn-sm btn-dark">
						<i class="fas fa-arrow-left mr-1"></i>
						Back
					</a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">
					<form enctype="multipart/form-data" action="{{ route('teacher.book.distribute.store') }}" method="POST">
						@csrf
						<div class="row">

							<div class="col-sm-4">
								<div class="form-group">
									<label for="teacher_id">Teacher<span class="text-red">*</span></label>
									<select name="teacher_id" id="teacher_id" class="form-control" required>
                                        <option value="">Choose One</option>
                                       @foreach($teachers as $item)
                                        <option value="{{ $item->id }}">{{ $item->name }} || {{ $item->phone }} || {{ $item->reg_no }} </option>
                                       @endforeach
                                    </select>
								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="session_id">Session</label>
									<select name="session_id" id="session_id" class="form-control">
                                        <option value="">Choose One</option>
                                       @foreach($sessions as $item)
                                        <option value="{{ $item->id }}">{{ $item->name }}</option>
                                       @endforeach
                                    </select>
								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="exam_id">Exam</label>
									<select name="exam_id" id="exam_id" class="form-control">
                                        <option value="">Choose One</option>
                                       @foreach($exams as $item)
                                        <option value="{{ $item->id }}">{{ $item->name }}</option>
                                       @endforeach
                                    </select>
								</div>
							</div>

							<div class="col-sm-12">
								<div class="form-group">
									<label for="note">Note</label>
									<textarea name="note" id="note" class="form-control" rows="2"></textarea>
								</div>
							</div>

						</div>

                        <hr>

                        <div class="row col-md-12">
                            <hr>
                            <table id="data_table" class="table table-bordered table-striped data-table table-hover">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Kitab</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($subjects as $item)
                                        <tr>
                                            <td width="5%">{{ $loop->iteration }}</td>
                                            <td>
                                                <div class="d-flex radio radio-info radio-inline">
                                                    <input style="height: 20px !important; width:20px !important;" type="checkbox" name="subject_id[]" class="form-control" value="{{ $item->id }}" id="subject_id" >
                                                    <p style="margin-top:-4px; margin-left:6px">{{ $item->name }}</p>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

						<div class="row mt-20">
							<div class="col-sm-12">
								<button title="Create" type="submit" class="btn btn-primary mr-2">Create</button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
	</section>
</div>

@push('js')
<script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<script>
    @if(Session::has('success'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true,
        "timeOut" : 1000
    };

    toastr.success("{{ session('success') }}");
  @endif

 @if(Session::has('error'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    };
    toastr.error("{{ session('error') }}");
 @endif
</script>
@endpush
@endsection
