@extends('dashboard.master')
@section('title', 'Teacher Due Advanced Salary ')
@push('css')
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.1/themes/base/jquery-ui.css">
<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
<style>
    .ui-datepicker-calendar {
        display: none;
    }
    #student_id {
        text-align: center;
    }
    .select2-container .select2-selection--single {
        height: 38px;
    }
</style>
@endpush

@section('content')
@php
    $start = \Carbon\Carbon::create(2025, 1, 1);
    $end = \Carbon\Carbon::now()->addYears(50)->startOfMonth();
@endphp
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="page-title-wrapper">
                <div class="page-title-heading">
                    <div class="page-title-icon">
                        <i class="nav-icon fas fa-mosque"></i>
                    </div>
                    <span>
                        <b>Teacher Due Advanced Salary </b>
                    </span>
                </div>

                <div class="page-title-actions">
                    <a title="Back Button" href="{{ URL::previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="card">
                <div class="card-body">
                    <form enctype="multipart/form-data" action="{{ route('teacher.monthly.salary.store') }}" method="POST">
                        @csrf
                        <div class="row">

                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label for="teacher_id">Teacher</label>
                                    <select name="teacher_id" id="teacher_id" class=" form-control @error('teacher_id') is-invalid @enderror">
                                        <option value="">Select One</option>
                                        @foreach ($teachers as $key => $teacher)
                                            <option value="{{ $teacher->id }}" > {{ $teacher->name }}</option>
                                        @endforeach
                                    </select>
                                    @error('teacher_id')
                                    <span class="text-danger" role="alert">
                                        <p>{{ $message }}</p>
                                    </span>
                                    @enderror
                                </div>
                            </div>


                            <div class="col-sm-5">
                                <div class="form-group">
                                    <label for="months">Months<span class="text-red">*</span></label>
                                    <select name="months[]" id="months" class="form-control select2" multiple="multiple" required>
                                        @for ($date = $start->copy(); $date <= $end; $date->addMonth())
                                            <option value="{{ $date->format('F-Y') }}">{{ $date->format('F Y') }}</option>
                                        @endfor
                                    </select>
                                </div>
                            </div>

                            <div class="col-sm-3">
                                <div class="form-group">
                                    <label for="amount">Salary</label>
                                    <input type="number" name="total_amount" id="total_amount" value="{{ old('amount') }}" class="form-control @error('amount') is-invalid @enderror" placeholder="amount" readonly>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Select Fund<span class="text-red">*</span></label>
                                    <select name="fund_id" id="fund_id" class="form-control">
                                        <option value="">Select One</option>
                                        @foreach($funds as $fund)
                                        <option value="{{ $fund->id }}">{{ $fund->name ?? '' }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label for="">Paid Amount<span class="text-red">*</span> <span id="showAmount" style="display:none;">(Available: <b id="availableAmount"></b>)</span></label>
                                    <input type="number" name="amount" id="amount" value="{{ old('amount') }}" class="form-control @error('amount') is-invalid @enderror" placeholder="amount" required>
                                    @error('amount')
                                    <span class="text-danger" role="alert">
                                        <p>{{ $message }}</p>
                                    </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label for="amount">Due Amount</label>
                                    <input type="number" name="due_amount" id="due_amount" value="{{ old('amount') }}" class="form-control @error('amount') is-invalid @enderror" placeholder="amount" readonly>
                                </div>
                            </div>

                        </div>

                        <div class="row mt-30">
                            <div class="col-sm-12">
                                <button type="submit" class="btn btn-success mr-2">Save</button>
                            </div>
                        </div>
                    </form>

                    <div class="col-md-12 mt-4 table-responsive">
                        <table id="fee_table" class="table table-bordered table-striped table-hover">
                            <thead>
                                <tr>
                                    <th>SN</th>
                                    <th>Month</th>
                                    <th>Salary</th>
                                    <th>Total Paid</th>
                                    <th>Total Due</th>
                                </tr>
                            </thead>
                            <tbody id="fee_table_body">
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th colspan="2">Total</th>
                                    <th id="total_salary">0</th>
                                    <th id="total_paid">0</th>
                                    <th id="total_due">0</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </section>
</div>

@push('js')
<script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<script>
$('.mt-4').hide();
$('#teacher_id').select2();
$(document).ready(function() {
    $('#teacher_id, #months').select2();

    $('#teacher_id').on('change', function() {
        loadFeeData();
    });

    $('#months').on('change', function() {
        $('.mt-4').show();
        loadFeeData();
    });

    function loadFeeData() {
    var teacher_id = $('#teacher_id').val();
    var months = $('#months').val();

    if(teacher_id && months && months.length > 0) {
        $.ajax({
            url: "{{ route('teacher.monthly.salary') }}",
            type: 'POST',
            data: {
                months: months,
                teacher_id: teacher_id,
                _token: '{{ csrf_token() }}'
            },
            success: function(data) {
                $('#fee_table_body').empty();
                let totalSalary = 0;
                let totalPaid = 0;
                let totalDue = 0;

                $.each(data.monthlyData, function(index, item) {
                    $('#fee_table_body').append(`
                        <tr>
                            <td>${index + 1}</td>
                            <td>${item.month}</td>
                            <td>${item.salary}</td>
                            <td>${item.totalPaid}</td>
                            <td>${item.due}</td>
                        </tr>
                    `);

                    totalSalary += parseFloat(item.salary);
                    totalPaid += parseFloat(item.totalPaid);
                    totalDue += parseFloat(item.due);
                });

                $('#total_salary').text(totalSalary);
                $('#total_paid').text(totalPaid);
                $('#total_due').text(totalDue);

                // Populate total input fields
                $('#total_amount').val(totalSalary);
                $('#due_amount').val(totalDue);

            }
        });
    }
}

    $(document).on('keyup', '#amount, #discount', function() {
        var amount = parseFloat($('#amount').val()) || 0;
        var discount = parseFloat($('#discount').val()) || 0;
        var due = parseFloat($('#due_amount').val()) || 0;

        if((amount + discount) > due) {
            alert('Amount cannot be greater than due amount');
            $(this).val('');
            return;
        }
    });
});

$(document).ready(function() {
    let availableAmount = 0;

    $('#fund_id').on('change', function() {
        var fund_id = $(this).val();

        if (fund_id) {
            $.ajax({
                url: "{{ route('fund.amount') }}",
                type: 'POST',
                data: {
                    fund_id: fund_id,
                    _token: '{{ csrf_token() }}'
                },
                success: function(data) {
                    availableAmount = parseFloat(data);
                    $('#availableAmount').text(availableAmount);
                    $('#showAmount').show();
                },
                error: function(xhr, status, error) {
                    console.log('Error:', error);
                }
            });
        } else {
            $('#showAmount').hide();
        }
    });

    $('#amount').on('input', function() {
        var inputAmount = parseFloat($(this).val());

        if (inputAmount > availableAmount) {
            toastr.error('The amount cannot exceed the available amount of ' + availableAmount);
            $(this).val(availableAmount);
        }
    });
});

</script>
@endpush
@endsection
