@extends('dashboard.master')
@section('title', 'Edit Recruit ')
@push('css')

<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/css/dropify.min.css" integrity="sha512-EZSUkJWTjzDlspOoPSpUFR0o0Xy7jdzW//6qhUkoZ9c4StFkVsp9fbbd0O06p9ELS3H486m4wmrCELjza4JEog==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.1/themes/base/jquery-ui.css">
<style>
    .dropify-wrapper .dropify-message p {
        font-size: initial;
    }
</style>

 @endpush

@section('content')

<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Edit Recruit</b>
					</span>
				</div>

				<div class="page-title-actions">
					<a title="Back Button" href="{{ route('teacher.index') }}" type="button" class="btn btn-sm btn-dark">
						<i class="fas fa-arrow-left mr-1"></i>
						Back
					</a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">
					<form enctype="multipart/form-data" action="{{ route('teacher.update', $data->id) }}" method="POST">
                        @csrf
                        @method('PUT')
						<div class="row">
							<div class="col-sm-4">
								<div class="form-group">
									<label for="reg_no">Reg ID<span class="text-red">*</span></label>
									<input type="text" name="reg_no" id="reg_no" value="{{ $data->reg_no }}" class="form-control" placeholder="Teacher ID" readonly>
                                    <input type="hidden" name="teacher_id" id="teacher_id" value="{{ $data->id }}" class="form-control">
								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="name"> Name<span class="text-red">*</span></label>
									<input type="text" name="name" id="name" value="{{ $data->name }}" class="form-control @error('name') is-invalid @enderror" placeholder="Enter teacher name" required>

									@error('name')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="join_date"> Join Date <span class="text-red">*</span></label>
									<input type="ext" name="join_date" id="date" value="{{ $data->join_date }}" class="form-control datepicker @error('join_date') is-invalid @enderror" placeholder="Enter join date" required>

									@error('join_date')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="gender">Gender <span class="text-red">*</span></label>
									<select name="gender" id="gender" class="form-control @error('gender') is-invalid @enderror" required>
										<option value="">Select Gender</option>
										<option value="1" {{ $data->gender == 1 ? 'selected' : '' }}>Male</option>
                                        <option value="2" {{ $data->gender == 2 ? 'selected' : '' }}>Female</option>
									</select>

									@error('gender')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>


							<div class="col-sm-4">
								<div class="form-group">
									<label for="designation">Designation </label>
									<input type="text" name="designation" id="designation" value="{{ $data->designation }}" class="form-control @error('designation') is-invalid @enderror" placeholder="Enter designation" >

								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="salary">Salary <span class="text-red">*</span></label>
									<input type="number" name="salary" id="salary" value="{{ $data->salary }}" class="form-control @error('salary') is-invalid @enderror" placeholder="Enter salary" required>

									@error('salary')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="phone">Phone <span class="text-red">*</span></label>
									<input type="text" name="phone" id="phone" value="{{ $data->phone }}" class="form-control @error('phone') is-invalid @enderror" placeholder=" Enter phone number" required>

									@error('phone')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="email">Email</label>
									<input type="email" name="email" id="email" value="{{ $data->email }}" class="form-control @error('email') is-invalid @enderror" placeholder="Enter email address"  autocomplete="off" >

								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="blood_group">Blood Group</label>
									<input type="text" name="blood_group" id="blood_group" value="{{ $data->blood_group }}" class="form-control @error('blood_group') is-invalid @enderror" placeholder="Enter blood group"  autocomplete="off" >

								</div>
							</div>


							<div class="col-sm-4">
								<div class="form-group">
									<label for="address">Address<span class="text-red">*</span></label>
									<textarea rows="3" name="address" id="address" class="form-control @error('address') is-invalid @enderror" placeholder="Write address" required>{{ $data->address }}</textarea>

									@error('address')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="description">Description </label>
									<textarea rows="3" name="description" id="description" class="form-control" placeholder="Describe here...">{{ $data->description }}</textarea>
								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="image">Profile Picture</label>
                                    <input type="file" name="image" id="image" data-height="auto" @if ($data) data-default-file="{{ asset('backend/img/teacher/' . $data->image) }}" @endif class="dropify form-control @error('image') is-invalid @enderror">

                                </div>
							</div>
						</div>

                        @php
                            $cardName = json_decode($data->card_name);
                            $cardNumber = json_decode($data->card_no);
                            $cardPhoto = json_decode($data->card_photo);

                            $examName = json_decode($data->exam_name);
                            $passingYear = json_decode($data->passing_year);
                            $certificate = json_decode($data->certificate);
                        @endphp

                            @foreach($examName as $key => $value )
                            <div class="row edu_row_del">
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="card_name">Exam Title</label>
                                        <input type="text" id="exam_name" name="exam_name[]" value="{{ $value ?? '' }}" class="form-control @error('exam_name') is-invalid @enderror" placeholder="Enter exam title" >
                                    </div>
                                </div>

                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="passing_year">Passing Year</label>
                                        <input type="text" id="passing_year" name="passing_year[]" value="{{ $passingYear[$key] ?? '' }}" class="form-control @error('passing_year') is-invalid @enderror" placeholder="Enter passing year">
                                    </div>
                                </div>

                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="certificate">Upload Certificate</label>
                                            <div class="d-flex">
                                                <input type="hidden" name="old_certificate[]" id="" value= "{{ $certificate[$key] ?? '' }}"/>
                                                <input type="file" name="certificate[]" id="certificate" class="form-control @error('certificate') is-invalid @enderror">

                                                @if ($key == 0)
                                                    <button style="margin-left: 5px; height:37px; font-size:14px; text-align:center" type="button" name="addEdu" id="addEdu" class="btn btn-success">+</button>
                                                @else
                                                    <button style="margin-left: 5px; height:35px; font-size:14px; text-align:center" type="button" name="eduremove" id="eduremove" class="btn btn-danger eduremove">-</button>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach

                            <div id="AddEduField">

                            </div>

                            @foreach($cardName as $key => $value )
                            <div class="row row_del">
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="card_name">Select Card Name</label>
                                        <select name="card_name[]" id="card_name" class="form-control card_name @error('card_name') is-invalid @enderror" >
                                            <option value="">Select</option>
                                            <option value="1" @if($cardName[$key] == 1 ) selected @endif>NID</option>
                                            <option value="2" @if($cardName[$key]  == 2 ) selected @endif>Passport</option>
                                            <option value="3" @if($cardName[$key]  == 3 ) selected @endif>Birth Certificate</option>
                                            <option value="4" @if($cardName[$key]  == 4 ) selected @endif>Driving License</option>
                                        </select>

                                    </div>
                                </div>

                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="card_no">Identity Card No</label>

                                        <input type="number" id="card_no" name="card_no[]" value="{{ $cardNumber[$key] ?? '' }}" class="form-control @error('card_no') is-invalid @enderror" placeholder="Enter card number" >

                                         @error('card_no')
                                        <span class="text-danger" role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="card_photo">Upload ID Card</label>
                                        <div class="d-flex">
                                            <input type="file" name="card_photo[]" id="card_photo" value="" class="form-control @error('card_photo') is-invalid @enderror">
                                            <input type="hidden" name="old_card_photo[]" id="" value= "{{ $cardPhoto[$key] ?? '' }}"/>
                                            @error('card_photo')
                                            <span class="text-danger" role="alert">
                                                <p>{{ $message }}</p>
                                            </span>
                                            @enderror
                                            @if($key == 0)
                                                <button style="margin-left: 5px; height:35px; font-size:14px; text-align:center" type="button" name="add" id="add" class="btn btn-success">+</button>
                                            @else
                                                <button style="margin-left: 5px; height:35px; font-size:14px; text-align:center" type="button" name="row_remove" id="row_remove" class="btn btn-danger row_remove">-</button>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endforeach

						<div id="AddField">

                        </div>

						<div class="row mt-30">
							<div class="col-sm-12">
								<button type="submit" class="btn btn-success mr-2">Update</button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
	</section>
</div>
@push('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/js/dropify.min.js"
        integrity="sha512-8QFTrG0oeOiyWo/VM9Y8kgxdlCryqhIxVeRpWSezdRRAvarxVtwLnGroJgnVW9/XBRduxO/z1GblzPrMQoeuew==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.inputmask/5.0.8/jquery.inputmask.min.js"></script>
<script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.inputmask/5.0.8/jquery.inputmask.min.js"></script>
<script>
    $(document).ready(function() {
            $('.dropify').dropify();
        });
$(function () {
    $('#date').datepicker({
        dateFormat: 'yy-mm-dd'
    });

    $('#date').inputmask('9999-99-99', {
        placeholder: 'yyyy-mm-dd',
        clearIncomplete: true
    });
});
        //field append
        var i = 1;
        $("#add").click(function () {

            if( i < 4 ){
            ++i;
            $("#AddField").append(`<div class="row" id="removed">
                <div class="col-sm-4">
                    <div class="form-group">
                        <label for="card_name">Select Card Name</label>
                        <select name="card_name[]" id="card_name" class="form-control card_name @error('card_name') is-invalid @enderror">
                            <option value="">Select Card</option>
                            <option value="1">NID</option>
                            <option value="2">Passport</option>
                            <option value="3">Birth Certificate</option>
                            <option value="4">Driving License</option>
                        </select>

                    </div>
                </div>

                <div class="col-sm-4">
                    <div class="form-group">
                        <label for="card_no">Identity Card No</label>
                        <input type="number" id="card_no" name="card_no[]"  class="form-control @error('card_no') is-invalid @enderror" placeholder="Enter card no">

                    </div>
                </div>

                <div class="col-sm-4">
                    <div class="form-group">
                        <label for="card_photo">Upload ID Card</label>
                        <div class="d-flex">
                            <input type="file" name="card_photo[]" id="card_photo" class="form-control @error('card_photo') is-invalid @enderror">
                            <button style="margin-left: 5px; height:35px; font-size:14px; text-align:center" type="button" name="del" id="del" class="btn btn-danger btn_remove">-</button>


                        </div>
                    </div>
                </div>
            </div>`);
        }else{
            alert("You can not add new option");
        }
    });

        $(document).on('click', '.btn_remove', function() {
            $(this).parents('#removed').remove();
            i--;
        });

        $(document).on('click', '.row_remove', function(e) {
            e.preventDefault();
                swal({
                    title: `Are you sure?`,
                    text: `Want to remove this?`,
                    buttons: true,
                    dangerMode: true,
                }).then((data) => {
                    if (data == true) {
                    $(this).parents('.row_del').remove();
                }
                else {
                    return false;
                }
            });
         })

        // card type duplicate validation check
        $(document).on('click', 'select.card_name', function () {
        $('select[name*="card_name[]"] option').attr('disabled',false);
        $('select[name*="card_name[]"]').each(function(){
            var $this = $(this);
            $('select[name*="card_name[]"]').not($this).find('option').each(function(){
                if($(this).attr('value') == $this.val())
                $(this).attr('disabled',true);
            });
        });
        });

    </script>
    <script>
          var j = 1;
        $("#addEdu").click(function () {

            if( j < 4 ){
            ++j;
            $("#AddEduField").append(`<div class="row" id="eduremoved">
                <div class="col-sm-4">
                <div class="form-group">
                    <label for="card_name">Exam Title</label>
                    <input type="text" id="exam_name" name="exam_name[]" value="{{ old('exam_name') }}" class="form-control @error('exam_name') is-invalid @enderror" placeholder="Enter exam title" >

                    @error('exam_name')
                    <span class="text-danger" role="alert">
                        <p>{{ $message }}</p>
                    </span>
                    @enderror
                </div>
            </div>

            <div class="col-sm-4">
                <div class="form-group">
                    <label for="passing_year">Passing Year</label>
                    <input type="text" id="passing_year" name="passing_year[]" value="{{ old('passing_year') }}" class="form-control @error('passing_year') is-invalid @enderror" placeholder="Enter passing year" >

                        @error('passing_year')
                    <span class="text-danger" role="alert">
                        <p>{{ $message }}</p>
                    </span>
                    @enderror
                </div>
            </div>

            <div class="col-sm-4">
                <div class="form-group">
                    <label for="certificate">Upload Certificate</label>
                    <div class="d-flex">
                        <input type="file" name="certificate[]" id="certificate" class="form-control @error('certificate') is-invalid @enderror" >
                        <button style="margin-left: 5px; height:35px; font-size:14px; text-align:center" type="button" name="del" id="del" class="btn btn-danger edu_remove">-</button>

                        @error('certificate')
                        <span class="text-danger" role="alert">
                            <p>{{ $message }}</p>
                        </span>
                        @enderror
                    </div>
                </div>
            </div>
            </div>`);
        }else{
            alert("You can not add new option");
        }
    });

        $(document).on('click', '.edu_remove', function() {
            $(this).parents('#eduremoved').remove();
            j--;
        });

        $(document).on('click', '.eduremove', function(e) {
            e.preventDefault();
                swal({
                    title: `Are you sure?`,
                    text: `Want to remove this?`,
                    buttons: true,
                    dangerMode: true,
                }).then((data) => {
                    if (data == true) {
                    $(this).parents('.edu_row_del').remove();
                }
                else {
                    return false;
                }
            });
         })

    </script>
    @endpush
@endsection



