@extends('dashboard.master')
@section('title', 'Create Teacher Leave')
@push('css')
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.1/themes/base/jquery-ui.css">
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
@endpush

@section('content')

<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Create Teacher Leave</b>
					</span>
				</div>

				<div class="page-title-actions">
					<a title="Back" href="{{ URL::previous() }}" type="button" class="btn btn-sm btn-dark">
						<i class="fas fa-arrow-left mr-1"></i>
						Back
					</a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">
					<form enctype="multipart/form-data" action="{{ route('teacher.leave.store') }}" method="POST">
						@csrf
						<div class="row">

							<div class="col-sm-4">
								<div class="form-group">
									<label for="teacher_id">Teacher<span class="text-red">*</span></label>
									<select name="teacher_id" id="teacher_id" class="form-control" required>
                                        <option value="">Choose One</option>
                                       @foreach($teachers as $item)
                                        <option value="{{ $item->id }}">{{ $item->name }} || {{ $item->phone }} || {{ $item->reg_no }} </option>
                                       @endforeach
                                    </select>
								</div>
							</div>

							<div class="col-sm-3">
								<div class="form-group">
									<label for="from_date">From Date<span class="text-red">*</span></label>
									<input type="text" name="from_date" id="from_date" value="{{ old('from_date') }}" class="form-control @error('amount') is-invalid @enderror" placeholder="from date" required>

									@error('from_date')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							<div class="col-sm-3">
								<div class="form-group">
									<label for="to_date">To Date<span class="text-red">*</span></label>
									<input type="text" name="to_date" id="to_date" value="{{ old('to_date') }}" class="form-control @error('amount') is-invalid @enderror" placeholder="to date" required>

									@error('to_date')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							<div class="col-sm-2">
								<div class="form-group">
									<label for="days">Total Days</label>
									<input type="text" name="days" id="days" value="{{ old('days') }}" class="form-control " readonly>
								</div>
							</div>


                            <div class="col-sm-12">
								<div class="form-group">
									<label for="days">Note</label>
									<textarea rows="2" name="note" id="note" class="form-control" placeholder="note">{!! old('note') !!}</textarea>
								</div>
							</div>

						</div>

						<div class="row mt-20">
							<div class="col-sm-12">
								<button title="Create" type="submit" class="btn btn-primary mr-2">Create</button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
	</section>
</div>

@push('js')
<script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<script>

$(function () {
    $('#from_date').datepicker({
        dateFormat: 'dd-MM-yy'
    });
    $('#to_date').datepicker({
        dateFormat: 'dd-MM-yy'
    });

    $('#from_date, #to_date').on('change', function () {
        var fromDate = $('#from_date').val();
        var toDate = $('#to_date').val();

        if (fromDate && toDate) {
            var from = new Date(fromDate.split("-").reverse().join("-"));
            var to = new Date(toDate.split("-").reverse().join("-"));

            from.setHours(0, 0, 0, 0);
            to.setHours(0, 0, 0, 0);

            if (from && to && to >= from) {
                var timeDiff = to - from;
                var days = timeDiff / (1000 * 3600 * 24);
                $('#days').val(days + 1);
            } else {
                $('#days').val('');
                alert("To Date should be greater than or equal to From Date.");
            }
        }
    });
});
@if(Session::has('success'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true,
        "timeOut" : 1000
    };

    toastr.success("{{ session('success') }}");
  @endif

 @if(Session::has('error'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    };
    toastr.error("{{ session('error') }}");
 @endif
</script>
@endpush
@endsection


