@extends('dashboard.master')
@section('title', 'Responsibility Details')
@section('content')

<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Responsibility Details</b>
					</span>
				</div>

				<div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
					<a title="Create" href="{{ route('teacher.responsibility.create') }}" type="button" class="btn btn-sm btn-primary">
                        <i class="fas fa-plus mr-1"></i>
                        Create
                    </a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">
                    <table id="data_table" class="table table-bordered table-striped " style="width:40%">
                        <tr  id="previous_tr" class="btn-light">
                            <td colspan="1">  Teacher: <b>{{ $data->teacher->name ?? '' }} </b></td>
                        </tr>
                        <tr  id="previous_tr" class="btn-light">
                            <td colspan="1">  Assigned By : <b>{{ $data->createdBy->name ?? '' }} </b></td>
                        </tr>
                    </table> <hr>
					<table id="data_table" class="table table-bordered table-striped data-table table-hover">
                        <thead>
                            <tr>
                                <th>SN</th>
                                <th>Responsibility</th>
                            </tr>
                        </thead>
                        <tbody>

                        @foreach ($responsibilities as $item)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $item->responsibilities->name }}</td>
                            </tr>
                        @endforeach

                        </tbody>
                    </table>
				</div>
			</div>
		</div>
	</section>
</div>

@endsection
