@extends('dashboard.master')
@section('title', 'Create Salary ')
@push('css')
    <link rel="stylesheet" href="https://code.jquery.com/ui/1.13.1/themes/base/jquery-ui.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
    <style>
        .ui-datepicker-calendar {
            display: none;
        }

        #student_id {
            text-align: center;
        }

        .select2-container .select2-selection--single {
            height: 38px;
        }
    </style>
@endpush

@section('content')

    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="page-title-wrapper">
                    <div class="page-title-heading">
                        <div class="page-title-icon">
                            <i class="nav-icon fas fa-mosque"></i>
                        </div>
                        <span>
                            <b>Create Salary </b>
                        </span>
                    </div>

                    <div class="page-title-actions">
                        <a title="Back Button" href="{{ URL::previous() }}" type="button" class="btn btn-sm btn-dark">
                            <i class="fas fa-arrow-left mr-1"></i>
                            Back
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                <div class="card">
                    <div class="card-body">
                        <form enctype="multipart/form-data" action="{{ route('teacher.salary.store') }}" method="POST">
                            @csrf
                            <div class="row">

                                <div class="col-sm-12" id="payment_info" style="display: none;">
                                    <label id="total_paid"></label>
                                </div>

                               <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="month">Month<span class="text-red">*</span></label>
                                        <select name="month" id="month" class="form-control select2 @error('month') is-invalid @enderror" required>
    <option value="">Choose month</option>
   
</select>
                                        @error('month')
                                            <span class="text-danger" role="alert">
                                                <p>{{ $message }}</p>
                                            </span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="teacher_id">Teacher</label>
                                        <select name="teacher_id" id="teacher_id"
                                            class=" form-control @error('teacher_id') is-invalid @enderror">
                                            <option value="">Select One</option>
                                            @foreach ($teachers as $key => $teacher)
                                                <option value="{{ $teacher->id }}"> {{ $teacher->name }}</option>
                                            @endforeach
                                        </select>
                                        @error('teacher_id')
                                            <span class="text-danger" role="alert">
                                                <p>{{ $message }}</p>
                                            </span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="amount">Salary</label>
                                        <input type="number" name="total_amount" id="total_amount"
                                            value="{{ old('amount') }}"
                                            class="form-control @error('amount') is-invalid @enderror" placeholder="amount"
                                            readonly>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="">Select Fund<span class="text-red">*</span></label>
                                        <select name="fund_id" id="fund_id" class="form-control">
                                            <option value="">Select One</option>
                                            @foreach ($funds as $fund)
                                                <option value="{{ $fund->id }}">{{ $fund->name ?? '' }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="">Paid Amount<span class="text-red">*</span> <span
                                                id="showAmount" style="display:none;">(Available: <b
                                                    id="availableAmount"></b>)</span></label>
                                        <input type="number" name="amount" id="amount" value="{{ old('amount') }}"
                                            class="form-control @error('amount') is-invalid @enderror" placeholder="amount"
                                            required>
                                        @error('amount')
                                            <span class="text-danger" role="alert">
                                                <p>{{ $message }}</p>
                                            </span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="amount">Due Amount</label>
                                        <input type="number" name="due_amount" id="due_amount" value="{{ old('amount') }}"
                                            class="form-control @error('amount') is-invalid @enderror" placeholder="amount"
                                            readonly>
                                    </div>
                                </div>

                            </div>

                            <div class="row" id="newForm"></div>

                            <div class="row mt-30">
                                <div class="col-sm-12">
                                    <button type="submit" class="btn btn-success mr-2">Save</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </section>
    </div>

    @push('js')
        <script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
        <script>
            $('#teacher_id').select2();
             $('#month').select2({
                    placeholder: 'Search and select month',
                    ajax: {
                        url: '{{ route('months.search') }}',
                        dataType: 'json',
                        delay: 250,
                        data: function(params) {
                            return {
                                q: params.term // user input
                            };
                        },
                        processResults: function(data) {
                            return {
                                results: data
                            };
                        },
                        cache: true
                    },
                    width: '100%'
                });
            $(function() {
                $('#month').datepicker({
                    changeMonth: true,
                    changeYear: true,
                    showButtonPanel: true,
                    yearRange: "-30:+100",
                    dateFormat: 'MM-yy',
                    onClose: function(dateText, inst) {
                        $(this).datepicker('setDate', new Date(inst.selectedYear, inst.selectedMonth, 1));
                        $(this).trigger('change');
                    }
                });
            });
            $(document).ready(function() {
                $('#teacher_id').on('change', function() {
                    calculateSalary();
                });

                $('#month').on('change', function() {
                    // console.log('change', $(this).val()); // ✅ সঠিক

                    calculateSalary();
                });

                function calculateSalary() {
                    var teacher_id = $("#teacher_id").val();
                    var month = $('#month').val();
                    console.log("month", month);
                    $.ajax({
                        url: "{{ route('teacher.salary.find') }}",
                        type: 'POST',
                        data: {
                            month: month,
                            teacher_id: teacher_id,
                            _token: '{{ csrf_token() }}'
                        },
                        success: function(data) {
                            $('#total_amount').val(data.salary);
                            $('#due_amount').val(data.salary - data.total_paid);
                            $('#payment_info').show();
                            $('#total_paid').text('Total Paid: ' + data.total_paid);
                        }
                    });
                }
            });



            $(document).on('keyup', '#amount', function() {
                var receive = parseFloat($(this).val()) || 0;
                var totalAmount = parseFloat($('#total_amount').val()) || 0;
                var totalPaid = parseFloat($('#total_paid').text().replace('Total Paid: ', '')) || 0;
                var dueAmount = totalAmount - totalPaid;

                if (receive > dueAmount) {
                    receive = dueAmount;
                    $('#amount').val(receive);
                }

                var due = totalAmount - totalPaid - receive;
                $('#due_amount').val(due);
            });

            $(document).ready(function() {
                let availableAmount = 0;

                $('#fund_id').on('change', function() {
                    var fund_id = $(this).val();

                    if (fund_id) {
                        $.ajax({
                            url: "{{ route('fund.amount') }}",
                            type: 'POST',
                            data: {
                                fund_id: fund_id,
                                _token: '{{ csrf_token() }}'
                            },
                            success: function(data) {
                                availableAmount = parseFloat(data);
                                $('#availableAmount').text(availableAmount);
                                $('#showAmount').show();
                            },
                            error: function(xhr, status, error) {
                                console.log('Error:', error);
                            }
                        });
                    } else {
                        $('#showAmount').hide();
                    }
                });

                $('#amount').on('input', function() {
                    var inputAmount = parseFloat($(this).val());

                    if (inputAmount > availableAmount) {
                        toastr.error('The amount cannot exceed the available amount of ' + availableAmount);
                        $(this).val(availableAmount);
                    }
                });
            });
        </script>
    @endpush
@endsection
