@extends('dashboard.master')
@section('title', 'Edit Teacher Salary ')
@push('css')
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.1/themes/base/jquery-ui.css">
<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
<style>
    .ui-datepicker-calendar {
        display: none;
    }
    #student_id {
        text-align: center;
    }
    .select2-container .select2-selection--single {
        height: 38px;
    }
</style>
@endpush

@section('content')

<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="page-title-wrapper">
                <div class="page-title-heading">
                    <div class="page-title-icon">
                        <i class="nav-icon fas fa-mosque"></i>
                    </div>
                    <span>
                        <b>Edit Teacher Salary </b>
                    </span>
                </div>

                <div class="page-title-actions">
                    <a title="Back Button" href="{{ URL::previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="card">
                <div class="card-body">
                    <form enctype="multipart/form-data" action="{{ route('teacher.salary.update', $data->id) }}" method="POST">
                        @csrf
                        @method('put')
                        <div class="row">

                            <div class="col-sm-12" id="payment_info">
                                <label id="total_paid"></label>
                            </div>

                            <div class="col-sm-3">
                                <div class="form-group">
                                    <label for="month">Month<span class="text-red">*</span></label>
                                    <input type="text" name="month" id="month" value="{{ \Carbon\Carbon::parse($data->month)->format('F-Y') }}" class="form-control datepicker @error('month') is-invalid @enderror" placeholder="choose month" required>
                                </div>
                            </div>

                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="teacher_id">Teacher</label>
                                    <select name="teacher_id" id="teacher_id" class=" form-control @error('teacher_id') is-invalid @enderror">
                                        <option value="">Select One</option>
                                        @foreach ($teachers as $key => $teacher)
                                            <option value="{{ $teacher->id }}" @if($data->teacher_id == $teacher->id) selected @endif> {{ $teacher->name }}</option>
                                        @endforeach
                                    </select>

                                </div>
                            </div>

                            <div class="col-sm-3">
                                <div class="form-group">
                                    <label for="amount">Salary</label>
                                    <input type="number" name="total_amount" id="total_amount" value="{{ $data->teacher->salary }}" class="form-control @error('amount') is-invalid @enderror" placeholder="amount" readonly>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Select Fund<span class="text-red">*</span></label>
                                    <select name="fund_id" id="fund_id" class="form-control">
                                        <option value="">Select One</option>
                                        @foreach($funds as $fund)
                                        <option value="{{ $fund->id }}" @if($data->fund_id == $fund->id) selected @endif>{{ $fund->name ?? '' }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label for="">Paid Amount<span class="text-red">*</span> (Available: <b id="availableAmount"></b>)</label>
                                    <input type="number" name="amount" id="amount" value="{{ $data->amount }}" class="form-control @error('amount') is-invalid @enderror" placeholder="amount" required>
                                    @error('amount')
                                    <span class="text-danger" role="alert">
                                        <p>{{ $message }}</p>
                                    </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label for="amount">Due Amount</label>
                                    <input type="number" name="due_amount" id="due_amount" value="{{ old('amount') }}" class="form-control @error('amount') is-invalid @enderror" placeholder="amount" readonly>
                                </div>
                            </div>

                        </div>

                        <div class="row" id="newForm"></div>

                        <div class="row mt-30">
                            <div class="col-sm-12">
                                <button type="submit" class="btn btn-success mr-2">Update</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>
</div>

@push('js')
<script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<script>
$('#teacher_id').select2();
$(function() {
    $('#month').datepicker({
        changeMonth: true,
        changeYear: true,
        showButtonPanel: true,
        yearRange: "-10:+100",
        dateFormat: 'MM-yy',
        onClose: function(dateText, inst) {
            $(this).datepicker('setDate', new Date(inst.selectedYear, inst.selectedMonth, 1));
            triggerAjaxCall();
        }
    });

    if ($('#teacher_id').val() && $('#month').val()) {
        setTimeout(triggerAjaxCall, 500);
    }
});

function triggerAjaxCall() {
    var teacher_id = $('#teacher_id').val();
    var month = $('#month').val();

    if (teacher_id) {
        $.ajax({
            url: "{{ route('teacher.salary.find') }}",
            type: 'POST',
            data: {
                month: month,
                teacher_id: teacher_id,
                _token: '{{ csrf_token() }}'
            },
            success: function(data) {
                var currentPaid = parseFloat($('#amount').val()) || 0;
                var newDueAmount = data.salary + currentPaid - data.total_paid;
                $('#due_amount').val(newDueAmount);
                var updatedTotalPaid = data.total_paid - currentPaid;
                $('#total_paid').text('Previous Paid: ' + updatedTotalPaid);
                console.log("Remaining due: " + newDueAmount.toFixed(2));
            }

        });
    }
}

$(document).on('input', '#amount', function () {
    let receive = parseFloat($(this).val()) || 0;
    let totalAmount = parseFloat($('#total_amount').val()) || 0;
    let totalPaid = parseFloat($('#total_paid').text().replace('Previous Paid: ', '')) || 0;
    let dueAmount = totalAmount - totalPaid;

    if (receive > dueAmount) {
        toastr.error('Paid amount cannot be more than due amount.');
        receive = {{ $data->amount }}; // Reset to old value
        $(this).val(receive);
    }

    let due = totalAmount - totalPaid - receive;
    $('#due_amount').val(due);
});


$(document).ready(function() {
    let availableAmount = 0;

    function fetchAvailableAmount(fund_id) {
        if (fund_id) {
            $.ajax({
                url: "{{ route('fund.amount') }}",
                type: 'POST',
                data: {
                    fund_id: fund_id,
                    _token: '{{ csrf_token() }}'
                },
                success: function(data) {
                    availableAmount = parseFloat(data);
                    $('#availableAmount').text(availableAmount);
                    $('#showAmount').show();
                },
                error: function(xhr, status, error) {
                    console.log('Error:', error);
                }
            });
        } else {
            $('#showAmount').hide();
        }
    }

    // Fetch available amount on page load if fund is pre-selected
    const preSelectedFundId = $('#fund_id').val();
    if (preSelectedFundId) {
        fetchAvailableAmount(preSelectedFundId);
    }

    $('#fund_id').on('change', function() {
        var fund_id = $(this).val();
        fetchAvailableAmount(fund_id);
    });

    $('#amount').on('input', function() {
        var inputAmount = parseFloat($(this).val());

        if (inputAmount > availableAmount) {
            toastr.error('The amount cannot exceed the available amount of ' + availableAmount);
            $(this).val(availableAmount);
        }
    });
});


</script>
@endpush
@endsection
