@extends('dashboard.master')
@section('title', 'Teacher Salary Details')
@section('content')

<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Teacher Salary Details</b>
					</span>
				</div>

				<div class="page-title-actions">
                    <a title="Back Button" href="{{ route('teacher.index') }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
					<a title="Create Button" href="{{ route('teacher.create') }}" type="button" class="btn btn-sm btn-success">
                        <i class="fas fa-plus mr-1"></i>
                        Create
                    </a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">
                    <div class="row">
                        <div class="col-sm-12">
                        <table id="data_table" class="table table-bordered table-striped data-table table-hover">
                            <thead>
                                <tr class="btn-primary">
                                    <td colspan="2">Teacher Salary Details</td>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td width="30%">Date</td>
                                    <td>{{ Carbon\Carbon::parse($data->date)->format('d F, Y') ?? '--' }}</td>
                                </tr>

                                <tr>
                                    <td>Teacher ID</td>
                                    <td>{{ $data->teachers->reg_no ?? '--' }}</td>
                                </tr>

                                <tr>
                                    <td>Teacher Name</td>
                                    <td>{{ $data->teachers->name ?? '--' }}</td>
                                <tr>
                                    <td>Department</td>
                                    <td>{{ $data->teachers->departments->department_name ?? '--' }}</td>
                                </tr>

                                <tr>
                                    <td>Phone</td>
                                    <td>{{ $data->teachers->phone ?? '--' }}</td>
                                </tr>

                                <tr>
                                    <td>Email</td>
                                    <td>{{ $data->teachers->email ?? '--' }}</td>
                                </tr>

                                <tr>
                                    <td>Paid Type</td>
                                    <td>
                                        @if(6 == $data->transaction_type)
                                            Salary Pay
                                        @elseif(7 == $data->transaction_type)
                                            Due Pay
                                        @endif
                                    </td>
                                </tr>

                                <tr>
                                    <td>Salary Paid</td>
                                    <td>{{ number_format($data->amount) ?? '--' }} Tk</td>
                                </tr>

                            </tbody>
                        </table>
                        </div>

                    </div>
				</div>
			</div>
		</div>
	</section>
</div>

@endsection




