@extends('dashboard.master')
@section('title', 'Recruit Details')
@section('content')
@push('css')
<style type="text/css">
@media print {
    body * {
        visibility: hidden;
    }

    .printArea, .printArea * {
        visibility: visible;
    }

    .card-body {
        margin-top: 0;
    }
    #footer-img {
     position: relative;
        width: 100%;
        height: 150px;
        margin-top: 20px;
        bottom: 0 !important;
    }
    #footer-img img{
        position: relative;
        width: 100%;
        height: 150px;
        margin-top: 20px;
        bottom: 0 !important;
    }
}

</style>
@endpush

<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="page-title-wrapper">
                <div class="page-title-heading">
                    <div class="page-title-icon">
                        <i class="nav-icon fas fa-mosque"></i>
                    </div>
                    <span>
                        <b>Recruit Details</b>
                    </span>
                </div>

                <div class="page-title-actions">
                    <a title="Back Button" href="{{ URL::previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
                    <a title="Create Button" href="{{ route('teacher.create') }}" type="button" class="btn btn-sm btn-success">
                        <i class="fas fa-plus mr-1"></i>
                        Create
                    </a>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="card printArea">
                <div class="card-body">

                    <img id="header-img" src="{{ asset('img/' . $invoice->invoice_header) }}" alt="Header" style="width:100% !important; height:200px !important; margin-bottom:20px !important;top:0 !important">

                    <div class="row">
                        <div class="col-sm-6">
                            <table id="data_table" class="table table-bordered table-striped data-table table-hover">

                                <tbody>
                                    <tr>
                                        <td width="30%">Join Date</td>
                                        <td>{{ Carbon\Carbon::parse($data->join_date)->format('d F, Y') ?? '--' }}</td>
                                    </tr>

                                    <tr>
                                        <td>Reg ID</td>
                                        <td>{{ $data->reg_no ?? '--' }}</td>
                                    </tr>

                                    <tr>
                                        <td>Name</td>
                                        <td>{{ $data->name ?? '--' }}</td>
                                    </tr>

                                    <tr>
                                        <td>Gender</td>
                                        <td>
                                            @if($data->gender == 1)
                                                Male
                                            @elseif($data->gender == 2)
                                                Female
                                            @endif
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>Salary</td>
                                        <td>{{ $data->salary ?? '--' }}</td>
                                    </tr>

                                    <tr>
                                        <td>Phone</td>
                                        <td>{{ $data->phone ?? '--' }}</td>
                                    </tr>

                                    <tr>
                                        <td>Email</td>
                                        <td>{{ $data->email ?? '--' }}</td>
                                    </tr>

                                    <tr>
                                        <td>Blood Group</td>
                                        <td>{{ $data->blood_group ?? '--' }}</td>
                                    </tr>

                                    <tr>
                                        <td>Designation</td>
                                        <td>{{ $data->designation ?? '--' }}</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>

                        <div class="col-sm-6">
                            <table id="data_table" class="table table-bordered table-striped data-table table-hover">
                                <tbody>
                                    @php
                                        $cardNames = json_decode($data->card_name);
                                        $cardNumbers = json_decode($data->card_no);
                                        $cardPhotos = json_decode($data->card_photo);

                                        $examNames = json_decode($data->exam_name);
                                        $passingYears = json_decode($data->passing_year);
                                        $certificates = json_decode($data->certificate);
                                    @endphp

                                    <tr>
                                        <td>Exam Title</td>
                                        <td>
                                            @if(is_array($examNames) || is_object($examNames))
                                                @foreach($examNames as $examName)
                                                    <span>{{ $examName }}, </span>
                                                @endforeach
                                            @else
                                                <span>No exam titles available</span>
                                            @endif
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>Passing Year</td>
                                        <td>
                                            @if(is_array($passingYears) || is_object($passingYears))
                                                @foreach($passingYears as $passingYear)
                                                    <span> {{ $passingYear }} ,  </span>
                                                @endforeach
                                            @else
                                                <span>No passing years available</span>
                                            @endif
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>Certificate</td>
                                        <td>
                                            @if(is_array($certificates) || is_object($certificates))
                                                @foreach($certificates as $certificate)
                                                    <span> <img height="50px" width="100px" src="{{ asset('backend/img/teacher/'.$certificate )}}" alt="Certificate">, </span>
                                                @endforeach
                                            @else
                                                <span>No certificates available</span>
                                            @endif
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>Identity Card Name</td>
                                        <td>
                                            @if(is_array($cardNames) || is_object($cardNames))
                                                @foreach($cardNames as $cardName)
                                                    <span>
                                                        @if($cardName == 1) NID,
                                                        @elseif($cardName == 2) Passport,
                                                        @elseif($cardName == 3) Birth Certificate,
                                                        @elseif($cardName == 4) Driving License
                                                        @endif
                                                    </span>
                                                @endforeach
                                            @else
                                                <span>No identity card names available</span>
                                            @endif
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>Identity Card No</td>
                                        <td>
                                            @if(is_array($cardNumbers) || is_object($cardNumbers))
                                                @foreach($cardNumbers as $cardNumber)
                                                    <span> {{ $cardNumber }} ,  </span>
                                                @endforeach
                                            @else
                                                <span>No identity card numbers available</span>
                                            @endif
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>Identity Card Photo</td>
                                        <td>
                                            @if(is_array($cardPhotos) || is_object($cardPhotos))
                                                @foreach($cardPhotos as $cardPhoto)
                                                    <span> <img height="50px" width="100px" src="{{ asset('backend/img/teacher/'.$cardPhoto )}}" alt="ID Card Photo">, </span>
                                                @endforeach
                                            @else
                                                <span>No identity card photos available</span>
                                            @endif
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>Address</td>
                                        <td>{{ $data->address ?? '--' }}</td>
                                    </tr>

                                    <tr>
                                        <td>Description</td>
                                        <td>{{ $data->description ?? '--' }}</td>
                                    </tr>

                                    <tr>
                                        <td>Teacher Photo</td>
                                        <td>
                                            <img height="50px" width="100px" src="{{ asset('backend/img/teacher/'.$data->image)}}" alt="Photo">
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>Created By</td>
                                        <td>Super Admin</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div id="footer-img">
                        <img src="{{ asset('img/' . $invoice->invoice_footer) }}" alt="Footer" style="width:100%; height:150px !important;margin-top:20px !important;bottom:0 !important">
                    </div>

                </div>
            </div>
        </div>
    </section>
</div>

@push('js')
<script type="text/javascript">
    localStorage.clear();
    function auto_print() {
        window.print();
    }
    setTimeout(auto_print, 1000);
</script>
@endpush
@endsection
