<!DOCTYPE html>
<html>
@php
    $site = DB::table('settings')->first();
@endphp

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link rel="icon" href="{{ asset($site && $site->favicon ? 'img/' . $site->favicon : 'img/logo.png') }}" />
    <title>@yield('title', 'Befaqul Madaris Qaqmi Software')</title>

    <link rel="stylesheet" href="{{ asset('backend/plugins/fontawesome-free/css/all.min.css') }}">
    <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
    <link rel="stylesheet" href="{{ asset('backend/dist/css/adminlte.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/dist/css/custom.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/plugins/daterangepicker/daterangepicker.css') }}">
    <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=IBM+Plex+Sans:wght@400&display=swap" rel="stylesheet">

    {{-- DataTables CSS --}}
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap4.min.css">

    <style>
        @font-face {
            font-family: 'SolaimanLipi';
            src: url('{{ asset('fonts/SolaimanLipi_Bold_10-03-12.ttf') }}') format('truetype');
            font-weight: 800;
            font-style: normal;
            unicode-range: U+0980-09FF;
        }

        body {
            font-family: 'SolaimanLipi', 'times new roman', sans-serif;
            font-size: 14px;
        }

        /* Navbar */
        .bg-navbar-custom {
            background: rgba(245, 245, 245, 0.8);
            backdrop-filter: blur(10px);
            border-radius: 10px;
            box-shadow: 3px 3px 10px rgba(0, 0, 0, .1), -3px -3px 10px rgba(255, 255, 255, .6);
            padding: 12px 20px;
        }

        .navbar-title,
        .menu-icon i,
        .logout-btn a,
        .fullscreen-icon i {
            color: #000 !important;
        }

        .navbar-title {
            font-weight: bold;
            font-size: 16px;
            text-align: center;
            flex-grow: 1;
        }

        .menu-icon i {
            font-size: 20px;
            transition: .3s;
        }

        .menu-icon:hover i {
            transform: scale(1.1);
        }

        .user-info {
            font-weight: bold;
            font-size: 14px;
            background: rgba(255, 255, 255, .6);
            padding: 5px 12px;
            border-radius: 8px;
            box-shadow: inset 2px 2px 4px rgba(0, 0, 0, .1), inset -2px -2px 4px rgba(255, 255, 255, .5);
        }

        .logout-btn a {
            background: linear-gradient(145deg, #f5f5f5, #e0e0e0);
            padding: 6px 12px;
            border-radius: 8px;
            transition: .3s;
            display: flex;
            gap: 5px;
        }

        .logout-btn a:hover {
            background: linear-gradient(145deg, #e0e0e0, #c9c9c9);
            transform: translateY(-2px);
        }

        .fullscreen-icon i {
            font-size: 18px;
            transition: .3s;
        }

        .fullscreen-icon:hover i {
            transform: scale(1.1);
        }

        @media (max-width: 991px) {
            .user-info {
                font-size: 10px !important;
                display: inline-flex;
                align-items: center;
                justify-content: left;
            }

            .nav-item .logout-btn a {
                font-size: 10px !important;
                display: inline-flex;
                align-items: center;
                gap: 5px;
            }
        }

        /* Footer */
        .bg-footer-custom {
            background: rgba(255, 255, 255, .2);
            backdrop-filter: blur(12px);
            border-radius: 12px;
            box-shadow: 4px 4px 15px rgba(0, 0, 0, .1), -4px -4px 15px rgba(255, 255, 255, .6);
            padding: 14px 25px;
            border: 1px solid rgba(255, 255, 255, .3);
            display: flex;
            justify-content: space-between;
            align-items: center;
            text-align: center;
        }

        .bg-footer-custom strong,
        .bg-footer-custom a,
        .bg-footer-custom span {
            color: #000 !important;
            font-weight: bold;
        }

        .footer-right {
            font-size: 14px;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        /* small helpers */
        .gap-3 {
            gap: 12px;
        }

        .fw-bold {
            font-weight: bold;
        }
    </style>

    @stack('css')
</head>

<body class="hold-transition sidebar-mini layout-fixed">
    <div class="wrapper">

       <img id="header-img" src="{{ asset('img/' . $invoice->invoice_header) }}" alt="Header"
                            style="width:100%; height:150px; margin-bottom:20px;">
      

        <div class="" style="background-color: #f4f6f9">
            

            <section class="content">
                <div class="container-fluid">
                    {{-- Filter Section --}}
                    <div class="card filter-section">
                        <div class="card-body">
                            <div class="row align-items-end">
                                <div class="col-md-4">
                                    <label class="bangla">রেজিস্ট্রেশন নম্বর</label>
                                    <input type="text" id="regInput" class="form-control"
                                        placeholder="উদা: REG-2024-00123">
                                </div>
                                <div class="col-md-3">
                                    <button id="btnSearch" class="btn btn-primary mt-3 mt-md-0">সার্চ</button>
                                </div>

                                <div class="col-md-5">
                                     <div id="studentCard" class="p-3 rounded" style="background:#fff; display:none;">
                                <div class="d-flex align-items-center gap-3">
                                    <img id="stuPhoto" src="" alt="Photo"
                                        style="width:64px;height:64px;object-fit:cover;border-radius:8px;display:none;">
                                    <div>
                                        <div><b>নাম:</b> <span id="stuName"></span></div>
                                        <div><b>রেজিঃ</b> <span id="stuReg"></span> &nbsp; <b>রোল:</b> <span
                                                id="stuRoll"></span></div>
                                        <div><b>ক্লাস:</b> <span id="stuClass"></span> &nbsp; <b>সেশন:</b> <span
                                                id="stuSession"></span></div>
                                    </div>
                                </div>
                            </div>
                                </div>
                            </div>

                            <hr>

                            {{-- Student Summary Card --}}
                           
                        </div>
                    </div>
                    {{-- End Filter Section --}}

                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-12">
                                    <h5 class="mb-3">বেতন আদায় বাকি</h5>
                                    <div class="table-responsive">
                                        <table id="duesTable" class="table table-bordered table-striped w-100">
                                        <thead>
                                            <tr>
                                                <th>সিরিয়াল নম্বর</th>
                                                <th>মাস</th>
                                                <th>টোটাল</th>
                                                <th>পেইড</th>
                                                <th>ডিস্কাউন্ট</th>
                                                <th>ডিউ</th>
                                                <th>স্ট্যাটাস</th>
                                            </tr>
                                        </thead>
                                        <tbody></tbody>
                                    </table>

                                    </div>
                                    <hr>

                                </div>

                                <div class="col-md-6">
                                    <h5 class="mb-3">পরীক্ষার রেজাল্ট (সারাংশ)</h5>
                                   <div class="table-responsive">
                                     <table id="resultTable" class="table table-bordered table-striped w-100">
                                        <thead>
                                            <tr>
                                                <th>এক্সাম</th>
                                                <th>সেশন</th>
                                                <th>ক্লাস</th>
                                                <th>মোট নম্বর</th>
                                                <th>মোট এক্সাম</th>
                                                <th>%</th>
                                                <th>গ্রেড</th>
                                                <th>GPA</th>
                                            </tr>
                                        </thead>
                                        <tbody></tbody>
                                    </table>
                                   </div>

                                    <hr>
                                </div>

                                <div class="col-md-6">
                                    <h5 class="mb-3">হাজিরা (মাসভিত্তিক সারাংশ)</h5>
                                    <div class="table-responsive">
                                        <table id="attSummaryTable" class="table table-bordered table-striped w-100">
                                        <thead>
                                            <tr>
                                                <th>সিরিয়াল</th>
                                                <th>মাস</th>
                                                <th>মোট দিন</th>
                                                <th>উপস্থিত</th>
                                                <th>অনুপস্থিত</th>
                                                <th>% উপস্থিত</th>
                                                <th>% অনুপস্থিত</th>
                                            </tr>
                                        </thead>
                                        <tbody></tbody>
                                    </table>
                                    </div>
                                </div>
                            </div>




                        </div>
                    </div>
                </div>
            </section>
        </div>

      
    </div>

    <script src="{{ asset('backend/plugins/jquery/jquery.min.js') }}"></script>
    <script src="{{ asset('backend/plugins/jquery-ui/jquery-ui.min.js') }}"></script>
    <script src="{{ asset('backend/plugins/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ asset('backend/plugins/daterangepicker/daterangepicker.js') }}"></script>
    <script src="{{ asset('backend/dist/js/adminlte.js') }}"></script>

    {{-- DataTables JS --}}
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap4.min.js"></script>

    @stack('js')

    <script>
        function formatMonthLabel(ym) {
            if (!ym) return '';
            // expect "YYYY-MM" (pad if "YYYY-M")
            const [y, m] = ym.split('-');
            const year = Number(y);
            const month = Number(m.padStart(2, '0')) - 1; // 0-based
            if (isNaN(year) || isNaN(month)) return ym;

            const dt = new Date(year, month, 1);
            // বাংলা মাসের নাম
            const fmt = new Intl.DateTimeFormat('bn-BD', {
                month: 'long',
                year: 'numeric'
            });
            return fmt.format(dt); // যেমন: "জানুয়ারি ২০২৫"
        }

        let duesDT, resultDT, attDT;

        function initTables() {
            duesDT = $('#duesTable').DataTable({
                destroy: true,
                paging: true,
                searching: false,
                ordering: true,
                autoWidth: false,
                responsive: true,
                data: [], // তোমার AJAX/JS data এখানে bind করো
                columns: [{
                        data: null,
                        render: function(data, type, row, meta) {
                            return meta.row + 1; // সিরিয়াল নাম্বার
                        }
                    },
                    {
                        data: 'month',
                        render: function(d, type) {
                            // sort/type এর জন্য কাঁচা ভ্যালু, display/filter এ ফরম্যাট
                            if (type === 'sort' || type === 'type') return d;
                            return formatMonthLabel(d);
                        }
                    },
                    {
                        data: 'total_amount'
                    },
                    {
                        data: 'total_paid'
                    },
                    {
                        data: 'total_discount'
                    },
                    {
                        data: 'total_due'
                    },
                    {
                        data: 'status',
                        render: function(data, type, row) {
                            if (data === 'Paid') {
                                return '<span class="badge bg-success">' + data + '</span>';
                            } else if (data === 'Partially Paid') {
                                return '<span class="badge bg-warning text-dark">' + data + '</span>';
                            } else if (data === 'Due') {
                                return '<span class="badge bg-danger">' + data + '</span>';
                            }
                            return data;
                        }
                    }
                ]
            });

            resultDT = $('#resultTable').DataTable({
                destroy: true,
                paging: true,
                searching: false,
                columns: [{
                        data: 'exam'
                    },
                    {
                        data: 'session'
                    },
                    {
                        data: 'class'
                    },
                    {
                        data: 'total_mark'
                    },
                    {
                        data: 'total_exam'
                    },
                    {
                        data: 'percent',
                        render: (d) => d ? d + '%' : '0.00%'
                    },
                    {
                        data: 'grade'
                    },
                    {
                        data: 'gpa',
                        render: (d) => {
                            const val = parseFloat(d || '0');
                            return val === 0 ? '<span class="text-danger font-weight-bold">' + (d ??
                                '0.00') + '</span>' : d;
                        }
                    },
                ]
            });

            attDT = $('#attSummaryTable').DataTable({
                destroy: true,
                paging: true,
                searching: false,
                ordering: true,
                autoWidth: false,
                responsive: true,
                data: [], // AJAX success এ সেট হবে
                columns: [{
                        data: null,
                        render: (data, type, row, meta) => meta.row + 1
                    },
                    {
                        data: 'month',
                        render: function(d, type) {
                            if (type === 'sort' || type === 'type') return d;
                            return formatMonthLabel(d); // helper দিয়ে মাস ফরম্যাট
                        }
                    },
                    {
                        data: 'total_days'
                    },
                    {
                        data: 'present_days'
                    },
                    {
                        data: 'absent_days'
                    },
                    {
                        data: 'present_pct',
                        render: d => `<span class="badge bg-success">${d}%</span>`
                    },
                    {
                        data: 'absent_pct',
                        render: d => `<span class="badge bg-danger">${d}%</span>`
                    }
                ]
            });
        }

        function fillStudentCard(stu) {
            if (!stu) {
                $('#studentCard').hide();
                return;
            }
            $('#stuName').text(stu.name || '');
            $('#stuReg').text(stu.register_no || '');
            $('#stuRoll').text(stu.roll_no || '');
            $('#stuClass').text(stu.class || '');
            $('#stuSession').text(stu.session || '');
            console.log("student image", stu.image, stu);
            if (stu.image) {
                $('#stuPhoto').attr('src', stu.image).show();
            } else {
                $('#stuPhoto').hide();
            }
            $('#studentCard').show();
        }

        $(document).ready(function() {
            initTables();

            $('#btnSearch').on('click', function() {
                const reg = $('#regInput').val().trim();
                if (!reg) {
                    alert('রেজিস্ট্রেশন নম্বর লিখুন');
                    return;
                }

                $.ajax({
                    url: "{{ route('students.snapshot') }}",
                    method: 'GET',
                    data: {
                        reg
                    },
                    beforeSend: function() {
                        $('#btnSearch').prop('disabled', true).text('লোড হচ্ছে...');
                    },
                    success: function(res) {
                        fillStudentCard(res.student);
                        duesDT.clear().rows.add(res.dues || []).draw();
                        resultDT.clear().rows.add(res.results || []).draw();
                        attDT.clear().rows.add(res.attendance || []).draw();
                    },
                    error: function(xhr) {
                        const msg = xhr.responseJSON?.error || 'ডাটা পাওয়া যায়নি';
                        alert(msg);
                        fillStudentCard(null);
                        duesDT.clear().draw();
                        resultDT.clear().draw();
                        attDT.clear().draw();
                    },
                    complete: function() {
                        $('#btnSearch').prop('disabled', false).text('সার্চ');
                    }
                });
            });
        });
    </script>
</body>

</html>
